/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.thucydides.core.model.Rule;
import net.thucydides.core.model.RuleBackground;
import net.thucydides.core.requirements.reports.ScenarioOutcome;

public class ScenarioOutcomeGroup {
    private String ruleName = "";
    private String ruleDescription = "";
    private String backgroundTitle = "";
    private String backgroundDescription = "";
    private String id;
    private RuleBackground background;
    private final List<ScenarioOutcome> scenarios;

    public ScenarioOutcomeGroup(Rule rule, List<ScenarioOutcome> scenarios) {
        this(scenarios);
        this.ruleName = this.assureNotNull(rule.getName());
        this.ruleDescription = this.assureNotNull(rule.getDescription());
        if (rule.hasBackground()) {
            this.background = rule.getBackground();
            this.backgroundTitle = rule.getBackground().getName();
            this.backgroundDescription = rule.getBackground().getDescription();
        }
        this.id = UUID.randomUUID().toString();
    }

    private RuleBackground backgroundFrom(List<ScenarioOutcome> scenarios) {
        return scenarios.stream().filter(scenarioOutcome -> scenarioOutcome.getType().equalsIgnoreCase("background")).findFirst().map(scenarioOutcome -> new RuleBackground("Overall background", "Overall background description", scenarioOutcome.getSteps())).get();
    }

    public ScenarioOutcomeGroup(List<ScenarioOutcome> scenarios) {
        this.scenarios = scenarios;
        this.id = UUID.randomUUID().toString();
        if (this.backgroundScenariosIn(scenarios)) {
            this.background = this.backgroundFrom(scenarios);
        }
    }

    private boolean backgroundScenariosIn(List<ScenarioOutcome> scenarios) {
        return scenarios.stream().anyMatch(scenarioOutcome -> scenarioOutcome.getType().equalsIgnoreCase("background"));
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getRuleDescription() {
        return this.ruleDescription;
    }

    public boolean hasBackground() {
        return this.background != null;
    }

    public RuleBackground getBackground() {
        return this.background;
    }

    public List<String> getBackgroundSteps() {
        if (this.hasBackground()) {
            return this.background.getSteps();
        }
        if (this.hasBackgroundScenario()) {
            return this.getBackgroundScenario().getSteps();
        }
        return new ArrayList<String>();
    }

    public boolean hasBackgroundScenario() {
        return this.scenarios.stream().anyMatch(ScenarioOutcome::isBackground);
    }

    public ScenarioOutcome getBackgroundScenario() {
        return this.scenarios.stream().filter(ScenarioOutcome::isBackground).findFirst().get();
    }

    public List<ScenarioOutcome> getScenarios() {
        return this.scenarios;
    }

    public boolean hasScenarios() {
        return !this.scenarios.isEmpty();
    }

    public List<ScenarioOutcome> getMainScenarios() {
        return this.scenarios.stream().filter(scenarioOutcome -> !scenarioOutcome.isBackground()).filter(scenarioOutcome -> !scenarioOutcome.getName().isEmpty()).collect(Collectors.toList());
    }

    private String assureNotNull(String anyString) {
        if (anyString == null || anyString.isEmpty()) {
            return "";
        }
        return anyString;
    }

    public String getId() {
        return this.id;
    }

    public String getBackgroundTitle() {
        return this.backgroundTitle;
    }

    public String getBackgroundDescription() {
        return this.backgroundDescription;
    }

    public void setBackgroundTitle(String backgroundTitle) {
        this.backgroundTitle = backgroundTitle;
    }

    public void setBackgroundDescription(String backgroundDescription) {
        this.backgroundDescription = backgroundDescription;
    }
}

