/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.ResultReportingTask;
import net.thucydides.core.util.EnvironmentVariables;

public class ResultReports {
    public static List<ReportingTask> resultReportsFor(TestOutcomes testOutcomes, FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider) {
        ArrayList<ReportingTask> reportingTasks = new ArrayList<ReportingTask>();
        reportingTasks.addAll(ResultReports.resultReportsFor(freemarker, environmentVariables, outputDirectory, testOutcomes, reportNameProvider, TestTag.EMPTY_TAG));
        for (TestTag tag : testOutcomes.getTags()) {
            reportingTasks.addAll(ResultReports.resultReportsFor(freemarker, environmentVariables, outputDirectory, testOutcomes.withTag(tag), new ReportNameProvider(tag.getName()), tag));
        }
        return reportingTasks;
    }

    private static List<ReportingTask> resultReportsFor(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomesForThisTag, ReportNameProvider reportName, TestTag tag) {
        ArrayList<ReportingTask> tasks = new ArrayList<ReportingTask>();
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.SUCCESS) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getPassingTests(), reportName, tag, "success"));
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.PENDING) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getPendingTests(), reportName, tag, "pending"));
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.FAILURE) > 0 || testOutcomesForThisTag.getTotalTests().withResult(TestResult.ERROR) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getUnsuccessfulTests(), reportName, tag, "broken"));
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.FAILURE) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getFailingTests(), reportName, tag, "failure"));
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.ERROR) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getErrorTests(), reportName, tag, "error"));
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.COMPROMISED) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.getCompromisedTests(), reportName, tag, "compromised"));
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.IGNORED) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.havingResult(TestResult.IGNORED), reportName, tag, "ignored"));
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.SKIPPED) > 0) {
            tasks.add(ResultReports.resultReport(freemarker, environmentVariables, outputDirectory, testOutcomesForThisTag.havingResult(TestResult.SKIPPED), reportName, tag, "skipped"));
        }
        return tasks;
    }

    private static ReportingTask resultReport(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomes, ReportNameProvider reportName, TestTag tag, String testResult) {
        return new ResultReportingTask(freemarker, environmentVariables, outputDirectory, testOutcomes, reportName, tag, testResult);
    }
}

