/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.reports.ReportGenerationFailedError;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.ReportingTask;

class CopyProjectSpecificResourcesTask
extends HtmlReporter
implements ReportingTask {
    private static final String DEFAULT_ASSETS_DIRECTORIES = "src/test/resources/assets";

    CopyProjectSpecificResourcesTask() {
    }

    @Override
    public void generateReports() throws IOException {
        if (!this.assetSourcePath().toFile().exists()) {
            return;
        }
        Files.createDirectories(this.assetsDestinationDirectory(), new FileAttribute[0]);
        ((Stream)Files.list(this.assetSourcePath()).filter(this::notCopied).parallel()).forEach(this::copyToTarget);
    }

    private boolean notCopied(Path imageFile) {
        return !this.transferred(imageFile).toFile().exists();
    }

    private void copyToTarget(Path imageFile) {
        try {
            if (this.notCopied(imageFile)) {
                Files.copy(imageFile, this.transferred(imageFile), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (FileSystemException fileSystemException) {
        }
        catch (IOException e) {
            throw new ReportGenerationFailedError(e.getMessage(), (Throwable)e);
        }
    }

    private Path transferred(Path imageFile) {
        return this.assetsDestinationDirectory().resolve(imageFile.getFileName());
    }

    private Path assetSourcePath() {
        String assetDirectoryPath = ThucydidesSystemProperty.REPORT_ASSETS_DIRECTORY.from(this.getEnvironmentVariables(), DEFAULT_ASSETS_DIRECTORIES);
        return Paths.get(assetDirectoryPath, new String[0]);
    }

    private Path assetsDestinationDirectory() {
        return this.getOutputDirectory().toPath().resolve("assets");
    }
}

