/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.model.ReportData;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.TestOutcomes;

public class EvidenceData {
    private final String scenario;
    private final String title;
    private final String detailsLink;

    public EvidenceData(String scenario, String title, String detailsLink) {
        this.scenario = scenario;
        this.title = title;
        this.detailsLink = detailsLink;
    }

    public String getScenario() {
        return this.scenario;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDetailsLink() {
        return this.detailsLink;
    }

    public static List<EvidenceData> from(TestOutcomes testOutcomes) {
        ArrayList<EvidenceData> evidence = new ArrayList<EvidenceData>();
        for (TestOutcome testOutcome : testOutcomes.getOutcomes()) {
            for (ReportData reportData : testOutcome.getEvidence()) {
                evidence.add(new EvidenceData(testOutcome.getName(), reportData.getTitle(), EvidenceData.detailsLinkFor(testOutcome, reportData)));
            }
        }
        return evidence;
    }

    private static String detailsLinkFor(TestOutcome testOutcome, ReportData reportData) {
        if (reportData.getPath() != null) {
            return "<a role='button' target='_blank' class='btn btn-success btn-sm' href='" + reportData.getPath() + "'><i class='fas fa-download'></i>&nbsp;Download Evidence</a>";
        }
        String report = ReportNamer.forReportType((ReportType)ReportType.HTML).getNormalizedTestNameFor(testOutcome);
        return "<a role='button' class='btn btn-success btn-sm' href='" + report + "#" + reportData.getId() + "'><i class=\"fas fa-external-link-alt\"></i>&nbsp;Details</a>";
    }
}

