/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.tags;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.tags.EnvironmentDefinedTags;
import net.thucydides.core.adapters.TestFramework;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.html.CucumberCompatibleFilter;
import net.thucydides.core.util.EnvironmentVariables;

public class TagScanner {
    private final List<TestTag> providedTags;
    private final CucumberCompatibleFilter filter;

    public TagScanner(EnvironmentVariables environmentVariables) {
        this.filter = new CucumberCompatibleFilter(environmentVariables);
        this.providedTags = EnvironmentDefinedTags.definedIn(environmentVariables);
    }

    public boolean shouldRunForTags(List<String> tags) {
        return this.filter.matches(tags);
    }

    public boolean shouldRunClass(Class<?> testClass) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getClassTags();
        return this.filter.matchesTags(tags);
    }

    public boolean shouldRunMethod(Class<?> testClass, String methodName) {
        if (!this.isATaggable(testClass)) {
            return true;
        }
        List<TestTag> tags = TestAnnotations.forClass(testClass).getTagsForMethod(methodName);
        return this.filter.matchesTags(tags);
    }

    private boolean isATaggable(Class<?> testClass) {
        return TestFramework.support().isATaggableClass(testClass);
    }

    private boolean testClassMatchesAPositiveTag(Class<?> testClass, List<TestTag> expectedTags) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getClassTags();
        return this.containsAPositiveMatch(expectedTags, tags);
    }

    private boolean tagsMatchAPositiveTag(List<String> tagValues, List<TestTag> expectedTags) {
        List<TestTag> tags = this.definedIn(tagValues);
        return this.containsAPositiveMatch(expectedTags, tags);
    }

    private boolean tagsMatchANegativeTag(List<String> tagValues, List<TestTag> expectedTags) {
        List<TestTag> tags = this.definedIn(tagValues);
        return this.containsANegativeMatch(expectedTags, tags);
    }

    private List<TestTag> definedIn(List<String> tagValues) {
        return tagValues.stream().map(TestTag::withValue).collect(Collectors.toList());
    }

    private boolean containsAPositiveMatch(List<TestTag> expectedTags, List<TestTag> tags) {
        return this.positive(expectedTags).isEmpty() || this.tagsMatch(this.positive(expectedTags), tags);
    }

    private boolean testClassDoesNotMatchANegativeTag(Class<?> testClass, List<TestTag> negatedTags) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getClassTags();
        return !this.containsANegativeMatch(negatedTags, tags);
    }

    private List<TestTag> positive(List<TestTag> tags) {
        ArrayList<TestTag> positiveTags = new ArrayList<TestTag>();
        for (TestTag tag : tags) {
            if (this.isANegative(tag)) continue;
            positiveTags.add(tag);
        }
        return positiveTags;
    }

    private boolean isANegative(TestTag tag) {
        return tag.getType().startsWith("~");
    }

    private List<TestTag> negative(List<TestTag> tags) {
        ArrayList<TestTag> negativeTags = new ArrayList<TestTag>();
        for (TestTag tag : tags) {
            if (!this.isANegative(tag)) continue;
            negativeTags.add(TestTag.withName(tag.getName()).andType(tag.getType().substring(1)));
        }
        return negativeTags;
    }

    private boolean testMethodMatchesAPositiveTag(Class<?> testClass, String methodName, List<TestTag> expectedTags) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getTagsForMethod(methodName);
        return this.containsAPositiveMatch(expectedTags, tags);
    }

    private boolean testMethodDoesNotMatchANegativeTag(Class<?> testClass, String methodName, List<TestTag> expectedTags) {
        List<TestTag> tags = TestAnnotations.forClass(testClass).getTagsForMethod(methodName);
        return !this.containsANegativeMatch(expectedTags, tags);
    }

    private boolean containsANegativeMatch(List<TestTag> expectedTags, List<TestTag> tags) {
        if (this.negative(expectedTags).isEmpty()) {
            return false;
        }
        return this.tagsMatch(this.negative(expectedTags), tags);
    }

    private boolean tagsMatch(List<TestTag> expectedTags, List<TestTag> tags) {
        for (TestTag expectedTag : expectedTags) {
            if (!tags.contains(expectedTag)) continue;
            return true;
        }
        return false;
    }
}

