/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.featuretags.FeatureFileStrategy;
import net.thucydides.core.model.featuretags.FeatureTagStrategy;
import net.thucydides.core.model.featuretags.NoFeatureStrategy;
import net.thucydides.core.model.featuretags.StoryFileStrategy;
import net.thucydides.core.requirements.model.FeatureType;

public class FeatureTagAsDefined {
    private static final Map<FeatureType, FeatureTagStrategy> FEATURE_STRATEGY_MAP = new HashMap<FeatureType, FeatureTagStrategy>();

    public static Optional<TestTag> in(Story story, String path) {
        return FEATURE_STRATEGY_MAP.get((Object)FeatureTagAsDefined.featureTypeFor(story, path)).getFeatureTag(story, path);
    }

    private static FeatureType featureTypeFor(Story story, String path) {
        if (story != null && story.getType() == "feature") {
            return FeatureType.FEATURE;
        }
        if (path != null && path.endsWith(".feature")) {
            return FeatureType.FEATURE;
        }
        if (story != null && story.getType() == "story") {
            return FeatureType.STORY;
        }
        if (path != null && path.endsWith(".story")) {
            return FeatureType.STORY;
        }
        return FeatureType.UNDEFINED;
    }

    static {
        FEATURE_STRATEGY_MAP.put(FeatureType.FEATURE, new FeatureFileStrategy());
        FEATURE_STRATEGY_MAP.put(FeatureType.STORY, new StoryFileStrategy());
        FEATURE_STRATEGY_MAP.put(FeatureType.UNDEFINED, new NoFeatureStrategy());
    }
}

