/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import io.cucumber.messages.Messages;
import java.util.Optional;
import net.thucydides.core.requirements.model.cucumber.ExampleTableInMarkdown;
import net.thucydides.core.requirements.model.cucumber.NamedExampleTable;
import net.thucydides.core.requirements.model.cucumber.ScenarioDisplayOption;
import net.thucydides.core.requirements.model.cucumber.ScenarioReport;

public class IdentifiedExampleTable
extends NamedExampleTable {
    private Messages.GherkinDocument.Feature feature;
    private String scenarioReport;
    private Messages.GherkinDocument.Feature.Scenario scenarioDefinition;
    private String exampleTableName;
    private ExampleTableInMarkdown exampleTableInMarkdown;

    protected IdentifiedExampleTable(Messages.GherkinDocument.Feature feature, Messages.GherkinDocument.Feature.Scenario scenarioDefinition, String exampleTableName) {
        this.feature = feature;
        this.scenarioReport = ScenarioReport.forScenario(scenarioDefinition.getName()).inFeature(feature);
        this.scenarioDefinition = scenarioDefinition;
        this.exampleTableName = exampleTableName;
        this.exampleTableInMarkdown = new ExampleTableInMarkdown(feature, this.scenarioReport, scenarioDefinition);
    }

    @Override
    public Optional<String> asExampleTable() {
        return this.asExampleTable(ScenarioDisplayOption.WithNoTitle);
    }

    @Override
    public Optional<String> asExampleTable(ScenarioDisplayOption withDisplayOption) {
        if (this.scenarioDefinition.getExamplesCount() == 0) {
            return Optional.empty();
        }
        int exampleRow = 0;
        for (Messages.GherkinDocument.Feature.Scenario.Examples example : this.scenarioDefinition.getExamplesList()) {
            if (example.getName().equalsIgnoreCase(this.exampleTableName.trim())) {
                return Optional.of(this.exampleTableInMarkdown.renderedFormOf(example, exampleRow, withDisplayOption));
            }
            ++exampleRow;
        }
        return Optional.empty();
    }
}

