/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.specflow;

import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.reports.adaptors.specflow.SpecflowTableRow;

public class SpecflowScenario {
    private final String titleLine;
    private List<String> steps = new ArrayList<String>();
    private List<SpecflowTableRow> rows;

    public SpecflowScenario(String titleLine) {
        this.titleLine = titleLine;
    }

    public String getTitleLine() {
        return this.titleLine;
    }

    public void addSteps(List<String> blockSteps) {
        this.steps.addAll(NewList.copyOf(blockSteps));
    }

    public List<String> getSteps() {
        return NewList.copyOf(this.steps);
    }

    public void convertToTable(String firstRowTitle) {
        if (this.rows == null) {
            this.rows = new ArrayList<SpecflowTableRow>();
            this.addRow(firstRowTitle, this.steps);
            this.steps.clear();
        }
    }

    public boolean usesDataTable() {
        return this.rows != null;
    }

    public void addRow(String rowTitle, List<String> rowSteps) {
        this.rows.add(new SpecflowTableRow(rowTitle, NewList.copyOf(rowSteps)));
    }

    public List<SpecflowTableRow> getRows() {
        return NewList.copyOf(this.rows);
    }
}

