/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.digest.Digest;
import net.thucydides.core.model.TestResult;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ScenarioOutcome {
    private final String name;
    private final String type;
    private final String id;
    private final TestResult result;
    private final String scenarioReport;
    private final String description;
    private final List<String> steps;
    private final List<String> examples;
    private final int exampleCount;
    private final ZonedDateTime startTime;
    private final Long duration;
    private final boolean manual;
    private final String parentName;
    private final String parentReport;

    public ScenarioOutcome(String name, String type, TestResult result, String scenarioReport, ZonedDateTime startTime, Long duration) {
        this.name = name;
        this.type = type;
        this.id = Digest.ofTextValue(name);
        this.result = result;
        this.scenarioReport = scenarioReport;
        this.startTime = startTime;
        this.duration = duration;
        this.description = "";
        this.steps = Collections.EMPTY_LIST;
        this.examples = Collections.EMPTY_LIST;
        this.exampleCount = 0;
        this.manual = false;
        this.parentReport = "";
        this.parentName = "";
    }

    public ScenarioOutcome(String name, String type, TestResult result, String scenarioReport, ZonedDateTime startTime, Long duration, Boolean manual, String description, List<String> steps, List<String> examples, int exampleCount, String parentName, String parentReport) {
        this.name = name;
        this.type = type;
        this.id = Digest.ofTextValue(name);
        this.result = result;
        this.scenarioReport = scenarioReport;
        this.startTime = startTime;
        this.duration = duration;
        this.manual = manual;
        this.description = description;
        this.steps = steps;
        this.examples = examples;
        this.exampleCount = exampleCount;
        this.parentName = parentName;
        this.parentReport = parentReport;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        if ("Background".equalsIgnoreCase(this.type)) {
            return this.backgroundTitle();
        }
        return this.name;
    }

    private String backgroundTitle() {
        if (this.name.isEmpty()) {
            return "Background";
        }
        return "Background: " + this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public TestResult getResult() {
        return this.result;
    }

    public String getResultStyle() {
        return this.result.name().toLowerCase();
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public boolean hasExamples() {
        return this.exampleCount > 0;
    }

    public String getNumberOfExamples() {
        return this.exampleCount == 1 ? "1 example" : this.exampleCount + " examples";
    }

    public String getScenarioReport() {
        return this.scenarioReport;
    }

    public Integer getStepCount() {
        return this.steps.size();
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public boolean isManual() {
        return this.manual;
    }

    public String getFormattedStartTime() {
        return this.startTime != null ? this.startTime.format(DateTimeFormatter.ofPattern("HH:mm:ss")) : " ";
    }

    public String getFormattedDuration() {
        return this.duration != 0L ? DurationFormatUtils.formatDuration((long)this.duration, (String)"mm:ss") : " ";
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getParentReport() {
        return this.parentReport;
    }
}

