/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.screenshots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;

public class ScreenshotPreferencesByClass {
    private static final String SERENITY_TAKE_SCREENSHOTS_FOR = "serenity.take.screenshots.for.";
    private final Class<?> declaringClass;
    private final Map<String, TakeScreenshots> classNameToScreenshotPreference;

    ScreenshotPreferencesByClass(Class<?> declaringClass, EnvironmentVariables environmentVariables) {
        this.declaringClass = declaringClass;
        this.classNameToScreenshotPreference = this.classNameToScreenshotPreferencesDefinedIn(environmentVariables);
    }

    private Map<String, TakeScreenshots> classNameToScreenshotPreferencesDefinedIn(EnvironmentVariables environmentVariables) {
        HashMap<String, TakeScreenshots> screenshotPreference = new HashMap<String, TakeScreenshots>();
        for (String key : environmentVariables.getKeys()) {
            if (!key.startsWith(SERENITY_TAKE_SCREENSHOTS_FOR)) continue;
            screenshotPreference.put(this.singularClassNameFrom(key).toLowerCase(), this.screenshotPreferenceValueFrom(environmentVariables.getProperty(key)));
            screenshotPreference.put(this.pluralClassNameFrom(key).toLowerCase(), this.screenshotPreferenceValueFrom(environmentVariables.getProperty(key)));
        }
        return screenshotPreference;
    }

    private TakeScreenshots screenshotPreferenceValueFrom(String screenshotPreference) {
        try {
            return TakeScreenshots.valueOf(screenshotPreference.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Incorrectly configured screenshot value '" + screenshotPreference + "' for serenity.take.screenshots - should be one of " + Arrays.toString((Object[])TakeScreenshots.values()));
        }
    }

    private String singularClassNameFrom(String key) {
        String simpleClassName = key.replace(SERENITY_TAKE_SCREENSHOTS_FOR, "");
        return new Inflector().singularize(simpleClassName);
    }

    private String pluralClassNameFrom(String key) {
        String simpleClassName = key.replace(SERENITY_TAKE_SCREENSHOTS_FOR, "");
        return new Inflector().pluralize(simpleClassName);
    }

    public static ScreenshotPreferencesByClassBuilder forClass(Class<?> declaringClass) {
        return new ScreenshotPreferencesByClassBuilder(declaringClass);
    }

    public Optional<TakeScreenshots> getScreenshotPreference() {
        List<Class<?>> candidateClasses = this.getSuperClassesAndInterfacesFrom(this.declaringClass);
        for (Class<?> candidateClass : candidateClasses) {
            String className = candidateClass.getSimpleName().toLowerCase();
            if (!this.classNameToScreenshotPreference.containsKey(className)) continue;
            return Optional.of(this.classNameToScreenshotPreference.get(className));
        }
        return Optional.empty();
    }

    private List<Class<?>> getSuperClassesAndInterfacesFrom(Class<?> declaringClass) {
        ArrayList superClassesAndInterfaces = new ArrayList();
        superClassesAndInterfaces.add(declaringClass);
        Collection<Class<?>> superClasses = this.superclassesFrom(declaringClass);
        superClassesAndInterfaces.addAll(this.superclassesFrom(declaringClass));
        superClassesAndInterfaces.addAll(this.interfacesFrom(declaringClass));
        superClassesAndInterfaces.addAll(this.allInterfacesFrom(superClasses));
        return superClassesAndInterfaces;
    }

    private Collection<Class<?>> interfacesFrom(Class<?> declaringClass) {
        ArrayList interfaces = new ArrayList();
        interfaces.addAll(Arrays.asList(declaringClass.getInterfaces()));
        for (Class<?> anInterface : declaringClass.getInterfaces()) {
            interfaces.addAll(this.superclassesFrom(anInterface));
            interfaces.addAll(this.interfacesFrom(anInterface));
        }
        return interfaces;
    }

    private Collection<Class<?>> allInterfacesFrom(Collection<Class<?>> superclasses) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> superclass : superclasses) {
            interfaces.addAll(this.interfacesFrom(superclass));
        }
        return interfaces;
    }

    private Collection<Class<?>> superclassesFrom(Class<?> declaringClass) {
        ArrayList superClasses = new ArrayList();
        for (Class<?> superClass = declaringClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            superClasses.add(superClass);
        }
        return superClasses;
    }

    public static class ScreenshotPreferencesByClassBuilder {
        private final Class<?> declaringClass;

        ScreenshotPreferencesByClassBuilder(Class<?> declaringClass) {
            this.declaringClass = declaringClass;
        }

        public ScreenshotPreferencesByClass withEnvironmentVariables(EnvironmentVariables environmentVariables) {
            return new ScreenshotPreferencesByClass(this.declaringClass, environmentVariables);
        }
    }
}

