/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.requirements.RootDirectory;
import net.thucydides.core.requirements.SearchForFilesOfType;
import net.thucydides.core.requirements.model.RequirementTypeAt;
import net.thucydides.core.util.EnvironmentVariables;

public class RequirementsConfiguration {
    public static final List<String> DEFAULT_CAPABILITY_TYPES = NewList.of("capability", "feature", "story");
    private static final String DEFAULT_ROOT_DIRECTORY = "stories";
    private final EnvironmentVariables environmentVariables;
    private Optional<Path> root;
    SearchForFilesOfType jbehaveFileMatcher;
    private SearchForFilesOfType cucumberFileMatcher;

    public RequirementsConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.root = RootDirectory.definedIn(environmentVariables).featuresOrStoriesRootDirectory();
    }

    public RequirementsConfiguration(EnvironmentVariables environmentVariables, String rootDirectory) {
        this.environmentVariables = environmentVariables;
        this.root = Optional.of(Paths.get(this.absolutePathOfDirectoryOnClasspath(rootDirectory), new String[0]));
    }

    private String absolutePathOfDirectoryOnClasspath(String rootDirectory) {
        URL rootDirOnClasspath = this.getClass().getClassLoader().getResource(rootDirectory);
        if (rootDirOnClasspath != null) {
            return rootDirOnClasspath.getFile();
        }
        return rootDirectory;
    }

    public List<String> getRequirementTypes() {
        return this.configuredRequirementTypes().orElse(this.getDefaultCapabilityTypes());
    }

    private Optional<List<String>> configuredRequirementTypes() {
        if (ThucydidesSystemProperty.SERENITY_REQUIREMENT_TYPES.isDefinedIn(this.environmentVariables)) {
            String configuredRequirementTypes = ThucydidesSystemProperty.SERENITY_REQUIREMENT_TYPES.from(this.environmentVariables);
            return Optional.of(Splitter.on((String)",").trimResults().splitToList((CharSequence)configuredRequirementTypes));
        }
        return Optional.empty();
    }

    public String getDefaultRootDirectory() {
        if (ThucydidesSystemProperty.SERENITY_ANNOTATED_REQUIREMENTS_DIR.isDefinedIn(this.environmentVariables)) {
            return ThucydidesSystemProperty.SERENITY_ANNOTATED_REQUIREMENTS_DIR.from(this.environmentVariables);
        }
        return DEFAULT_ROOT_DIRECTORY;
    }

    public List<String> getDefaultCapabilityTypes() {
        if (this.jbehaveFilesExist()) {
            return this.jbehaveCapabilityTypes();
        }
        if (this.cucumberFilesExist()) {
            return this.cucumberCapabilityTypes();
        }
        return DEFAULT_CAPABILITY_TYPES;
    }

    private List<String> jbehaveCapabilityTypes() {
        int featureDirectoryDepth = this.getJBehaveFileMatcher().get().getMaxDepth();
        switch (featureDirectoryDepth) {
            case 0: {
                return NewList.of("story");
            }
            case 1: {
                return NewList.of("feature", "story");
            }
        }
        return NewList.of("capability", "feature", "story");
    }

    private List<String> cucumberCapabilityTypes() {
        int featureDirectoryDepth = this.getCucumberFileMatcher().get().getMaxDepth();
        switch (featureDirectoryDepth) {
            case 0: {
                return NewList.of("feature");
            }
            case 1: {
                return NewList.of("capability", "feature");
            }
        }
        return NewList.of("theme", "capability", "feature");
    }

    private Optional<SearchForFilesOfType> getJBehaveFileMatcher() {
        if (this.jbehaveFileMatcher != null) {
            return Optional.of(this.jbehaveFileMatcher);
        }
        try {
            if (this.root.isPresent()) {
                this.jbehaveFileMatcher = new SearchForFilesOfType(this.root.get(), ".story");
                Files.walkFileTree(this.root.get(), this.jbehaveFileMatcher);
                return Optional.of(this.jbehaveFileMatcher);
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public String getRequirementType(int level) {
        return RequirementTypeAt.level(level).in(this.getRequirementTypes());
    }

    private Optional<SearchForFilesOfType> getCucumberFileMatcher() {
        if (this.cucumberFileMatcher != null) {
            return Optional.of(this.cucumberFileMatcher);
        }
        try {
            if (this.root.isPresent()) {
                this.cucumberFileMatcher = new SearchForFilesOfType(this.root.get(), ".feature");
                Files.walkFileTree(this.root.get(), this.cucumberFileMatcher);
                return Optional.of(this.cucumberFileMatcher);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
        return Optional.empty();
    }

    private boolean jbehaveFilesExist() {
        return this.getJBehaveFileMatcher().isPresent() && this.getJBehaveFileMatcher().get().hasMatchingFiles();
    }

    private boolean cucumberFilesExist() {
        return this.getCucumberFileMatcher().isPresent() && this.getCucumberFileMatcher().get().hasMatchingFiles();
    }

    public int startLevelForADepthOf(int requirementsDepth) {
        return Math.max(0, this.getRequirementTypes().size() - requirementsDepth);
    }
}

