/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.model.CustomFieldValue;
import net.thucydides.core.requirements.model.Example;
import net.thucydides.core.requirements.model.RequirementBuilderNameStep;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class Requirement
implements Comparable {
    private String displayName;
    private String name;
    private String id;
    private String type;
    private String path;
    private String featureFileName;
    private CustomFieldValue narrative;
    private String cardNumber;
    private List<Requirement> children;
    private String parent;
    private List<Example> examples;
    private List<String> releaseVersions;
    private List<CustomFieldValue> customFields;
    private List<TestTag> tags = new ArrayList<TestTag>();

    public Requirement() {
        this.children = new ArrayList<Requirement>();
        this.examples = new ArrayList<Example>();
        this.releaseVersions = new ArrayList<String>();
        this.customFields = new ArrayList<CustomFieldValue>();
    }

    protected Requirement(String name, String id, String displayName, String cardNumber, String parent, String type, CustomFieldValue narrative, List<Requirement> children, List<Example> examples, List<String> releaseVersions) {
        this(name, id, displayName, cardNumber, parent, type, "", narrative, children, examples, releaseVersions, Collections.EMPTY_LIST);
    }

    protected Requirement(String name, String id, String displayName, String cardNumber, String parent, String type, CustomFieldValue narrative) {
        this(name, id, displayName, cardNumber, parent, type, "", narrative, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    protected Requirement(String name, String id, String displayName, String cardNumber, String parent, String type, String path, CustomFieldValue narrative, List<Requirement> children, List<Example> examples, List<String> releaseVersions, List<CustomFieldValue> customFields, String featureFileName) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        this.name = name;
        this.id = id;
        this.displayName = displayName != null ? displayName : name;
        this.cardNumber = cardNumber;
        this.type = type;
        this.path = path;
        this.parent = parent;
        this.narrative = narrative;
        this.children = new ArrayList<Requirement>(children);
        this.examples = new ArrayList<Example>(examples);
        this.releaseVersions = NewList.copyOf(releaseVersions);
        this.customFields = NewList.copyOf(customFields);
        this.featureFileName = featureFileName;
        this.tags = new ArrayList<TestTag>();
    }

    protected Requirement(String name, String id, String displayName, String cardNumber, String parent, String type, String path, CustomFieldValue narrative, List<Requirement> children, List<Example> examples, List<String> releaseVersions, List<CustomFieldValue> customFields, String featureFileName, List<TestTag> tags) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        this.name = name;
        this.id = id;
        this.displayName = displayName != null ? displayName : name;
        this.cardNumber = cardNumber;
        this.type = type;
        this.path = path;
        this.parent = parent;
        this.narrative = narrative;
        this.children = new ArrayList<Requirement>(children);
        this.examples = new ArrayList<Example>(examples);
        this.releaseVersions = NewList.copyOf(releaseVersions);
        this.customFields = NewList.copyOf(customFields);
        this.featureFileName = featureFileName;
        this.tags = tags;
    }

    protected Requirement(String name, String id, String displayName, String cardNumber, String parent, String type, String path, CustomFieldValue narrative, List<Requirement> children, List<Example> examples, List<String> releaseVersions, List<CustomFieldValue> customFields) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        this.name = name;
        this.id = id;
        this.displayName = displayName != null ? displayName : name;
        this.cardNumber = cardNumber;
        this.type = type;
        this.parent = parent;
        this.narrative = narrative;
        this.children = NewList.copyOf(children);
        this.examples = NewList.copyOf(examples);
        this.releaseVersions = NewList.copyOf(releaseVersions);
        this.customFields = NewList.copyOf(customFields);
        this.path = path;
        this.tags = new ArrayList<TestTag>();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.name;
    }

    public String getType() {
        return this.type;
    }

    public String childType() {
        return !this.children.isEmpty() ? this.children.get(0).getType() : null;
    }

    public CustomFieldValue getNarrative() {
        return this.narrative;
    }

    public List<String> getReleaseVersions() {
        return this.releaseVersions;
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public String getParent() {
        return this.parent;
    }

    public List<Requirement> getChildren() {
        return NewList.copyOf(this.children);
    }

    public List<Example> getExamples() {
        return NewList.copyOf(this.examples);
    }

    public Boolean hasExamples() {
        return !this.examples.isEmpty();
    }

    public int getExampleCount() {
        return this.examples.size();
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public int compareTo(Object otherRequirement) {
        return this.name.compareTo(((Requirement)otherRequirement).getName());
    }

    public static RequirementBuilderNameStep named(String name) {
        return new RequirementBuilderNameStep(name);
    }

    public Requirement definedInFile(File featureFile) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, featureFile.getName(), this.tags);
    }

    public Requirement withChildren(List<Requirement> children) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, this.tags);
    }

    public void setChildren(List<Requirement> children) {
        this.children = NewList.copyOf(children);
    }

    public Requirement withParent(String parent) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, parent, this.type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, this.tags);
    }

    public Requirement withType(String type) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, this.tags);
    }

    public Requirement withDisplayName(String displayName) {
        return new Requirement(this.name, this.id, displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, this.tags);
    }

    public Requirement withFeatureFileyName(String featureFileName) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, featureFileName, this.tags);
    }

    public Requirement withExample(Example example) {
        ArrayList<Example> updatedExamples = new ArrayList<Example>(this.examples);
        updatedExamples.add(example);
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, updatedExamples, this.releaseVersions, this.customFields, this.featureFileName, this.tags);
    }

    public Requirement withExamples(List<Example> examples) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, examples, this.releaseVersions, this.customFields, this.featureFileName, this.tags);
    }

    public Requirement withReleaseVersions(List<String> releaseVersions) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, this.examples, releaseVersions, this.customFields, this.featureFileName, this.tags);
    }

    public Requirement withCustomFields(List<CustomFieldValue> customFields) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, customFields, this.featureFileName, this.tags);
    }

    public Requirement withPath(String path) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, this.tags);
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<Requirement> getNestedChildren() {
        ArrayList<Requirement> nestedChildren = new ArrayList<Requirement>();
        for (Requirement child : this.children) {
            nestedChildren.add(child);
            nestedChildren.addAll(child.getNestedChildren());
        }
        return NewList.copyOf(nestedChildren);
    }

    public List<TestTag> getTags() {
        return new ArrayList<TestTag>(this.tags);
    }

    public TestTag asTag() {
        return TestTag.withName(this.qualifiedName()).andType(this.getType()).withDisplayName(this.displayName);
    }

    public TestTag asUnqualifiedTag() {
        return TestTag.withName(this.getName()).andType(this.getType()).withDisplayName(this.displayName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Requirement that = (Requirement)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public boolean matches(Requirement that) {
        boolean cardNumberMatches;
        boolean typesMatch;
        boolean namesMatch;
        boolean bl = this.name != null ? this.name.equals(that.name) : (namesMatch = that.name == null);
        boolean bl2 = this.type != null ? this.type.equals(that.type) : (typesMatch = that.type == null);
        boolean bl3 = StringUtils.isNotEmpty((CharSequence)this.cardNumber) ? this.cardNumber.equals(that.cardNumber) : (cardNumberMatches = that.cardNumber == null);
        boolean parentsMatch = this.parent != null ? this.parent.equals(that.parent) : that.parent == null;
        return namesMatch && typesMatch && cardNumberMatches && parentsMatch;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Requirement{name='" + this.name + '\'' + ", type='" + this.type + '\'' + " parent = '" + this.parent + '\'' + ", cardNumber='" + this.cardNumber + '\'' + '}';
    }

    public Requirement withChild(Requirement child) {
        ArrayList<Requirement> newChildren = new ArrayList<Requirement>(this.children);
        newChildren.remove(child);
        newChildren.add(child);
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.narrative, newChildren, this.examples, this.releaseVersions).withTags(this.tags);
    }

    public CustomFieldSetter withCustomField(String fieldName) {
        return new CustomFieldSetter(this, fieldName);
    }

    public List<CustomFieldValue> getCustomFieldValues() {
        return NewList.copyOf(this.customFields);
    }

    public Optional<CustomFieldValue> getCustomField(String fieldName) {
        for (CustomFieldValue field : this.customFields) {
            if (!field.getName().equals(fieldName)) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    public List<String> getCustomFields() {
        ArrayList<String> customFieldNames = new ArrayList<String>();
        for (CustomFieldValue field : this.customFields) {
            customFieldNames.add(field.getName());
        }
        return customFieldNames;
    }

    public String getFeatureFileName() {
        return this.featureFileName;
    }

    public String qualifiedName() {
        return StringUtils.isNotEmpty((CharSequence)this.qualifier()) ? this.qualifier() + "/" + this.getName() : this.getName();
    }

    public String qualifier() {
        return this.getParent() != null ? this.getParent() : null;
    }

    public boolean matchesTag(TestTag testTag) {
        TestTag requirementTag = this.asTag();
        return requirementTag.isAsOrMoreSpecificThan(testTag);
    }

    public Requirement merge(Requirement newRequirement) {
        String mergedCardNumber = StringUtils.isEmpty((CharSequence)this.cardNumber) ? newRequirement.cardNumber : this.cardNumber;
        String mergedDisplayName = StringUtils.isEmpty((CharSequence)this.displayName) || this.name.equalsIgnoreCase(this.displayName) ? newRequirement.displayName : this.displayName;
        String mergedNarrativeText = StringUtils.isEmpty((CharSequence)this.narrative.getText()) ? newRequirement.narrative.getText() : this.narrative.getText();
        String mergedPath = StringUtils.isEmpty((CharSequence)this.path) ? newRequirement.path : this.path;
        String mergedFeatureFileName = StringUtils.isEmpty((CharSequence)this.featureFileName) ? newRequirement.featureFileName : this.featureFileName;
        List mergedReleasVersions = ListUtils.union(this.releaseVersions, newRequirement.releaseVersions);
        List mergedExamples = ListUtils.union(this.examples, newRequirement.examples);
        List mergedCustomFields = ListUtils.union(this.customFields, newRequirement.customFields);
        List<Requirement> mergedChildren = this.mergeRequirementLists(this.children, newRequirement.children);
        return Requirement.named(this.name).withOptionalParent(this.parent).withOptionalCardNumber(mergedCardNumber).withType(this.type).withNarrative(mergedNarrativeText).withPath(mergedPath).withDisplayName(mergedDisplayName).withReleaseVersions(mergedReleasVersions).withExamples(mergedExamples).withCustomFields(mergedCustomFields).withFeatureFileyName(mergedFeatureFileName).withChildren(mergedChildren).withTags(this.tags);
    }

    private List<Requirement> mergeRequirementLists(List<Requirement> existingChilden, List<Requirement> newChildren) {
        ArrayList<Requirement> mergedChildren = new ArrayList<Requirement>(existingChilden);
        for (Requirement newChild : newChildren) {
            if (mergedChildren.contains(newChild)) {
                Requirement existingChild = (Requirement)mergedChildren.remove(mergedChildren.indexOf(newChild));
                mergedChildren.add(existingChild.merge(newChild));
                continue;
            }
            mergedChildren.add(newChild);
        }
        return NewList.copyOf(mergedChildren);
    }

    public Requirement withNarrative(String narrativeText) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, new CustomFieldValue("Narrative", narrativeText), this.children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, this.tags);
    }

    public String getPath() {
        return this.path;
    }

    public Requirement withTags(List<TestTag> tags) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, tags);
    }

    public static class CustomFieldSetter {
        Requirement requirement;
        String fieldName;

        public CustomFieldSetter(Requirement requirement, String fieldName) {
            this.requirement = requirement;
            this.fieldName = fieldName;
        }

        public Requirement setTo(String value, String renderedValue) {
            ArrayList<CustomFieldValue> customFields = new ArrayList<CustomFieldValue>(this.requirement.getCustomFieldValues());
            customFields.add(new CustomFieldValue(this.fieldName, value, renderedValue));
            return new Requirement(this.requirement.name, this.requirement.id, this.requirement.displayName, this.requirement.cardNumber, this.requirement.parent, this.requirement.type, this.requirement.path, this.requirement.narrative, this.requirement.children, this.requirement.examples, this.requirement.releaseVersions, customFields).withTags(this.requirement.tags);
        }

        public Requirement setTo(String value) {
            return this.setTo(value, null);
        }
    }
}

