/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.requirements.RequirementsProviderService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderFilter;
import net.thucydides.core.statistics.service.TagProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathRequirementsProviderService
implements RequirementsProviderService {
    private final Logger logger = LoggerFactory.getLogger(ClasspathRequirementsProviderService.class);
    private TagProviderService tagProviderService;
    private List<RequirementsTagProvider> requirementsTagProviders;
    private TagProviderFilter<RequirementsTagProvider> filter = new TagProviderFilter();

    @Inject
    public ClasspathRequirementsProviderService(TagProviderService tagProviderService) {
        this.tagProviderService = tagProviderService;
    }

    @Override
    public List<RequirementsTagProvider> getRequirementsProviders() {
        if (this.requirementsTagProviders == null) {
            this.requirementsTagProviders = this.loadRequirementsTagProviders();
        }
        return NewList.copyOf(this.requirementsTagProviders);
    }

    private List<RequirementsTagProvider> loadRequirementsTagProviders() {
        ArrayList<RequirementsTagProvider> providers = new ArrayList<RequirementsTagProvider>();
        List<TagProvider> tagProviders = this.tagProviderService.getTagProviders();
        for (TagProvider tagProvider : tagProviders) {
            if (!(tagProvider instanceof RequirementsTagProvider)) continue;
            providers.add((RequirementsTagProvider)tagProvider);
        }
        return this.filter.removeOverriddenProviders(providers);
    }
}

