/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.Optional;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class ReportNameProvider {
    private final Optional<String> context;
    private final ReportNamer reportNamer;
    private final RequirementsService requirementsService;
    public static final Optional<String> NO_CONTEXT = Optional.empty();

    public ReportNameProvider(Optional<String> context, ReportNamer reportNamer, RequirementsService requirementsService) {
        this.context = context;
        this.reportNamer = reportNamer;
        this.requirementsService = requirementsService;
    }

    public ReportNameProvider getWithoutContext() {
        return new ReportNameProvider(NO_CONTEXT, this.reportNamer, this.requirementsService);
    }

    public ReportNameProvider() {
        this(NO_CONTEXT, ReportType.HTML);
    }

    public ReportNameProvider(String context) {
        this(Optional.ofNullable(context), ReportType.HTML, (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    public ReportNameProvider inContext(String context) {
        Optional<String> newContext = StringUtils.isNotEmpty((CharSequence)context) ? Optional.of(context) : NO_CONTEXT;
        return new ReportNameProvider(newContext, this.reportNamer, this.requirementsService);
    }

    protected ReportNameProvider(Optional<String> context, ReportType type) {
        this(context, type, (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    public ReportNameProvider(Optional<String> context, ReportType type, RequirementsService requirementsService) {
        this.context = context;
        this.reportNamer = ReportNamer.forReportType(type);
        this.requirementsService = requirementsService;
    }

    public String getContext() {
        return this.context.orElse("");
    }

    public ReportNameProvider forCSVFiles() {
        return new ReportNameProvider(this.context, ReportType.CSV);
    }

    public String forTestResult(String result) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "result_" + result);
    }

    public String forTag(String tag) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + tag.toLowerCase());
    }

    public String forErrorType(String errorType) {
        return this.reportNamer.getNormalizedTestNameFor("errortype_" + errorType.toLowerCase());
    }

    public String forTag(TestTag tag) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + tag.getType().toLowerCase() + "_" + tag.getName().toLowerCase());
    }

    public String forTagType(String tagType) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "tagtype_" + tagType.toLowerCase());
    }

    public String forRequirementType(String tagType) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "requirement_type_" + tagType.toLowerCase());
    }

    public ReportNameProvider withPrefix(String prefix) {
        return new ReportNameProvider(prefix);
    }

    public ReportNameProvider withPrefix(TestTag tag) {
        if (tag.equals(TestTag.EMPTY_TAG)) {
            return new ReportNameProvider(NO_CONTEXT, this.reportNamer, this.requirementsService);
        }
        return new ReportNameProvider(Optional.of(tag.getType().toLowerCase() + ":" + tag.getName().toLowerCase()), this.reportNamer, this.requirementsService);
    }

    private String prefixUsing(Optional<String> context) {
        if (context.isPresent() && StringUtils.isNotEmpty((CharSequence)this.getContext())) {
            return "context_" + NameConverter.underscore(context.get()) + "_";
        }
        return "";
    }

    public String forRequirement(Requirement requirement) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + requirement.getType() + "_" + requirement.qualifiedName());
    }

    public String forRequirement(TestTag tag) {
        return this.forRequirement(tag.getName(), tag.getType());
    }

    public String forRequirementOrTag(TestTag tag) {
        return this.requirementsService.isRequirementsTag(tag) ? this.forRequirement(tag.getName(), tag.getType()) : this.forTag(tag);
    }

    public String forRequirement(String requirementName, String requirementType) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + requirementType + "_" + requirementName);
    }

    public String forRelease(Release release) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "release_" + release.getName());
    }

    public String forRelease(String releaseName) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "release_" + releaseName);
    }

    public ReportNameProvider inLinkableForm() {
        return new ReportNameProvider(this.context, this.reportNamer.withNoCompression(), this.requirementsService);
    }
}

