/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import net.thucydides.core.requirements.model.Requirement;
import org.apache.commons.lang3.StringUtils;

public class RequirementTree {
    private static final int INDENT_STEPS = 4;
    private final List<Requirement> requirements;

    public RequirementTree(List<Requirement> requirements) {
        this.requirements = requirements;
    }

    public static RequirementTree withRequirements(List<Requirement> requirements) {
        return new RequirementTree(requirements);
    }

    public String toString() {
        if (this.requirements.isEmpty()) {
            return "NO REQUIREMENTS FOUND";
        }
        ByteArrayOutputStream printedTree = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(printedTree);
        printStream.println("REQUIREMENTS:");
        for (Requirement requirement : this.requirements) {
            printStream.print(this.stringFormOf(requirement));
        }
        return printedTree.toString();
    }

    private RequirementAsString stringFormOf(Requirement requirement) {
        return new RequirementAsString(requirement, 1);
    }

    private class RequirementAsString {
        private final Requirement requirement;
        private final int level;
        private final String indent;

        public RequirementAsString(Requirement requirement, int level) {
            this.requirement = requirement;
            this.level = level;
            this.indent = StringUtils.repeat((String)" ", (int)(level * 4));
        }

        RequirementAsString withIndentationLevel(int newLevel) {
            return new RequirementAsString(this.requirement, newLevel);
        }

        public String toString() {
            ByteArrayOutputStream printedRequirement = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(printedRequirement);
            printStream.println(this.indent + "- " + this.requirement.getType() + ": " + this.requirement.getDisplayName());
            for (Requirement child : this.requirement.getChildren()) {
                printStream.print(RequirementTree.this.stringFormOf(child).withIndentationLevel(this.level + 1));
            }
            return printedRequirement.toString();
        }
    }
}

