/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.time;

import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stopwatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(Stopwatch.class);
    long startTime = 0L;

    public static Stopwatch started() {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        return stopwatch;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public long stop() {
        this.validateStarted();
        long result = System.currentTimeMillis() - this.startTime;
        this.startTime = 0L;
        return result;
    }

    private void validateStarted() {
        if (this.startTime == 0L) {
            throw new IllegalStateException("stopwatch is already stopped");
        }
    }

    public String lapTimeFormatted() {
        this.validateStarted();
        return this.lapTimeFormatted(System.currentTimeMillis() - this.startTime);
    }

    public String executionTimeFormatted() {
        return this.lapTimeFormatted(this.stop());
    }

    public String lapTimeFormatted(Long executionTimeInMilliseconds) {
        return executionTimeInMilliseconds < 1000L ? executionTimeInMilliseconds + " ms" : new DecimalFormat("#,###.#").format((double)executionTimeInMilliseconds.longValue() / 1000.0) + " secs";
    }

    public long lapTime() {
        this.validateStarted();
        return System.currentTimeMillis() - this.startTime;
    }

    public long stop(String message) {
        long result = this.stop();
        LOGGER.debug("{} in {}", (Object)message, (Object)this.lapTimeFormatted(result));
        return result;
    }
}

