/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestFailureCause;

public class FailureDetectingStepListener
implements StepListener {
    private boolean lastTestFailed = false;
    private List<String> failureMessages = new ArrayList<String>();
    private TestFailureCause testFailureCause;

    public void reset() {
        this.lastTestFailed = false;
        this.failureMessages.clear();
    }

    public boolean lastTestFailed() {
        return this.lastTestFailed;
    }

    public void testFailed(TestOutcome testOutcome, Throwable cause) {
        this.lastTestFailed = true;
        String failingStep = testOutcome.getFailingStep().isPresent() ? ((TestStep)testOutcome.getFailingStep().get()).getDescription() + ":" : "";
        this.failureMessages.add(failingStep + testOutcome.getErrorMessage());
        this.testFailureCause = TestFailureCause.from((Throwable)cause);
    }

    public void lastStepFailed(StepFailure failure) {
    }

    public void testSuiteStarted(Class<?> storyClass) {
    }

    public void testSuiteStarted(Story storyOrFeature) {
    }

    public void testSuiteFinished() {
    }

    public void testStarted(String description) {
        this.lastTestFailed = false;
    }

    public void testStarted(String description, String id) {
        this.lastTestFailed = false;
    }

    public void testStarted(String description, String id, ZonedDateTime startTime) {
    }

    public void testFinished(TestOutcome result) {
    }

    public void testFinished(TestOutcome result, boolean isInDataDrivenTest, ZonedDateTime finishTime) {
    }

    public void testRetried() {
    }

    public void stepStarted(ExecutedStepDescription description) {
    }

    public void skippedStepStarted(ExecutedStepDescription description) {
    }

    public void stepFailed(StepFailure failure) {
    }

    public void stepFailed(StepFailure failure, List<ScreenshotAndHtmlSource> screenshotList) {
    }

    public void stepIgnored() {
    }

    public void stepPending() {
    }

    public void stepPending(String message) {
    }

    public void stepFinished() {
    }

    public void stepFinished(List<ScreenshotAndHtmlSource> screenshotList) {
    }

    public void testIgnored() {
    }

    public void testSkipped() {
    }

    public void testPending() {
    }

    public void testIsManual() {
    }

    public void notifyScreenChange() {
    }

    public void useExamplesFrom(DataTable table) {
    }

    public void addNewExamplesFrom(DataTable table) {
    }

    public void exampleStarted(Map<String, String> data) {
    }

    public void exampleFinished() {
    }

    public void assumptionViolated(String message) {
    }

    public void testRunFinished() {
    }

    public void takeScreenshots(List<ScreenshotAndHtmlSource> screenshots) {
    }

    public void takeScreenshots(TestResult testResult, List<ScreenshotAndHtmlSource> screenshots) {
    }

    public TestFailureCause getTestFailureCause() {
        return this.testFailureCause;
    }

    public List<String> getFailureMessages() {
        return NewList.copyOf(this.failureMessages);
    }
}

