/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.Collection;
import java.util.List;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.junit.runners.FailureDetectingStepListener;
import net.serenitybdd.junit.runners.RetryFilteringRunNotifier;
import net.serenitybdd.junit.runners.SerenityStatement;
import net.serenitybdd.junit.runners.TestMethodAnnotations;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.batches.BatchManagerProvider;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.statistics.TestCount;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepData;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.core.tags.TagScanner;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebdriverManager;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import org.apache.commons.lang3.StringUtils;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityRunner
extends BlockJUnit4ClassRunner {
    private StepFactory stepFactory;
    private Pages pages;
    private final WebdriverManager webdriverManager;
    private String requestedDriver;
    private ReportService reportService;
    private final TestCount testCount;
    private JUnitStepListener stepListener;
    private PageObjectDependencyInjector dependencyInjector;
    private Configuration configuration;
    private TagScanner tagScanner;
    private BatchManager batchManager;
    private final Logger logger = LoggerFactory.getLogger(SerenityRunner.class);

    public Pages getPages() {
        return this.pages;
    }

    public SerenityRunner(Class<?> klass) throws InitializationError {
        this(klass, Injectors.getInjector());
    }

    public SerenityRunner(Class<?> klass, Module module) throws InitializationError {
        this(klass, Injectors.getInjector((Module)module));
    }

    public SerenityRunner(Class<?> klass, Injector injector) throws InitializationError {
        this(klass, (WebdriverManager)injector.getInstance(WebdriverManager.class), (Configuration)injector.getInstance(Configuration.class), (BatchManager)injector.getInstance(BatchManager.class));
    }

    public SerenityRunner(Class<?> klass, WebDriverFactory webDriverFactory) throws InitializationError {
        this(klass, webDriverFactory, (Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public SerenityRunner(Class<?> klass, WebDriverFactory webDriverFactory, Configuration configuration) throws InitializationError {
        this(klass, webDriverFactory, configuration, new BatchManagerProvider(configuration).get());
    }

    public SerenityRunner(Class<?> klass, WebDriverFactory webDriverFactory, Configuration configuration, BatchManager batchManager) throws InitializationError {
        this(klass, (WebdriverManager)new ThucydidesWebdriverManager(webDriverFactory, configuration), configuration, batchManager);
    }

    public SerenityRunner(Class<?> klass, BatchManager batchManager) throws InitializationError {
        this(klass, (WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class), (Configuration)Injectors.getInjector().getInstance(Configuration.class), batchManager);
    }

    public SerenityRunner(Class<?> klass, WebdriverManager webDriverManager, Configuration configuration, BatchManager batchManager) throws InitializationError {
        super(klass);
        this.webdriverManager = webDriverManager;
        this.configuration = configuration;
        this.requestedDriver = this.getSpecifiedDriver(klass);
        this.tagScanner = new TagScanner(configuration.getEnvironmentVariables());
        this.testCount = (TestCount)Injectors.getInjector().getInstance(TestCount.class);
        if (TestCaseAnnotations.supportsWebTests(klass)) {
            this.checkRequestedDriverType();
        }
        this.batchManager = batchManager;
        batchManager.registerTestCase(klass);
    }

    private String getSpecifiedDriver(Class<?> klass) {
        if (ManagedWebDriverAnnotatedField.hasManagedWebdriverField(klass)) {
            return ManagedWebDriverAnnotatedField.findFirstAnnotatedField(klass).getDriver();
        }
        return null;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected BatchManager getBatchManager() {
        return this.batchManager;
    }

    private void checkRequestedDriverType() {
        if (this.requestedDriverSpecified()) {
            SupportedWebDriver.getDriverTypeFor((String)this.requestedDriver);
        } else {
            this.getConfiguration().getDriverType();
        }
    }

    private boolean requestedDriverSpecified() {
        return !StringUtils.isEmpty((CharSequence)this.requestedDriver);
    }

    public File getOutputDirectory() {
        return this.getConfiguration().getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        this.getReportService().subscribe(reporter);
    }

    public void useQualifier(String qualifier) {
        this.getReportService().useQualifier(qualifier);
    }

    public void run(RunNotifier notifier) {
        if (!this.skipThisTest()) {
            try {
                this.setupFixtureServices();
                RunNotifier localNotifier = this.initializeRunNotifier(notifier);
                super.run(localNotifier);
            }
            catch (Throwable someFailure) {
                someFailure.printStackTrace();
                throw someFailure;
            }
            finally {
                this.notifyTestSuiteFinished();
                this.generateReports();
                this.dropListeners(notifier);
                this.closeDrivers();
                this.shutdownFixtureServices();
            }
        }
    }

    private void setupFixtureServices() {
    }

    private void shutdownFixtureServices() {
    }

    private void notifyTestSuiteFinished() {
        try {
            StepEventBus.getEventBus().testSuiteFinished();
        }
        catch (Throwable listenerException) {
            this.logger.error("Test event bus error: " + listenerException.getMessage(), listenerException);
        }
    }

    private void dropListeners(RunNotifier notifier) {
        JUnitStepListener listener = this.getStepListener();
        notifier.removeListener((RunListener)listener);
        this.getStepListener().dropListeners();
    }

    protected void generateReports() {
        this.generateReportsFor(this.getTestOutcomes());
    }

    private boolean skipThisTest() {
        return this.testNotInCurrentBatch();
    }

    private boolean testNotInCurrentBatch() {
        return this.batchManager != null && !this.batchManager.shouldExecuteThisTest(this.getDescription().testCount());
    }

    protected JUnitStepListener getStepListener() {
        if (this.stepListener == null) {
            this.buildAndConfigureListeners();
        }
        return this.stepListener;
    }

    protected void setStepListener(JUnitStepListener stepListener) {
        this.stepListener = stepListener;
    }

    private void buildAndConfigureListeners() {
        this.initStepEventBus();
        if (this.webtestsAreSupported()) {
            this.initPagesObjectUsing(this.webdriverManager.getWebdriver(this.requestedDriver));
            this.setStepListener(this.initListenersUsing(this.getPages()));
            this.initStepFactoryUsing(this.getPages());
        } else {
            this.setStepListener(this.initListeners());
            this.initStepFactory();
        }
    }

    private RunNotifier initializeRunNotifier(RunNotifier notifier) {
        RunNotifier notifierForSteps = new RunNotifier();
        notifierForSteps.addListener((RunListener)this.getStepListener());
        return this.shouldRetryTest() ? notifier : new RetryFilteringRunNotifier(notifier, notifierForSteps);
    }

    private boolean shouldRetryTest() {
        return ThucydidesSystemProperty.JUNIT_RETRY_TESTS.booleanFrom(this.configuration.getEnvironmentVariables());
    }

    protected void initStepEventBus() {
        StepEventBus.getEventBus().clear();
    }

    private void initPagesObjectUsing(WebDriver driver) {
        this.pages = new Pages(driver, this.getConfiguration());
        this.dependencyInjector = new PageObjectDependencyInjector(this.pages);
    }

    protected JUnitStepListener initListenersUsing(Pages pageFactory) {
        return JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withPageFactory(pageFactory).and().withTestClass(this.getTestClass().getJavaClass()).and().build();
    }

    protected JUnitStepListener initListeners() {
        return JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withTestClass(this.getTestClass().getJavaClass()).and().build();
    }

    private boolean webtestsAreSupported() {
        return TestCaseAnnotations.supportsWebTests((Class)this.getTestClass().getJavaClass());
    }

    private void initStepFactoryUsing(Pages pagesObject) {
        this.stepFactory = new StepFactory(pagesObject);
    }

    private void initStepFactory() {
        this.stepFactory = new StepFactory();
    }

    private void closeDrivers() {
        this.getWebdriverManager().closeAllCurrentDrivers();
    }

    protected WebdriverManager getWebdriverManager() {
        return this.webdriverManager;
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(this.getOutputDirectory(), this.getDefaultReporters());
        }
        return this.reportService;
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        this.getReportService().generateReportsFor(testOutcomeResults);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.clearMetadataIfRequired();
        if (this.shouldSkipTest(method)) {
            return;
        }
        if (this.isPending(method)) {
            this.markAsPending(method);
            notifier.fireTestIgnored(this.describeChild(method));
            return;
        }
        this.processTestMethodAnnotationsFor(method);
        FailureDetectingStepListener failureDetectingStepListener = new FailureDetectingStepListener();
        StepEventBus.getEventBus().registerListener((StepListener)failureDetectingStepListener);
        int maxRetries = this.getConfiguration().maxRetries();
        for (int attemptCount = 0; attemptCount <= maxRetries; ++attemptCount) {
            if (notifier instanceof RetryFilteringRunNotifier) {
                ((RetryFilteringRunNotifier)notifier).reset();
            }
            if (attemptCount > 0) {
                this.logger.warn(method.getName() + " failed, making attempt " + (attemptCount + 1) + ". Max retries: " + maxRetries);
                StepEventBus.getEventBus().testRetried();
            }
            Serenity.initializeTestSession();
            this.resetBroswerFromTimeToTime();
            this.additionalBrowserCleanup();
            failureDetectingStepListener.reset();
            super.runChild(method, notifier);
            if (!failureDetectingStepListener.lastTestFailed()) break;
        }
        if (notifier instanceof RetryFilteringRunNotifier) {
            ((RetryFilteringRunNotifier)notifier).flush();
        }
    }

    private void clearMetadataIfRequired() {
        if (!ThucydidesSystemProperty.THUCYDIDES_MAINTAIN_SESSION.booleanFrom(this.configuration.getEnvironmentVariables()).booleanValue()) {
            Serenity.getCurrentSession().clearMetaData();
        }
    }

    protected void additionalBrowserCleanup() {
    }

    private boolean shouldSkipTest(FrameworkMethod method) {
        return !this.tagScanner.shouldRunMethod(this.getTestClass().getJavaClass(), method.getName());
    }

    private void markAsPending(FrameworkMethod method) {
        this.stepListener.testStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)this.testName(method)));
        StepEventBus.getEventBus().testPending();
        StepEventBus.getEventBus().testFinished();
    }

    private void processTestMethodAnnotationsFor(FrameworkMethod method) {
        if (this.isIgnored(method)) {
            this.stepListener.testStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)this.testName(method)));
            StepEventBus.getEventBus().testIgnored();
        }
    }

    private boolean isPending(FrameworkMethod method) {
        return method.getAnnotation(Pending.class) != null;
    }

    protected boolean isIgnored(FrameworkMethod method) {
        return method.getAnnotation(Ignore.class) != null;
    }

    protected boolean restartBrowserBeforeTest() {
        return this.notAUniqueSession() || this.dueForPeriodicBrowserReset();
    }

    private boolean dueForPeriodicBrowserReset() {
        return this.shouldRestartEveryNthTest() && this.currentTestNumber() % this.restartFrequency() == 0;
    }

    private boolean notAUniqueSession() {
        return !this.isUniqueSession();
    }

    protected int restartFrequency() {
        return this.getConfiguration().getRestartFrequency();
    }

    protected int currentTestNumber() {
        return this.testCount.getCurrentTestNumber();
    }

    protected boolean shouldRestartEveryNthTest() {
        return this.restartFrequency() > 0;
    }

    protected boolean isUniqueSession() {
        return TestCaseAnnotations.isUniqueSession((Class)this.getTestClass().getJavaClass());
    }

    protected void resetBroswerFromTimeToTime() {
        if (this.isAWebTest() && this.restartBrowserBeforeTest()) {
            WebdriverProxyFactory.resetDriver((WebDriver)this.getDriver());
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (this.webtestsAreSupported()) {
            this.injectDriverInto(test, method);
            this.initPagesObjectUsing(this.driverFor(method));
            this.injectAnnotatedPagesObjectInto(test);
            this.initStepFactoryUsing(this.getPages());
        }
        this.injectScenarioStepsInto(test);
        this.useStepFactoryForDataDrivenSteps();
        Statement baseStatement = super.methodInvoker(method, test);
        return new SerenityStatement(baseStatement, (StepPublisher)this.stepListener.getBaseStepListener());
    }

    private void useStepFactoryForDataDrivenSteps() {
        StepData.setDefaultStepFactory((StepFactory)this.stepFactory);
    }

    protected void injectDriverInto(Object testCase, FrameworkMethod method) {
        TestCaseAnnotations.forTestCase((Object)testCase).injectDriver(this.driverFor(method));
        this.dependencyInjector.injectDependenciesInto(testCase);
    }

    protected WebDriver driverFor(FrameworkMethod method) {
        if (TestMethodAnnotations.forTest(method).isDriverSpecified()) {
            String testSpecificDriver = TestMethodAnnotations.forTest(method).specifiedDriver();
            return this.getDriver(testSpecificDriver);
        }
        return this.getDriver();
    }

    protected void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injectScenarioStepsInto((Object)testCase, (StepFactory)this.stepFactory);
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injectAnnotatedPagesObjectInto((Object)testCase, (Pages)this.pages);
    }

    protected WebDriver getDriver() {
        return this.getWebdriverManager().getWebdriver(this.requestedDriver);
    }

    protected WebDriver getDriver(String driver) {
        return this.getWebdriverManager().getWebdriver(driver);
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.getStepListener().getTestOutcomes();
    }

    protected Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }

    public boolean isAWebTest() {
        return TestCaseAnnotations.isWebTest((Class)this.getTestClass().getJavaClass());
    }
}

