/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.ensure.CommonEnsure;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.DateEnsure;
import net.serenitybdd.screenplay.ensure.Expectation;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.KnownValue;
import net.serenitybdd.screenplay.ensure.PerformableExpectation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0004B?\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\n\u00a2\u0006\u0002\u0010\u000bJR\u0010\u000e\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007\u0012\"\u0012 0\u0002\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u00120\u000f2\u0006\u0010\u0012\u001a\u00020\u0002JR\u0010\u0013\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007\u0012\"\u0012 0\u0002\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u00120\u000f2\u0006\u0010\u0012\u001a\u00020\u0002JR\u0010\u0014\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007\u0012\"\u0012 0\u0015\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u00120\u000f2\u0006\u0010\u0012\u001a\u00020\u0015JR\u0010\u0016\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007\u0012\"\u0012 0\u0017\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u00120\u000f2\u0006\u0010\u0012\u001a\u00020\u0017JR\u0010\u0018\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007\u0012\"\u0012 0\u0019\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u00120\u000f2\u0006\u0010\u0012\u001a\u00020\u0019JR\u0010\u001a\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007\u0012\"\u0012 0\u0015\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u00120\u000f2\u0006\u0010\u0012\u001a\u00020\u0015J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\b\u0010\u001c\u001a\u00020\u0000H\u0016J \u0010\u001d\u001a\u00020\u00002\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\nH\u0016R.\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lnet/serenitybdd/screenplay/ensure/DateEnsure;", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "Ljava/time/LocalDate;", "value", "(Ljava/time/LocalDate;)V", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Lkotlin/jvm/functions/Function1;Ljava/util/Comparator;)V", "getValue", "()Lkotlin/jvm/functions/Function1;", "isAfter", "Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "Lkotlin/ParameterName;", "name", "expected", "isBefore", "isDayOfMonth", "", "isDayOfWeek", "Ljava/time/DayOfWeek;", "isInTheMonthOf", "Ljava/time/Month;", "isTheYear", "not", "silently", "usingComparator", "Companion", "serenity-ensure"})
public final class DateEnsure
extends ComparableEnsure<LocalDate> {
    @NotNull
    private final Function1<Actor, LocalDate> value;
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, LocalDate> BEFORE;
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, LocalDate> AFTER;
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, DayOfWeek> DAY_OF_WEEK;
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, Integer> DAY_OF_MONTH;
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, Month> MONTH;
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, Integer> YEAR;
    public static final Companion Companion;

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, LocalDate> isBefore(@NotNull LocalDate expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalDate>, LocalDate>(this.getValue(), BEFORE, expected, this.isNegated(), null, 16, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, LocalDate> isAfter(@NotNull LocalDate expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalDate>, LocalDate>(this.getValue(), AFTER, expected, this.isNegated(), null, 16, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, DayOfWeek> isDayOfWeek(@NotNull DayOfWeek expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalDate>, DayOfWeek>(this.getValue(), DAY_OF_WEEK, expected, this.isNegated(), null, 16, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, Integer> isDayOfMonth(int expected) {
        return new PerformableExpectation<Function1<Actor, LocalDate>, Integer>(this.getValue(), DAY_OF_MONTH, expected, this.isNegated(), null, 16, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, Month> isInTheMonthOf(@NotNull Month expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalDate>, Month>(this.getValue(), MONTH, expected, this.isNegated(), null, 16, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, Integer> isTheYear(int expected) {
        return new PerformableExpectation<Function1<Actor, LocalDate>, Integer>(this.getValue(), YEAR, expected, this.isNegated(), null, 16, null);
    }

    @Override
    @NotNull
    public DateEnsure not() {
        CommonEnsure commonEnsure = this.negate();
        if (commonEnsure == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.DateEnsure");
        }
        return (DateEnsure)commonEnsure;
    }

    @Override
    @NotNull
    public DateEnsure silently() {
        CommonEnsure commonEnsure = super.silently();
        if (commonEnsure == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.DateEnsure");
        }
        return (DateEnsure)commonEnsure;
    }

    @NotNull
    public DateEnsure usingComparator(@NotNull Comparator<LocalDate> comparator) {
        Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
        return new DateEnsure(this.getValue(), comparator);
    }

    @Override
    @NotNull
    public Function1<Actor, LocalDate> getValue() {
        return this.value;
    }

    public DateEnsure(@NotNull Function1<? super Actor, LocalDate> value, @NotNull Comparator<LocalDate> comparator) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
        super(value, comparator, null, 4, null);
        this.value = value;
    }

    public DateEnsure(@Nullable LocalDate value) {
        this((Function1<? super Actor, LocalDate>)new KnownValue<LocalDate>(value, String.valueOf(value)), ComparisonsKt.naturalOrder());
    }

    static {
        Companion = new Companion(null);
        BEFORE = ExpectationKt.expectThatActualIs("before", Companion.BEFORE.1.INSTANCE);
        AFTER = ExpectationKt.expectThatActualIs("after", Companion.AFTER.1.INSTANCE);
        DAY_OF_WEEK = ExpectationKt.expectThatActualIs("on a", Companion.DAY_OF_WEEK.1.INSTANCE);
        DAY_OF_MONTH = ExpectationKt.expectThatActualIs("on day of month", Companion.DAY_OF_MONTH.1.INSTANCE);
        MONTH = ExpectationKt.expectThatActualIs("in month", Companion.MONTH.1.INSTANCE);
        YEAR = ExpectationKt.expectThatActualIs("in the year", Companion.YEAR.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Rw\u0010\u0003\u001ah\u0012@\u0012>\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u0007\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eRw\u0010\u000f\u001ah\u0012@\u0012>\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u0007\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eRw\u0010\u0011\u001ah\u0012@\u0012>\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u0012\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eRw\u0010\u0014\u001ah\u0012@\u0012>\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u0015\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eRw\u0010\u0017\u001ah\u0012@\u0012>\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u0018\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eRw\u0010\u001a\u001ah\u0012@\u0012>\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u0012\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lnet/serenitybdd/screenplay/ensure/DateEnsure$Companion;", "", "()V", "AFTER", "Lnet/serenitybdd/screenplay/ensure/Expectation;", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Ljava/time/LocalDate;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "Lkotlin/ParameterName;", "name", "actual", "expected", "getAFTER", "()Lnet/serenitybdd/screenplay/ensure/Expectation;", "BEFORE", "getBEFORE", "DAY_OF_MONTH", "", "getDAY_OF_MONTH", "DAY_OF_WEEK", "Ljava/time/DayOfWeek;", "getDAY_OF_WEEK", "MONTH", "Ljava/time/Month;", "getMONTH", "YEAR", "getYEAR", "serenity-ensure"})
    public static final class Companion {
        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, LocalDate> getBEFORE() {
            return BEFORE;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, LocalDate> getAFTER() {
            return AFTER;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, DayOfWeek> getDAY_OF_WEEK() {
            return DAY_OF_WEEK;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, Integer> getDAY_OF_MONTH() {
            return DAY_OF_MONTH;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, Month> getMONTH() {
            return MONTH;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, Integer> getYEAR() {
            return YEAR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

