/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.TestStep;
import cucumber.runtime.formatter.FeaturePathFormatter;
import cucumber.runtime.formatter.TestSourcesModel;
import gherkin.ast.Examples;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.Tag;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.steps.StepEventBus;
import org.jetbrains.annotations.NotNull;

class ScenarioContext {
    private final Queue<Step> stepQueue = new LinkedList<Step>();
    private final Queue<TestStep> testStepQueue = new LinkedList<TestStep>();
    private boolean examplesRunning;
    private boolean addingScenarioOutlineSteps = false;
    private DataTable table;
    Map<Integer, Map<String, String>> exampleRows;
    Map<Integer, List<Tag>> exampleTags;
    int exampleCount = 0;
    boolean waitingToProcessBackgroundSteps = false;
    String currentScenarioId;
    ScenarioDefinition currentScenarioDefinition;
    String currentScenario;
    List<Tag> featureTags = new ArrayList<Tag>();
    String currentFeaturePath;
    private FeaturePathFormatter featurePathFormatter = new FeaturePathFormatter();

    ScenarioContext() {
    }

    public void currentFeaturePathIs(String featurePath) {
        this.currentFeaturePath = featurePath;
    }

    public ScenarioOutline currentScenarioOutline() {
        return (ScenarioOutline)this.currentScenarioDefinition;
    }

    public String currentFeaturePath() {
        return this.currentFeaturePath;
    }

    public Queue<Step> getStepQueue() {
        return this.stepQueue;
    }

    public boolean examplesAreRunning() {
        return this.examplesRunning;
    }

    public Map<Integer, Map<String, String>> getExampleRows() {
        return this.exampleRows;
    }

    public Map<Integer, List<Tag>> getExampleTags() {
        return this.exampleTags;
    }

    public int getExampleCount() {
        return this.exampleCount;
    }

    public DataTable getTable() {
        return this.table;
    }

    public boolean isWaitingToProcessBackgroundSteps() {
        return this.waitingToProcessBackgroundSteps;
    }

    public String getCurrentScenarioId() {
        return this.currentScenarioId;
    }

    public ScenarioDefinition getCurrentScenarioDefinition() {
        return this.currentScenarioDefinition;
    }

    public String getCurrentScenario() {
        return this.currentScenario;
    }

    public List<Tag> getFeatureTags() {
        return this.featureTags;
    }

    public boolean isAddingScenarioOutlineSteps() {
        return this.addingScenarioOutlineSteps;
    }

    public void doneAddingScenarioOutlineSteps() {
        this.addingScenarioOutlineSteps = false;
    }

    public void setFeatureTags(List<Tag> tags) {
        this.featureTags = new ArrayList<Tag>(tags);
    }

    public void setCurrentScenarioDefinitionFrom(TestSourcesModel.AstNode astNode) {
        this.currentScenarioDefinition = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode);
    }

    public boolean isAScenarioOutline() {
        return this.currentScenarioDefinition instanceof ScenarioOutline;
    }

    public void startNewExample() {
        this.examplesRunning = true;
        this.addingScenarioOutlineSteps = true;
    }

    public void setExamplesRunning(boolean examplesRunning) {
        this.examplesRunning = examplesRunning;
    }

    public List<Tag> getScenarioTags() {
        if (this.currentScenarioDefinition instanceof ScenarioOutline) {
            return ((ScenarioOutline)this.currentScenarioDefinition).getTags();
        }
        if (this.currentScenarioDefinition instanceof Scenario) {
            return ((Scenario)this.currentScenarioDefinition).getTags();
        }
        return new ArrayList<Tag>();
    }

    public String getScenarioName() {
        return this.currentScenarioDefinition.getName();
    }

    public List<Examples> getScenarioExamples() {
        return ((ScenarioOutline)this.currentScenarioDefinition).getExamples();
    }

    public void clearStepQueue() {
        this.stepQueue.clear();
    }

    public void clearTestStepQueue() {
        this.testStepQueue.clear();
    }

    public void queueStep(Step step) {
        this.stepQueue.add(step);
    }

    public void queueTestStep(TestStep testStep) {
        this.testStepQueue.add(testStep);
    }

    public Step getCurrentStep() {
        return this.stepQueue.peek();
    }

    public Step nextStep() {
        return this.stepQueue.poll();
    }

    public TestStep nextTestStep() {
        return this.testStepQueue.poll();
    }

    public boolean noStepsAreQueued() {
        return this.stepQueue.isEmpty();
    }

    public boolean hasScenarioId(String scenarioId) {
        return this.currentScenarioId != null && this.currentScenarioId.equals(scenarioId);
    }

    public void setTable(DataTable table) {
        this.table = table;
        this.exampleCount = table.getSize();
    }

    public void addTableRows(List<String> headers, List<Map<String, String>> rows, String name, String description, Map<Integer, Integer> lineNumbersOfEachRow) {
        this.table.startNewDataSet(name, description);
        AtomicInteger rowNumber = new AtomicInteger();
        rows.forEach(row -> this.table.appendRow(this.newRow(headers, lineNumbersOfEachRow, rowNumber.getAndIncrement(), (Map<String, String>)row)));
        this.table.updateLineNumbers(lineNumbersOfEachRow);
        this.exampleCount = this.table.getSize();
    }

    @NotNull
    private DataTableRow newRow(List<String> headers, Map<Integer, Integer> lineNumbersOfEachRow, int rowNumber, Map<String, String> row) {
        return new DataTableRow(this.rowValuesFrom(headers, row), lineNumbersOfEachRow.getOrDefault(rowNumber, 0).intValue());
    }

    private List<String> rowValuesFrom(List<String> headers, Map<String, String> row) {
        return headers.stream().map(row::get).collect(Collectors.toList());
    }

    public void addTableTags(List<TestTag> tags) {
        this.table.addTagsToLatestDataSet(tags);
    }

    public void clearTable() {
        this.table = null;
    }

    public StepEventBus stepEventBus() {
        String prefixedPath = this.featurePathFormatter.featurePathWithPrefixIfNecessary(this.currentFeaturePath());
        return StepEventBus.eventBusFor((Object)prefixedPath);
    }
}

