/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.event.TestSourceRead;
import cucumber.runtime.formatter.TestSourcesModel;
import gherkin.ast.Feature;
import java.io.File;
import java.util.Optional;
import net.thucydides.core.util.Inflector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFileLoader {
    private final TestSourcesModel testSources = new TestSourcesModel();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureFileLoader.class);

    private Optional<Feature> featureFrom(String featureFileUri) {
        String defaultFeatureId = new File(featureFileUri).getName().replace(".feature", "");
        String defaultFeatureName = Inflector.getInstance().humanize(defaultFeatureId, new String[0]);
        this.parseGherkinIn(featureFileUri);
        if (StringUtils.isEmpty((CharSequence)this.testSources.getFeatureName(featureFileUri))) {
            return Optional.empty();
        }
        Feature feature = this.testSources.getFeature(featureFileUri);
        if (feature.getName().isEmpty()) {
            feature = this.featureWithDefaultName(feature, defaultFeatureName);
        }
        return Optional.of(feature);
    }

    private void parseGherkinIn(String featureFileUri) {
        try {
            this.testSources.getFeature(featureFileUri);
        }
        catch (Throwable ignoreParsingErrors) {
            LOGGER.warn("Could not parse the Gherkin in feature file " + featureFileUri + ": file ignored");
        }
    }

    public Feature featureWithDefaultName(Feature feature, String defaultName) {
        return new Feature(feature.getTags(), feature.getLocation(), feature.getLanguage(), feature.getKeyword(), defaultName, feature.getDescription(), feature.getChildren());
    }

    public void addTestSourceReadEvent(String path, TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    public String getFeatureName(String featureFileUri) {
        return this.testSources.getFeatureName(featureFileUri);
    }

    public Feature getFeature(String featureFileUri) {
        return this.testSources.getFeature(featureFileUri);
    }

    TestSourcesModel.AstNode getAstNode(String path, int line) {
        return this.testSources.getAstNode(path, line);
    }
}

