/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.serenitybdd.cucumber.suiteslicing.CucumberScenarioLoader;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.VisualisableCucumberScenarios;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.PathUtils;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberScenarioVisualiser {
    private final Logger LOGGER = LoggerFactory.getLogger(CucumberScenarioVisualiser.class);
    private final EnvironmentVariables environmentVariables;

    public CucumberScenarioVisualiser(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    private String outputDirectory() {
        return this.environmentVariables.getProperty((Enum)ThucydidesSystemProperty.SERENITY_OUTPUT_DIRECTORY, "target/site/serenity");
    }

    public static List<VisualisableCucumberScenarios> sliceIntoForks(int forkCount, List<WeightedCucumberScenarios> slices) {
        return slices.stream().map(slice -> IntStream.rangeClosed(1, forkCount).mapToObj(forkNumber -> VisualisableCucumberScenarios.create(slices.indexOf(slice) + 1, forkNumber, slice.slice(forkNumber).of(forkCount))).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void visualise(URI rootFolderURI, int sliceCount, int forkCount, TestStatistics testStatistics) {
        try {
            Files.createDirectories(Paths.get(this.outputDirectory(), new String[0]), new FileAttribute[0]);
            List<WeightedCucumberScenarios> slices = new CucumberScenarioLoader(Lists.newArrayList((Object[])new URI[]{rootFolderURI}), testStatistics).load().sliceInto(sliceCount);
            List<VisualisableCucumberScenarios> visualisedSlices = CucumberScenarioVisualiser.sliceIntoForks(forkCount, slices);
            String jsonFile = String.format("%s/%s-slice-config-%s-forks-in-each-of-%s-slices-using-%s.json", this.outputDirectory(), PathUtils.getAsFile(rootFolderURI).getPath().replaceAll("[:/]", "-"), forkCount, sliceCount, testStatistics);
            Files.write(Paths.get(jsonFile, new String[0]), new GsonBuilder().setPrettyPrinting().create().toJson(visualisedSlices).getBytes(), new OpenOption[0]);
            this.LOGGER.debug("Wrote visualisation as JSON for {} slices -> {}", (Object)visualisedSlices.size(), (Object)jsonFile);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to visualise scenarios", e);
        }
    }
}

