/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Splitter;
import cucumber.api.junit.Cucumber;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.serenitybdd.cucumber.SerenityReporter;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runners.model.InitializationError;

public class CucumberWithSerenity
extends Cucumber {
    public CucumberWithSerenity(Class clazz) throws InitializationError, IOException {
        super(clazz);
    }

    protected Runtime createRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions) throws InitializationError, IOException {
        runtimeOptions.getFilters().addAll(this.environmentSpecifiedTags(runtimeOptions.getFilters()));
        return this.createSerenityEnabledRuntime(resourceLoader, classLoader, runtimeOptions);
    }

    private Collection<String> environmentSpecifiedTags(List<Object> existingTags) {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        String tagsExpression = ThucydidesSystemProperty.TAGS.from(environmentVariables, "");
        List newTags = Lambda.convert((Object)Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)tagsExpression), this.toCucumberTags());
        newTags.removeAll(existingTags);
        return newTags;
    }

    private Converter<String, String> toCucumberTags() {
        return new Converter<String, String>(){

            public String convert(String from) {
                if ((from = from.replaceAll(":", "=")).startsWith("~@")) {
                    return from;
                }
                if (from.startsWith("@")) {
                    return from;
                }
                if (from.startsWith("~")) {
                    return "~@" + from.substring(1);
                }
                return "@" + from;
            }
        };
    }

    private Runtime createSerenityEnabledRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions) {
        Configuration systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        return CucumberWithSerenity.createSerenityEnabledRuntime(resourceLoader, classLoader, runtimeOptions, systemConfiguration);
    }

    public static Runtime createSerenityEnabledRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions, Configuration systemConfiguration) {
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(resourceLoader, classLoader);
        SerenityReporter reporter = new SerenityReporter(systemConfiguration);
        runtimeOptions.addPlugin((Object)reporter);
        return new Runtime(resourceLoader, (ClassFinder)classFinder, classLoader, runtimeOptions);
    }
}

