/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.images;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.thucydides.core.images.ResizableImage;

public class ResizedImage
extends ResizableImage {
    private final BufferedImage image;

    public ResizedImage(BufferedImage image, File screenshotFile) throws IOException {
        super(screenshotFile);
        this.image = image;
    }

    @Override
    public void saveTo(File file) throws IOException {
        ImageIO.write((RenderedImage)this.image, "PNG", file);
    }

    @Override
    public int getWitdh() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }
}

