/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import net.thucydides.core.annotations.locators.SmartAnnotations;
import net.thucydides.core.annotations.locators.SmartElementLocator;
import net.thucydides.core.steps.StepEventBus;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.SlowLoadableComponent;
import org.openqa.selenium.support.ui.SystemClock;

public class SmartAjaxElementLocator
extends SmartElementLocator {
    protected final int timeOutInSeconds;
    private final Clock clock;
    private final Field field;
    private final WebDriver driver;
    private static final List<WebElement> EMPTY_LIST_OF_WEBELEMENTS = Lists.newArrayList();

    public SmartAjaxElementLocator(WebDriver driver, Field field, int timeOutInSeconds) {
        this((Clock)new SystemClock(), driver, field, timeOutInSeconds);
    }

    public SmartAjaxElementLocator(Clock clock, WebDriver driver, Field field, int timeOutInSeconds) {
        super((SearchContext)driver, field);
        this.timeOutInSeconds = timeOutInSeconds;
        this.clock = clock;
        this.field = field;
        this.driver = driver;
    }

    @Override
    public WebElement findElement() {
        if (this.shouldFindElementImmediately()) {
            return this.findElementImmediately();
        }
        return this.ajaxFindElement();
    }

    private boolean shouldFindElementImmediately() {
        return this.aPreviousStepHasFailed() || this.calledFromAQuickMethod();
    }

    private boolean calledFromAQuickMethod() {
        for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
            if (!elt.getMethodName().contains("Currently")) continue;
            return true;
        }
        return false;
    }

    public WebElement findElementImmediately() {
        SmartAnnotations annotations = new SmartAnnotations(this.field);
        By by = annotations.buildBy();
        WebElement element = this.driver.findElement(by);
        if (element == null) {
            throw new NoSuchElementException("No such element found for criteria " + by.toString());
        }
        return element;
    }

    protected boolean isElementUsable(WebElement element) {
        return element != null && element.isDisplayed();
    }

    public WebElement ajaxFindElement() {
        SlowLoadingElement loadingElement = new SlowLoadingElement(this.clock, this.timeOutInSeconds);
        try {
            return ((SlowLoadingElement)loadingElement.get()).getElement();
        }
        catch (NoSuchElementError e) {
            throw new NoSuchElementException(String.format("Timed out after %d seconds. %s", this.timeOutInSeconds, e.getMessage()), e.getCause());
        }
    }

    @Override
    public List<WebElement> findElements() {
        if (this.aPreviousStepHasFailed()) {
            return EMPTY_LIST_OF_WEBELEMENTS;
        }
        SlowLoadingElementList list = new SlowLoadingElementList(this.clock, this.timeOutInSeconds);
        try {
            return ((SlowLoadingElementList)list.get()).getElements();
        }
        catch (NoSuchElementError e) {
            throw new NoSuchElementException(String.format("Timed out after %d seconds. %s", this.timeOutInSeconds, e.getMessage()), e.getCause());
        }
    }

    private boolean aPreviousStepHasFailed() {
        return StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed();
    }

    protected long sleepFor() {
        return 250L;
    }

    public String toString() {
        SmartAnnotations annotations = new SmartAnnotations(this.field);
        By by = annotations.buildBy();
        return by.toString();
    }

    private static class NoSuchElementError
    extends Error {
        private NoSuchElementError(String message, Throwable throwable) {
            super(message, throwable);
        }
    }

    private class SlowLoadingElementList
    extends SlowLoadableComponent<SlowLoadingElementList> {
        private NoSuchElementException lastException;
        private List<WebElement> elements;

        public SlowLoadingElementList(Clock clock, int timeOutInSeconds) {
            super(clock, timeOutInSeconds);
        }

        protected void load() {
        }

        protected long sleepFor() {
            return SmartAjaxElementLocator.this.sleepFor();
        }

        protected void isLoaded() throws Error {
            try {
                this.elements = SmartAjaxElementLocator.super.findElements();
                if (this.elements.size() == 0) {
                    return;
                }
                for (WebElement element : this.elements) {
                    if (SmartAjaxElementLocator.this.isElementUsable(element)) continue;
                    throw new NoSuchElementException("Element is not usable");
                }
            }
            catch (NoSuchElementException e) {
                this.lastException = e;
                throw new NoSuchElementError("Unable to locate the element " + e.getMessage(), e);
            }
        }

        public NoSuchElementException getLastException() {
            return this.lastException;
        }

        public List<WebElement> getElements() {
            return this.elements;
        }
    }

    private class SlowLoadingElement
    extends SlowLoadableComponent<SlowLoadingElement> {
        private NoSuchElementException lastException;
        private WebElement element;

        public SlowLoadingElement(Clock clock, int timeOutInSeconds) {
            super(clock, timeOutInSeconds);
        }

        protected void load() {
        }

        protected long sleepFor() {
            return SmartAjaxElementLocator.this.sleepFor();
        }

        protected void isLoaded() throws Error {
            try {
                this.element = SmartAjaxElementLocator.super.findElement();
                if (!SmartAjaxElementLocator.this.isElementUsable(this.element)) {
                    throw new NoSuchElementException("Element is not usable " + this.element.toString());
                }
            }
            catch (NoSuchElementException e) {
                this.lastException = e;
                throw new NoSuchElementError("Unable to locate the element: " + e.getMessage(), e);
            }
        }

        public NoSuchElementException getLastException() {
            return this.lastException;
        }

        public WebElement getElement() {
            return this.element;
        }
    }
}

