/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.json.JSONConverter;
import net.thucydides.core.reports.json.jackson.TestOutcomeModule;
import net.thucydides.core.util.EnvironmentVariables;

public class JacksonJSONConverter
implements JSONConverter {
    private final ObjectMapper mapper;
    private final ObjectReader reader;
    private final ObjectWriter writer;
    private final EnvironmentVariables environmentVariables;
    private final Validator validator;

    @Inject
    public JacksonJSONConverter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JodaModule());
        this.mapper.registerModule((Module)new GuavaModule());
        this.mapper.registerModule((Module)new TestOutcomeModule());
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.reader = this.mapper.reader(TestOutcome.class);
        this.writer = this.mapper.writerWithType(TestOutcome.class);
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public TestOutcome fromJson(InputStream inputStream) throws IOException {
        TestOutcome outcome = (TestOutcome)this.reader.readValue(inputStream);
        this.checkConstraints(outcome);
        return outcome;
    }

    private void checkConstraints(TestOutcome outcome) {
        Set violations = this.validator.validate((Object)outcome, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ValidationException(Arrays.toString(violations.toArray()));
        }
    }

    @Override
    public void toJson(TestOutcome testOutcome, OutputStream outputStream) throws IOException {
        if (this.usePrettyPrinting()) {
            this.writer.withDefaultPrettyPrinter().writeValue(outputStream, (Object)testOutcome);
        } else {
            this.writer.writeValue(outputStream, (Object)testOutcome);
        }
    }

    private boolean usePrettyPrinting() {
        return ThucydidesSystemProperty.JSON_PRETTY_PRINTING.booleanFrom(this.environmentVariables);
    }
}

