/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.ErrorMessageFormatter;
import net.thucydides.core.model.FailureAnalysis;
import net.thucydides.core.model.FailureCause;
import net.thucydides.core.model.RootCauseAnalyzer;
import net.thucydides.core.model.TestDuration;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.pages.SystemClock;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class TestStep {
    private int number;
    private String description;
    private long duration;
    private long startTime;
    private List<ScreenshotAndHtmlSource> screenshots = new ArrayList<ScreenshotAndHtmlSource>();
    private FailureCause exception;
    private TestResult result;
    private List<TestStep> children = new ArrayList<TestStep>();

    public TestStep() {
        this.startTime = this.now().getMillis();
    }

    protected void setNumber(int number) {
        this.number = number;
    }

    private SystemClock getSystemClock() {
        return (SystemClock)Injectors.getInjector().getInstance(SystemClock.class);
    }

    private DateTime now() {
        return this.getSystemClock().getCurrentTime();
    }

    public static TestStepBuilder forStepCalled(String description) {
        return new TestStepBuilder(description);
    }

    public boolean hasScreenshots() {
        return !this.getScreenshots().isEmpty();
    }

    protected List<TestStep> children() {
        return this.children;
    }

    public int renumberFrom(int count) {
        this.setNumber(count++);
        if (this.hasChildren()) {
            count = this.renumberChildrenFrom(count);
        }
        return count;
    }

    private int renumberChildrenFrom(int count) {
        for (TestStep step : this.children) {
            count = step.renumberFrom(count);
        }
        return count;
    }

    public String toString() {
        if (!this.hasChildren()) {
            return this.description;
        }
        String childDescriptions = Lambda.join((Object)Lambda.extract(this.children, (Object)((TestStep)Lambda.on(TestStep.class)).toString()));
        return this.description + " [" + childDescriptions + "]";
    }

    public TestStep(String description) {
        this();
        this.description = description;
    }

    public TestStep(DateTime startTime, String description) {
        this();
        this.startTime = startTime.getMillis();
        this.description = description;
    }

    public TestStep startingAt(DateTime time) {
        TestStep newTestStep = this.copyOfThisTestStep();
        newTestStep.startTime = time.getMillis();
        return newTestStep;
    }

    public TestStep clone() {
        TestStep newTestStep = new TestStep();
        newTestStep.description = this.description;
        newTestStep.startTime = this.startTime;
        newTestStep.duration = this.duration;
        newTestStep.screenshots = Lists.newArrayList(this.screenshots);
        newTestStep.exception = this.exception;
        newTestStep.result = this.result;
        newTestStep.number = this.number;
        newTestStep.children = Lists.newArrayList(this.children);
        return newTestStep;
    }

    protected TestStep copyOfThisTestStep() {
        return this.clone();
    }

    public void recordDuration() {
        this.setDuration(this.now().getMillis() - this.startTime);
    }

    public int getNumber() {
        return this.number;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public List<TestStep> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public List<ScreenshotAndHtmlSource> getScreenshots() {
        return ImmutableList.copyOf(this.screenshots);
    }

    public ScreenshotAndHtmlSource getFirstScreenshot() {
        if (this.screenshots != null && !this.screenshots.isEmpty()) {
            return this.screenshots.get(0);
        }
        return null;
    }

    public boolean needsScreenshots() {
        return !this.isAGroup() && this.getScreenshots() != null;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public TestResult getResult() {
        if (this.isAGroup() && !this.groupResultOverridesChildren()) {
            return this.result != null ? TestResultList.of(this.result, this.getResultFromChildren()).getOverallResult() : this.getResultFromChildren();
        }
        return this.getResultFromThisStep();
    }

    private TestResult getResultFromThisStep() {
        if (this.result != null) {
            return this.result;
        }
        return TestResult.PENDING;
    }

    private boolean groupResultOverridesChildren() {
        return this.result == TestResult.SKIPPED || this.result == TestResult.IGNORED || this.result == TestResult.PENDING;
    }

    private TestResult getResultFromChildren() {
        TestResultList resultList = TestResultList.of(this.getChildResults());
        return resultList.getOverallResult();
    }

    private List<TestResult> getChildResults() {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        for (TestStep step : this.getChildren()) {
            results.add(step.getResult());
        }
        return results;
    }

    public Boolean isSuccessful() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isError() {
        return this.getResult() == TestResult.ERROR;
    }

    public Boolean isIgnored() {
        return this.getResult() == TestResult.IGNORED;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public double getDurationInSeconds() {
        return TestDuration.of(this.duration).inSeconds();
    }

    public void failedWith(Throwable cause) {
        this.exception = new RootCauseAnalyzer(cause).getRootCause();
        this.setResult(new FailureAnalysis().resultFor(this.exception.toException()));
    }

    public String getErrorMessage() {
        return this.exception != null ? this.exception.getMessage() : "";
    }

    public void testAborted(Throwable exception) {
        this.exception = new RootCauseAnalyzer(exception).getRootCause();
    }

    private String errorMessageFrom(Throwable error) {
        return error.getCause() != null ? error.getCause().getMessage() : error.getMessage();
    }

    public String getShortErrorMessage() {
        return new ErrorMessageFormatter(this.getErrorMessage()).getShortErrorMessage();
    }

    public FailureCause getException() {
        return this.exception;
    }

    public List<? extends TestStep> getFlattenedSteps() {
        ArrayList<? extends TestStep> flattenedSteps = new ArrayList<TestStep>();
        for (TestStep child : this.getChildren()) {
            flattenedSteps.add(child);
            if (!child.isAGroup()) continue;
            flattenedSteps.addAll(child.getFlattenedSteps());
        }
        return flattenedSteps;
    }

    public boolean isAGroup() {
        return this.hasChildren();
    }

    public TestStep addChildStep(TestStep step) {
        this.children.add(step);
        return this;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Collection<? extends TestStep> getLeafTestSteps() {
        ArrayList<? extends TestStep> leafSteps = new ArrayList<TestStep>();
        for (TestStep child : this.getChildren()) {
            if (child.isAGroup()) {
                leafSteps.addAll(child.getLeafTestSteps());
                continue;
            }
            leafSteps.add(child);
        }
        return leafSteps;
    }

    public TestStep addScreenshot(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.thisIsANew(screenshotAndHtmlSource)) {
            this.screenshots.add(screenshotAndHtmlSource);
        }
        return this;
    }

    private boolean thisIsANew(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.screenshots.isEmpty()) {
            return true;
        }
        ScreenshotAndHtmlSource latestScreenshotAndHtmlSource = this.screenshots.get(this.screenshots.size() - 1);
        return !latestScreenshotAndHtmlSource.equals(screenshotAndHtmlSource);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getScreenshotCount() {
        return this.screenshots.size();
    }

    public void removeScreenshot(int index) {
        this.screenshots.remove(index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestStep)) {
            return false;
        }
        TestStep testStep = (TestStep)o;
        if (this.duration != testStep.duration) {
            return false;
        }
        if (this.number != testStep.number) {
            return false;
        }
        if (this.startTime != testStep.startTime) {
            return false;
        }
        if (!this.children.equals(testStep.children)) {
            return false;
        }
        if (!this.description.equals(testStep.description)) {
            return false;
        }
        if (this.result != testStep.result) {
            return false;
        }
        return !(this.screenshots == null ? testStep.screenshots != null : !this.screenshots.equals(testStep.screenshots));
    }

    private boolean exceptionsAreEqual(Throwable exception, Throwable otherException) {
        if (exception == null && otherException == null) {
            return true;
        }
        return StringUtils.equals((CharSequence)exception.getMessage(), (CharSequence)otherException.getMessage()) && this.exceptionsAreEqual(exception.getCause(), otherException.getCause());
    }

    public int hashCode() {
        int result1 = this.number;
        result1 = 31 * result1 + this.description.hashCode();
        result1 = 31 * result1 + (int)(this.duration ^ this.duration >>> 32);
        result1 = 31 * result1 + (int)(this.startTime ^ this.startTime >>> 32);
        result1 = 31 * result1 + (this.screenshots != null ? this.screenshots.hashCode() : 0);
        result1 = 31 * result1 + (this.exception != null ? this.exception.hashCode() : 0);
        result1 = 31 * result1 + this.result.hashCode();
        result1 = 31 * result1 + this.children.hashCode();
        return result1;
    }

    public static class TestStepBuilder {
        private final String description;

        public TestStepBuilder(String description) {
            this.description = description;
        }

        public TestStep withResult(TestResult result) {
            TestStep step = new TestStep(this.description);
            step.setResult(result);
            return step;
        }
    }
}

