/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.lang.reflect.Field;
import java.util.List;
import net.serenitybdd.core.annotations.locators.SmartAnnotations;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class SmartElementLocator
implements ElementLocator {
    private final SearchContext searchContext;
    private final boolean shouldCache;
    private final By by;
    private WebElement cachedElement;
    private List<WebElement> cachedElementList;

    public SmartElementLocator(SearchContext searchContext, Field field) {
        this.searchContext = searchContext;
        SmartAnnotations annotations = new SmartAnnotations(field);
        this.shouldCache = annotations.isLookupCached();
        this.by = annotations.buildBy();
    }

    public WebElement findElement() {
        if (this.cachedElement != null && this.shouldCache) {
            return this.cachedElement;
        }
        WebElement element = this.searchContext.findElement(this.by);
        if (this.shouldCache) {
            this.cachedElement = element;
        }
        return element;
    }

    public List<WebElement> findElements() {
        if (this.cachedElementList != null && this.shouldCache) {
            return this.cachedElementList;
        }
        List elements = this.searchContext.findElements(this.by);
        if (this.shouldCache) {
            this.cachedElementList = elements;
        }
        return elements;
    }
}

