/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class CardAnimator
extends SimpleItemAnimator {
    private static final boolean DEBUG = false;
    private static TimeInterpolator sDefaultInterpolator;
    private float mInterpolationFactor = 1.0f;
    private int mStaggerDelay = 0;
    private int mAddDirection;
    private int mRemoveDirection;
    private int mTranslationAmount = 100;
    private Interpolator mAddInterpolator = new LinearInterpolator();
    private Interpolator mRemoveInterpolator = new LinearInterpolator();
    private Interpolator mMoveInterpolator = new LinearInterpolator();
    private Interpolator mChangeInterpolator = new LinearInterpolator();
    private ArrayList<RecyclerView.ViewHolder> mPendingRemovals = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mPendingAdditions = new ArrayList();
    private ArrayList<MoveInfo> mPendingMoves = new ArrayList();
    private ArrayList<ChangeInfo> mPendingChanges = new ArrayList();
    private ArrayList<ArrayList<RecyclerView.ViewHolder>> mAdditionsList = new ArrayList();
    private ArrayList<ArrayList<MoveInfo>> mMovesList = new ArrayList();
    private ArrayList<ArrayList<ChangeInfo>> mChangesList = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mAddAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mMoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mRemoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mChangeAnimations = new ArrayList();
    public static final int EAST = 0;
    public static final int NORTH = 2;
    public static final int WEST = 4;
    public static final int SOUTH = 6;
    public static final int DIRECTION_IN = 0;
    public static final int DIRECTION_OUT = 1;

    public void runPendingAnimations() {
        boolean additionsPending;
        boolean removalsPending = !this.mPendingRemovals.isEmpty();
        boolean movesPending = !this.mPendingMoves.isEmpty();
        boolean changesPending = !this.mPendingChanges.isEmpty();
        boolean bl = additionsPending = !this.mPendingAdditions.isEmpty();
        if (!(removalsPending || movesPending || additionsPending || changesPending)) {
            return;
        }
        for (RecyclerView.ViewHolder holder : this.mPendingRemovals) {
            this.animateRemoveImpl(holder);
        }
        this.mPendingRemovals.clear();
        if (movesPending) {
            final ArrayList<MoveInfo> moves = new ArrayList<MoveInfo>();
            moves.addAll(this.mPendingMoves);
            this.mMovesList.add(moves);
            this.mPendingMoves.clear();
            Runnable mover = new Runnable(){

                @Override
                public void run() {
                    for (MoveInfo moveInfo : moves) {
                        CardAnimator.this.animateMoveImpl(moveInfo.holder, moveInfo.fromX, moveInfo.fromY, moveInfo.toX, moveInfo.toY);
                    }
                    moves.clear();
                    CardAnimator.this.mMovesList.remove(moves);
                }
            };
            if (removalsPending) {
                View view = ((MoveInfo)moves.get((int)0)).holder.itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)mover, (long)this.getRemoveDuration());
            } else {
                mover.run();
            }
        }
        if (changesPending) {
            final ArrayList<ChangeInfo> changes = new ArrayList<ChangeInfo>();
            changes.addAll(this.mPendingChanges);
            this.mChangesList.add(changes);
            this.mPendingChanges.clear();
            Runnable changer = new Runnable(){

                @Override
                public void run() {
                    for (ChangeInfo change : changes) {
                        CardAnimator.this.animateChangeImpl(change);
                    }
                    changes.clear();
                    CardAnimator.this.mChangesList.remove(changes);
                }
            };
            if (removalsPending) {
                RecyclerView.ViewHolder holder = ((ChangeInfo)changes.get((int)0)).oldHolder;
                ViewCompat.postOnAnimationDelayed((View)holder.itemView, (Runnable)changer, (long)this.getRemoveDuration());
            } else {
                changer.run();
            }
        }
        if (additionsPending) {
            final ArrayList<RecyclerView.ViewHolder> additions = new ArrayList<RecyclerView.ViewHolder>();
            additions.addAll(this.mPendingAdditions);
            this.mAdditionsList.add(additions);
            this.mPendingAdditions.clear();
            Runnable adder = new Runnable(){

                @Override
                public void run() {
                    int firstAddingItemIndex = CardAnimator.this.getFirstHolder(additions);
                    for (RecyclerView.ViewHolder holder : additions) {
                        int delay = (holder.getLayoutPosition() - firstAddingItemIndex) * CardAnimator.this.mStaggerDelay;
                        CardAnimator.this.animateAddImpl(holder, delay);
                    }
                    additions.clear();
                    CardAnimator.this.mAdditionsList.remove(additions);
                }
            };
            if (removalsPending || movesPending || changesPending) {
                long removeDuration = removalsPending ? this.getRemoveDuration() : 0L;
                long moveDuration = movesPending ? this.getMoveDuration() : 0L;
                long changeDuration = changesPending ? this.getChangeDuration() : 0L;
                long totalDelay = removeDuration + Math.max(moveDuration, changeDuration);
                View view = ((RecyclerView.ViewHolder)additions.get((int)0)).itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)adder, (long)totalDelay);
            } else {
                adder.run();
            }
        }
    }

    private int getFirstHolder(ArrayList<RecyclerView.ViewHolder> additions) {
        int firstIndex = Integer.MAX_VALUE;
        for (RecyclerView.ViewHolder holder : additions) {
            firstIndex = Math.min(holder.getLayoutPosition(), firstIndex);
        }
        return firstIndex;
    }

    private void configureAnimator(View view, int from, int direction) {
        int yEnd;
        int yStart;
        int xEnd;
        int xStart;
        int yMovement;
        int xMovement;
        switch (from) {
            case 2: {
                xMovement = 0;
                yMovement = -this.mTranslationAmount;
                break;
            }
            case 6: {
                xMovement = 0;
                yMovement = this.mTranslationAmount;
                break;
            }
            case 0: {
                xMovement = this.mTranslationAmount;
                yMovement = 0;
                break;
            }
            case 4: {
                xMovement = -this.mTranslationAmount;
                yMovement = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction.");
            }
        }
        switch (direction) {
            case 0: {
                xStart = xMovement;
                xEnd = 0;
                yStart = yMovement;
                yEnd = 0;
                break;
            }
            case 1: {
                xStart = 0;
                xEnd = xMovement;
                yStart = 0;
                yEnd = yMovement;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction.");
            }
        }
        view.setTranslationX((float)xStart);
        view.setTranslationY((float)yStart);
        view.animate().translationX((float)xEnd).translationY((float)yEnd);
    }

    public boolean animateRemove(RecyclerView.ViewHolder holder) {
        this.resetAnimation(holder);
        this.mPendingRemovals.add(holder);
        return true;
    }

    private void animateRemoveImpl(final RecyclerView.ViewHolder holder) {
        final View view = holder.itemView;
        final ViewPropertyAnimator animation = view.animate();
        this.mRemoveAnimations.add(holder);
        this.configureAnimator(view, this.mRemoveDirection, 1);
        animation.alpha(0.0f).setDuration(this.getRemoveDuration()).setInterpolator((TimeInterpolator)this.mRemoveInterpolator).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                CardAnimator.this.dispatchRemoveStarting(holder);
            }

            public void onAnimationEnd(Animator animator) {
                animation.setListener(null);
                view.setAlpha(1.0f);
                view.setTranslationX(0.0f);
                view.setTranslationY(0.0f);
                CardAnimator.this.dispatchRemoveFinished(holder);
                CardAnimator.this.mRemoveAnimations.remove(holder);
                CardAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateAdd(RecyclerView.ViewHolder holder) {
        this.resetAnimation(holder);
        holder.itemView.setAlpha(0.0f);
        this.mPendingAdditions.add(holder);
        return true;
    }

    private void animateAddImpl(final RecyclerView.ViewHolder holder, int delay) {
        final View view = holder.itemView;
        final ViewPropertyAnimator animation = view.animate();
        this.mAddAnimations.add(holder);
        this.configureAnimator(view, this.mAddDirection, 0);
        animation.alpha(1.0f).setStartDelay((long)delay).setDuration(this.getAddDuration()).setInterpolator((TimeInterpolator)this.mAddInterpolator).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                CardAnimator.this.dispatchAddStarting(holder);
            }

            public void onAnimationCancel(Animator animator) {
                view.setAlpha(1.0f);
                view.setTranslationX(0.0f);
                view.setTranslationY(0.0f);
            }

            public void onAnimationEnd(Animator animator) {
                animation.setListener(null);
                CardAnimator.this.dispatchAddFinished(holder);
                CardAnimator.this.mAddAnimations.remove(holder);
                CardAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateMove(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        this.resetAnimation(holder);
        int deltaX = toX - (fromX += (int)holder.itemView.getTranslationX());
        int deltaY = toY - (fromY += (int)holder.itemView.getTranslationY());
        if (deltaX == 0 && deltaY == 0) {
            this.dispatchMoveFinished(holder);
            return false;
        }
        if (deltaX != 0) {
            view.setTranslationX((float)(-deltaX));
        }
        if (deltaY != 0) {
            view.setTranslationY((float)(-deltaY));
        }
        this.mPendingMoves.add(new MoveInfo(holder, fromX, fromY, toX, toY));
        return true;
    }

    void animateMoveImpl(final RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        final View view = holder.itemView;
        final int deltaX = toX - fromX;
        final int deltaY = toY - fromY;
        if (deltaX != 0) {
            view.animate().translationX(0.0f);
        }
        if (deltaY != 0) {
            view.animate().translationY(0.0f);
        }
        final ViewPropertyAnimator animation = view.animate();
        this.mMoveAnimations.add(holder);
        animation.setDuration(this.getMoveDuration()).setInterpolator((TimeInterpolator)this.mMoveInterpolator).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                CardAnimator.this.dispatchMoveStarting(holder);
            }

            public void onAnimationCancel(Animator animator) {
                if (deltaX != 0) {
                    view.setTranslationX(0.0f);
                }
                if (deltaY != 0) {
                    view.setTranslationY(0.0f);
                }
            }

            public void onAnimationEnd(Animator animator) {
                animation.setListener(null);
                CardAnimator.this.dispatchMoveFinished(holder);
                CardAnimator.this.mMoveAnimations.remove(holder);
                CardAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateChange(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
        if (oldHolder == newHolder) {
            return this.animateMove(oldHolder, fromX, fromY, toX, toY);
        }
        float prevTranslationX = oldHolder.itemView.getTranslationX();
        float prevTranslationY = oldHolder.itemView.getTranslationY();
        float prevAlpha = oldHolder.itemView.getAlpha();
        this.resetAnimation(oldHolder);
        int deltaX = (int)((float)(toX - fromX) - prevTranslationX);
        int deltaY = (int)((float)(toY - fromY) - prevTranslationY);
        oldHolder.itemView.setTranslationX(prevTranslationX);
        oldHolder.itemView.setTranslationY(prevTranslationY);
        oldHolder.itemView.setAlpha(prevAlpha);
        if (newHolder != null) {
            this.resetAnimation(newHolder);
            newHolder.itemView.setTranslationX((float)(-deltaX));
            newHolder.itemView.setTranslationY((float)(-deltaY));
            newHolder.itemView.setAlpha(0.0f);
        }
        this.mPendingChanges.add(new ChangeInfo(oldHolder, newHolder, fromX, fromY, toX, toY));
        return true;
    }

    void animateChangeImpl(final ChangeInfo changeInfo) {
        View newView;
        RecyclerView.ViewHolder holder = changeInfo.oldHolder;
        final View view = holder == null ? null : holder.itemView;
        RecyclerView.ViewHolder newHolder = changeInfo.newHolder;
        View view2 = newView = newHolder != null ? newHolder.itemView : null;
        if (view != null) {
            final ViewPropertyAnimator oldViewAnim = view.animate().setDuration(this.getChangeDuration());
            this.mChangeAnimations.add(changeInfo.oldHolder);
            oldViewAnim.translationX((float)(changeInfo.toX - changeInfo.fromX));
            oldViewAnim.translationY((float)(changeInfo.toY - changeInfo.fromY));
            oldViewAnim.alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animator) {
                    CardAnimator.this.dispatchChangeStarting(changeInfo.oldHolder, true);
                }

                public void onAnimationEnd(Animator animator) {
                    oldViewAnim.setListener(null);
                    view.setAlpha(1.0f);
                    view.setTranslationX(0.0f);
                    view.setTranslationY(0.0f);
                    CardAnimator.this.dispatchChangeFinished(changeInfo.oldHolder, true);
                    CardAnimator.this.mChangeAnimations.remove(changeInfo.oldHolder);
                    CardAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
        if (newView != null) {
            final ViewPropertyAnimator newViewAnimation = newView.animate();
            this.mChangeAnimations.add(changeInfo.newHolder);
            newViewAnimation.translationX(0.0f).translationY(0.0f).setDuration(this.getChangeDuration()).alpha(1.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animator) {
                    CardAnimator.this.dispatchChangeStarting(changeInfo.newHolder, false);
                }

                public void onAnimationEnd(Animator animator) {
                    newViewAnimation.setListener(null);
                    newView.setAlpha(1.0f);
                    newView.setTranslationX(0.0f);
                    newView.setTranslationY(0.0f);
                    CardAnimator.this.dispatchChangeFinished(changeInfo.newHolder, false);
                    CardAnimator.this.mChangeAnimations.remove(changeInfo.newHolder);
                    CardAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
    }

    private void endChangeAnimation(List<ChangeInfo> infoList, RecyclerView.ViewHolder item) {
        for (int i = infoList.size() - 1; i >= 0; --i) {
            ChangeInfo changeInfo = infoList.get(i);
            if (!this.endChangeAnimationIfNecessary(changeInfo, item) || changeInfo.oldHolder != null || changeInfo.newHolder != null) continue;
            infoList.remove(changeInfo);
        }
    }

    private void endChangeAnimationIfNecessary(ChangeInfo changeInfo) {
        if (changeInfo.oldHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.oldHolder);
        }
        if (changeInfo.newHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.newHolder);
        }
    }

    private boolean endChangeAnimationIfNecessary(ChangeInfo changeInfo, RecyclerView.ViewHolder item) {
        boolean oldItem = false;
        if (changeInfo.newHolder == item) {
            changeInfo.newHolder = null;
        } else if (changeInfo.oldHolder == item) {
            changeInfo.oldHolder = null;
            oldItem = true;
        } else {
            return false;
        }
        item.itemView.setAlpha(1.0f);
        item.itemView.setTranslationX(0.0f);
        item.itemView.setTranslationY(0.0f);
        this.dispatchChangeFinished(item, oldItem);
        return true;
    }

    public void endAnimation(RecyclerView.ViewHolder item) {
        int i;
        View view = item.itemView;
        view.animate().cancel();
        for (i = this.mPendingMoves.size() - 1; i >= 0; --i) {
            MoveInfo moveInfo = this.mPendingMoves.get(i);
            if (moveInfo.holder != item) continue;
            view.setTranslationY(0.0f);
            view.setTranslationX(0.0f);
            this.dispatchMoveFinished(item);
            this.mPendingMoves.remove(i);
        }
        this.endChangeAnimation(this.mPendingChanges, item);
        if (this.mPendingRemovals.remove(item)) {
            view.setAlpha(1.0f);
            this.dispatchRemoveFinished(item);
        }
        if (this.mPendingAdditions.remove(item)) {
            view.setAlpha(1.0f);
            this.dispatchAddFinished(item);
        }
        for (i = this.mChangesList.size() - 1; i >= 0; --i) {
            ArrayList<ChangeInfo> changes = this.mChangesList.get(i);
            this.endChangeAnimation(changes, item);
            if (!changes.isEmpty()) continue;
            this.mChangesList.remove(i);
        }
        block2: for (i = this.mMovesList.size() - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            for (int j = moves.size() - 1; j >= 0; --j) {
                MoveInfo moveInfo = moves.get(j);
                if (moveInfo.holder != item) continue;
                view.setTranslationY(0.0f);
                view.setTranslationX(0.0f);
                this.dispatchMoveFinished(item);
                moves.remove(j);
                if (!moves.isEmpty()) continue block2;
                this.mMovesList.remove(i);
                continue block2;
            }
        }
        for (i = this.mAdditionsList.size() - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            if (!additions.remove(item)) continue;
            view.setAlpha(1.0f);
            this.dispatchAddFinished(item);
            if (!additions.isEmpty()) continue;
            this.mAdditionsList.remove(i);
        }
        if (this.mRemoveAnimations.remove(item)) {
            // empty if block
        }
        if (this.mAddAnimations.remove(item)) {
            // empty if block
        }
        if (this.mChangeAnimations.remove(item)) {
            // empty if block
        }
        if (this.mMoveAnimations.remove(item)) {
            // empty if block
        }
        this.dispatchFinishedWhenDone();
    }

    private void resetAnimation(RecyclerView.ViewHolder holder) {
        if (sDefaultInterpolator == null) {
            sDefaultInterpolator = new ValueAnimator().getInterpolator();
        }
        holder.itemView.animate().setInterpolator(sDefaultInterpolator);
        this.endAnimation(holder);
    }

    public boolean isRunning() {
        return !this.mPendingAdditions.isEmpty() || !this.mPendingChanges.isEmpty() || !this.mPendingMoves.isEmpty() || !this.mPendingRemovals.isEmpty() || !this.mMoveAnimations.isEmpty() || !this.mRemoveAnimations.isEmpty() || !this.mAddAnimations.isEmpty() || !this.mChangeAnimations.isEmpty() || !this.mMovesList.isEmpty() || !this.mAdditionsList.isEmpty() || !this.mChangesList.isEmpty();
    }

    void dispatchFinishedWhenDone() {
        if (!this.isRunning()) {
            this.dispatchAnimationsFinished();
        }
    }

    public void endAnimations() {
        int j;
        int i;
        MoveInfo item;
        int i2;
        int count = this.mPendingMoves.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingMoves.get(i2);
            View view = item.holder.itemView;
            view.setTranslationY(0.0f);
            view.setTranslationX(0.0f);
            this.dispatchMoveFinished(item.holder);
            this.mPendingMoves.remove(i2);
        }
        count = this.mPendingRemovals.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingRemovals.get(i2);
            this.dispatchRemoveFinished((RecyclerView.ViewHolder)item);
            this.mPendingRemovals.remove(i2);
        }
        count = this.mPendingAdditions.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingAdditions.get(i2);
            ((RecyclerView.ViewHolder)item).itemView.setAlpha(1.0f);
            this.dispatchAddFinished((RecyclerView.ViewHolder)item);
            this.mPendingAdditions.remove(i2);
        }
        count = this.mPendingChanges.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            this.endChangeAnimationIfNecessary(this.mPendingChanges.get(i2));
        }
        this.mPendingChanges.clear();
        if (!this.isRunning()) {
            return;
        }
        int listCount = this.mMovesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            count = moves.size();
            for (j = count - 1; j >= 0; --j) {
                MoveInfo moveInfo = moves.get(j);
                RecyclerView.ViewHolder item2 = moveInfo.holder;
                View view = item2.itemView;
                view.setTranslationY(0.0f);
                view.setTranslationX(0.0f);
                this.dispatchMoveFinished(moveInfo.holder);
                moves.remove(j);
                if (!moves.isEmpty()) continue;
                this.mMovesList.remove(moves);
            }
        }
        listCount = this.mAdditionsList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            count = additions.size();
            for (j = count - 1; j >= 0; --j) {
                RecyclerView.ViewHolder item3 = additions.get(j);
                View view = item3.itemView;
                view.setAlpha(1.0f);
                this.dispatchAddFinished(item3);
                additions.remove(j);
                if (!additions.isEmpty()) continue;
                this.mAdditionsList.remove(additions);
            }
        }
        listCount = this.mChangesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<ChangeInfo> changes = this.mChangesList.get(i);
            count = changes.size();
            for (j = count - 1; j >= 0; --j) {
                this.endChangeAnimationIfNecessary(changes.get(j));
                if (!changes.isEmpty()) continue;
                this.mChangesList.remove(changes);
            }
        }
        this.cancelAll(this.mRemoveAnimations);
        this.cancelAll(this.mMoveAnimations);
        this.cancelAll(this.mAddAnimations);
        this.cancelAll(this.mChangeAnimations);
        this.dispatchAnimationsFinished();
    }

    void cancelAll(List<RecyclerView.ViewHolder> viewHolders) {
        for (int i = viewHolders.size() - 1; i >= 0; --i) {
            viewHolders.get((int)i).itemView.animate().cancel();
        }
    }

    public boolean canReuseUpdatedViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull List<Object> payloads) {
        return !payloads.isEmpty() || super.canReuseUpdatedViewHolder(viewHolder, payloads);
    }

    public float getInterpolationFactor() {
        return this.mInterpolationFactor;
    }

    public void setInterpolationFactor(float value) {
        this.mInterpolationFactor = value;
    }

    public int getStaggerDelay() {
        return this.mStaggerDelay;
    }

    public void setStaggerDelay(int value) {
        this.mStaggerDelay = value;
    }

    public int getAnimationDuration() {
        return this.mAddDirection;
    }

    public void setAnimationDuration(int value) {
        this.mAddDirection = value;
    }

    public int getAddDirection() {
        return this.mAddDirection;
    }

    public int getRemoveDirection() {
        return this.mRemoveDirection;
    }

    public void setDirection(int direction) {
        this.setAddDirection(direction);
        this.setRemoveDirection(direction);
    }

    public void setAddDirection(int direction) {
        this.mAddDirection = direction;
    }

    public void setRemoveDirection(int direction) {
        this.mRemoveDirection = direction;
    }

    public int getTranslationAmount() {
        return this.mTranslationAmount;
    }

    public void setTranslationAmount(int value) {
        this.mTranslationAmount = value;
    }

    public void setAddInterpolator(Interpolator interpolator) {
        this.mAddInterpolator = interpolator;
    }

    public void setRemoveInterpolator(Interpolator interpolator) {
        this.mRemoveInterpolator = interpolator;
    }

    public void setMoveInterpolator(Interpolator interpolator) {
        this.mMoveInterpolator = interpolator;
    }

    private static class ChangeInfo {
        public RecyclerView.ViewHolder oldHolder;
        public RecyclerView.ViewHolder newHolder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        private ChangeInfo(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder) {
            this.oldHolder = oldHolder;
            this.newHolder = newHolder;
        }

        ChangeInfo(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
            this(oldHolder, newHolder);
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }

        public String toString() {
            return "ChangeInfo{oldHolder=" + this.oldHolder + ", newHolder=" + this.newHolder + ", fromX=" + this.fromX + ", fromY=" + this.fromY + ", toX=" + this.toX + ", toY=" + this.toY + '}';
        }
    }

    private static class MoveInfo {
        public RecyclerView.ViewHolder holder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        MoveInfo(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
            this.holder = holder;
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }
}

