/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import net.scarlettsystems.android.widget.ScarlettItemAnimator;
import net.scarlettsystems.android.widget.ScarlettRecyclerAdapter;

public class EasyRecyclerView
extends RecyclerView {
    private Context mContext;
    private ScarlettRecyclerAdapter mAdapter;
    private ScarlettItemAnimator mAnimator;
    private ArrayList<OnItemClickListener> mOnItemClickListeners = new ArrayList();
    private ArrayList<OnItemLongClickListener> mOnItemLongClickListeners = new ArrayList();
    private ArrayList<OnLoadRequestListener> mOnLoadRequestListeners = new ArrayList();
    private int mAnimationDuration = this.getResources().getInteger(0x10E0001);
    private boolean mEnabled = true;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int NORTH = 2;
    public static final int SOUTH = 6;
    public static final int EAST = 0;
    public static final int WEST = 4;
    private static final String EX_TYPE_CODE = "Type code must be a positive integer.";
    private static final String EX_SPAN_COUNT = "Span count must be an integer larger than zero.";
    private static final String EX_ORIENTATION = "Unrecognised orientation. Required: VERTICAL or HORIZONTAL.";

    public EasyRecyclerView(Context context) {
        super(context);
        this.init(context);
    }

    public EasyRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EasyRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.configureRecyclerView();
        this.configureAdapter();
        this.configureLayoutManager();
        this.configureAnimator();
    }

    private void configureRecyclerView() {
        this.setHasFixedSize(true);
        this.setItemViewCacheSize(20);
        this.setDrawingCacheEnabled(true);
        this.setLayoutTransition(null);
        this.setDrawingCacheQuality(0);
        this.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (!recyclerView.canScrollVertically(1) && newState == 0) {
                    if (EasyRecyclerView.this.mAdapter.isLoaderShown()) {
                        return;
                    }
                    for (OnLoadRequestListener l : EasyRecyclerView.this.mOnLoadRequestListeners) {
                        l.OnLoadRequest();
                    }
                }
            }
        });
    }

    protected void onAttachedToWindow() {
        ((ViewGroup)this.getParent()).setLayoutTransition(null);
        super.onAttachedToWindow();
    }

    public void onScrolled(int dx, int dy) {
    }

    private void configureAdapter() {
        this.mAdapter = new ScarlettRecyclerAdapter();
        this.setAdapter(this.mAdapter);
        this.mAdapter.setAnimationDuration(this.mAnimationDuration);
        this.mAdapter.setOnItemClickListener(new ScarlettRecyclerAdapter.OnItemClickListener(){

            @Override
            public void OnItemClick(View v, Object object) {
                if (!EasyRecyclerView.this.mEnabled) {
                    return;
                }
                for (OnItemClickListener l : EasyRecyclerView.this.mOnItemClickListeners) {
                    l.OnItemClick(v, object);
                }
            }
        });
        this.mAdapter.setOnItemLongClickListener(new ScarlettRecyclerAdapter.OnItemLongClickListener(){

            @Override
            public void OnItemLongClick(View v, Object object) {
                if (!EasyRecyclerView.this.mEnabled) {
                    return;
                }
                for (OnItemLongClickListener l : EasyRecyclerView.this.mOnItemLongClickListeners) {
                    l.OnItemLongClick(v, object);
                }
            }
        });
    }

    private void configureLayoutManager() {
        super.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext, 1, false));
    }

    private void configureAnimator() {
        this.mAnimator = new ScarlettItemAnimator();
        this.setItemAnimator((RecyclerView.ItemAnimator)this.mAnimator);
    }

    public void addOnCreateItemViewListener(int typeCode, final OnCreateItemViewListener l) {
        if (typeCode < 0) {
            throw new IllegalArgumentException(EX_TYPE_CODE);
        }
        this.mAdapter.addOnItemViewListener(new ScarlettRecyclerAdapter.ItemViewListener(){

            @Override
            public View OnCreateItemView(ViewGroup parent) {
                return l.OnCreateItemView();
            }

            @Override
            public void OnBindItemView(View v, SparseArray<View> cache, Object item) {
                l.OnBindItemView(v, cache, item);
            }
        }, typeCode);
    }

    public void addOnBindItemViewListener(int typeCode, final @LayoutRes int resId, final OnBindItemViewListener l) {
        if (typeCode < 0) {
            throw new IllegalArgumentException(EX_TYPE_CODE);
        }
        this.mAdapter.addOnItemViewListener(new ScarlettRecyclerAdapter.ItemViewListener(){

            @Override
            public View OnCreateItemView(ViewGroup parent) {
                return LayoutInflater.from((Context)EasyRecyclerView.this.mContext).inflate(resId, parent, false);
            }

            @Override
            public void OnBindItemView(View v, SparseArray<View> cache, Object item) {
                l.OnBindItemView(v, cache, item);
            }
        }, typeCode);
    }

    public void removeOnItemListener(int typeCode) {
        this.mAdapter.removeOnItemViewListener(typeCode);
    }

    public void clearOnItemListeners() {
        this.mAdapter.clearOnItemViewListeners();
    }

    public void addOnItemClickListener(OnItemClickListener l) {
        this.mOnItemClickListeners.add(l);
    }

    public void removeOnItemClickListener(OnItemClickListener l) {
        this.mOnItemClickListeners.remove(l);
    }

    public void clearOnItemClickListeners() {
        this.mOnItemClickListeners.clear();
    }

    public void addOnItemLongClickListener(OnItemLongClickListener l) {
        this.mOnItemLongClickListeners.add(l);
    }

    public void removeOnItemLongClickListener(OnItemLongClickListener l) {
        this.mOnItemLongClickListeners.remove(l);
    }

    public void clearOnItemLongClickListeners() {
        this.mOnItemLongClickListeners.clear();
    }

    public void addOnLoadRequestListener(OnLoadRequestListener l) {
        this.mOnLoadRequestListeners.add(l);
    }

    public void removeOnLoadRequestListener(OnLoadRequestListener l) {
        this.mOnLoadRequestListeners.remove(l);
    }

    public void clearOnLoadRequestListener() {
        this.mOnLoadRequestListeners.clear();
    }

    public void enable() {
        this.mEnabled = true;
    }

    public void disable() {
        this.mEnabled = false;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public void setLayoutManager(RecyclerView.LayoutManager lm) {
        super.setLayoutManager(lm);
    }

    public void setLayoutManager(int spanCount, int orientation, boolean staggered, boolean reverseLayout) {
        if (spanCount < 1) {
            throw new IllegalArgumentException(EX_SPAN_COUNT);
        }
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException(EX_ORIENTATION);
        }
        Object lm = spanCount == 1 ? new LinearLayoutManager(this.mContext, orientation, reverseLayout) : (!staggered ? new GridLayoutManager(this.mContext, spanCount, orientation, reverseLayout) : new StaggeredGridLayoutManager(spanCount, orientation));
        lm.setAutoMeasureEnabled(true);
        super.setLayoutManager((RecyclerView.LayoutManager)lm);
    }

    public void setLoaderHeight(int height) {
        this.mAdapter.setLoaderHeight(height);
    }

    public void setLoaderPadding(int padding) {
        this.mAdapter.setLoaderPadding(padding);
    }

    public void setLoaderPaddingTop(int padding) {
        this.mAdapter.setLoaderPaddingTop(padding);
    }

    public void setLoaderPaddingBottom(int padding) {
        this.mAdapter.setLoaderPaddingBottom(padding);
    }

    public void setLoaderColour(int colour) {
        this.mAdapter.setLoaderColour(colour);
    }

    public void showLoader() {
        this.mAdapter.showLoader();
    }

    public void hideLoader() {
        this.mAdapter.hideLoader();
    }

    public void setBottomPadding(int padding) {
        this.mAdapter.setBottomPadding(padding);
    }

    public void setEmptyPromptView(View v) {
        this.mAdapter.setEmptyPromptView(v);
    }

    public void enableAnimation() {
        this.setItemAnimator((RecyclerView.ItemAnimator)this.mAnimator);
        this.mAdapter.setAnimationEnabled(true);
    }

    public void disableAnimation() {
        this.setItemAnimator(null);
        this.mAdapter.setAnimationEnabled(false);
    }

    public void setAnimationEnabled(boolean enabled) {
        if (enabled) {
            this.enableAnimation();
        } else {
            this.disableAnimation();
        }
    }

    public void setItemAddDirection(int direction) {
        this.mAnimator.setAddDirection(direction);
    }

    public void setItemRemoveDirection(int direction) {
        this.mAnimator.setRemoveDirection(direction);
    }

    public void setItemDirection(int direction) {
        this.mAnimator.setDirection(direction);
    }

    public void setItemTranslationAmount(int distance) {
        this.mAnimator.setTranslationAmount(distance);
    }

    public void setAnimationDuration(int duration) {
        this.mAdapter.setAnimationDuration(duration);
        this.mAnimator.setRemoveDuration(duration);
        this.mAnimator.setAddDuration(duration);
        this.mAnimator.setMoveDuration(duration);
        this.mAnimator.setChangeDuration(duration);
    }

    public void setItemAddInterpolator(Interpolator interpolator) {
        this.mAnimator.setAddInterpolator(interpolator);
    }

    public void setItemRemoveInterpolator(Interpolator interpolator) {
        this.mAnimator.setRemoveInterpolator(interpolator);
    }

    public void setItemMoveInterpolator(Interpolator interpolator) {
        this.mAnimator.setMoveInterpolator(interpolator);
    }

    public void setItemInterpolator(Interpolator interpolator) {
        this.mAnimator.setAddInterpolator(interpolator);
        this.mAnimator.setRemoveInterpolator(interpolator);
        this.mAnimator.setMoveInterpolator(interpolator);
    }

    public void setAnimationStagger(int duration) {
        this.mAnimator.setStaggerDelay(duration);
    }

    public void setLoaderShowInterpolator(Interpolator interpolator) {
        this.mAdapter.setLoaderShowInterpolator(interpolator);
    }

    public void setLoaderHideInterpolator(Interpolator interpolator) {
        this.mAdapter.setLoaderHideInterpolator(interpolator);
    }

    public void setLoaderInterpolator(Interpolator interpolator) {
        this.mAdapter.setLoaderShowInterpolator(interpolator);
        this.mAdapter.setLoaderHideInterpolator(interpolator);
    }

    public void addItem(Object item, int typeCode) {
        if (typeCode < 0) {
            throw new IllegalArgumentException(EX_TYPE_CODE);
        }
        this.mAdapter.addItem(item, typeCode);
    }

    public void addItems(ArrayList<?> items, int typeCode) {
        if (typeCode < 0) {
            throw new IllegalArgumentException(EX_TYPE_CODE);
        }
        this.mAdapter.addItems(items, typeCode);
    }

    public void addItemAt(Object item, int index, int typeCode) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.mAdapter.getItemCountProtected()) {
            throw new IndexOutOfBoundsException();
        }
        if (typeCode < 0) {
            throw new IllegalArgumentException(EX_TYPE_CODE);
        }
        this.mAdapter.addItemAt(item, index, typeCode);
    }

    public void removeItem(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.mAdapter.getItemCountProtected()) {
            throw new IndexOutOfBoundsException();
        }
        this.mAdapter.removeItem(index);
    }

    public void replaceItem(Object item, int index, int typeCode) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.mAdapter.getItemCountProtected()) {
            throw new IndexOutOfBoundsException();
        }
        if (typeCode < 0) {
            throw new IllegalArgumentException(EX_TYPE_CODE);
        }
        this.mAdapter.replaceItem(item, index, typeCode);
    }

    public void removeAll() {
        this.mAdapter.removeAll();
    }

    public Object getItem(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.mAdapter.getItemCountProtected()) {
            throw new IndexOutOfBoundsException();
        }
        return this.mAdapter.getItem(index);
    }

    public ArrayList<Object> getItems(int startIndex, int count) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (startIndex + count >= this.mAdapter.getItemCountProtected()) {
            throw new IndexOutOfBoundsException();
        }
        return this.mAdapter.getItems(startIndex, count);
    }

    public ArrayList<Object> getItems() {
        return this.mAdapter.getItems();
    }

    public int getItemCount() {
        return this.mAdapter.getItemCountProtected();
    }

    public int indexOf(Object item) {
        return this.mAdapter.indexOf(item);
    }

    public static interface OnLoadRequestListener {
        public void OnLoadRequest();
    }

    public static interface OnBindItemViewListener {
        public void OnBindItemView(View var1, SparseArray<View> var2, Object var3);
    }

    public static interface OnCreateItemViewListener {
        public View OnCreateItemView();

        public void OnBindItemView(View var1, SparseArray<View> var2, Object var3);
    }

    public static interface OnItemLongClickListener {
        public void OnItemLongClick(View var1, Object var2);
    }

    public static interface OnItemClickListener {
        public void OnItemClick(View var1, Object var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

