/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import net.scarlettsystems.android.widget.CardAnimator;
import net.scarlettsystems.android.widget.ScarlettRecyclerAdapter;

public class EasyRecyclerView
extends RecyclerView {
    private Context mContext;
    private ScarlettRecyclerAdapter mAdapter;
    private RecyclerView.LayoutManager mLayoutManager;
    private CardAnimator mAnimator;
    @LayoutRes
    private Integer mItemLayoutResource = null;
    private OnItemClickListener mItemClickListener = null;
    private OnCreateItemViewListener mOnCreateItemViewListener = null;
    private OnBindItemViewListener mOnBindItemViewListener = null;
    private int mAnimationDuration = this.getResources().getInteger(0x10E0001);
    private float mInterpolationFactor = 1.0f;
    private boolean mEnabled = true;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int NORTH = 2;
    public static final int SOUTH = 6;
    public static final int EAST = 0;
    public static final int WEST = 4;

    public EasyRecyclerView(Context context) {
        super(context);
        this.init(context);
    }

    public EasyRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EasyRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.configureRecyclerView();
        this.configureAdapter();
        this.configureLayoutManager();
        this.configureAnimator();
    }

    private void configureRecyclerView() {
        this.setHasFixedSize(true);
        this.setItemViewCacheSize(20);
        this.setDrawingCacheEnabled(true);
        this.setDrawingCacheQuality(0);
    }

    private void configureAdapter() {
        this.mAdapter = new ScarlettRecyclerAdapter();
        this.mAdapter.setAnimationDuration(this.mAnimationDuration);
        this.mAdapter.setInterpolationFactor(this.mInterpolationFactor);
        this.mAdapter.setItemViewListener(new ScarlettRecyclerAdapter.ItemViewListener(){

            @Override
            public View OnCreateItemView(ViewGroup parent) {
                if (EasyRecyclerView.this.mItemLayoutResource != null) {
                    return LayoutInflater.from((Context)EasyRecyclerView.this.mContext).inflate(EasyRecyclerView.this.mItemLayoutResource.intValue(), parent, false);
                }
                if (EasyRecyclerView.this.mOnCreateItemViewListener == null) {
                    throw new IllegalStateException("OnCreateItemViewListener must be set.");
                }
                return EasyRecyclerView.this.mOnCreateItemViewListener.OnCreateItemView();
            }

            @Override
            public void OnBindItemView(View v, Object item) {
                EasyRecyclerView.this.mOnBindItemViewListener.OnBindItemView(v, item);
            }
        });
        this.mAdapter.setOnItemClickListener(new ScarlettRecyclerAdapter.OnItemClickListener(){

            @Override
            public void OnItemClick(View v, Object object) {
                if (EasyRecyclerView.this.mItemClickListener == null) {
                    return;
                }
                if (!EasyRecyclerView.this.mEnabled) {
                    return;
                }
                EasyRecyclerView.this.mItemClickListener.OnItemClick(v, object);
            }
        });
        this.setAdapter(this.mAdapter);
    }

    private void configureLayoutManager() {
        this.mLayoutManager = new LinearLayoutManager(this.mContext, 1, false);
        super.setLayoutManager(this.mLayoutManager);
    }

    private void configureAnimator() {
        this.mAnimator = new CardAnimator();
        this.setItemAnimator((RecyclerView.ItemAnimator)this.mAnimator);
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    public void setOnCreateItemViewListener(OnCreateItemViewListener l) {
        this.mOnCreateItemViewListener = l;
    }

    public void setOnBindItemViewListener(OnBindItemViewListener l) {
        this.mOnBindItemViewListener = l;
    }

    public void enable() {
        this.mEnabled = true;
    }

    public void disable() {
        this.mEnabled = false;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public void setItemLayoutResource(@LayoutRes int resId) {
        this.mItemLayoutResource = resId;
    }

    public void setLayoutManager(RecyclerView.LayoutManager lm) {
        super.setLayoutManager(lm);
    }

    public void setLayoutManager(int spanCount, int orientation, boolean staggered, boolean reverseLayout) {
        if (spanCount < 1) {
            throw new IllegalArgumentException("Span count should be larger than 1.");
        }
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("Unrecognised orientation. Required: VERTICAL or HORIZONTAL.");
        }
        Object lm = spanCount == 1 ? new LinearLayoutManager(this.mContext, orientation, reverseLayout) : (!staggered ? new GridLayoutManager(this.mContext, spanCount, orientation, reverseLayout) : new StaggeredGridLayoutManager(spanCount, orientation));
        lm.setAutoMeasureEnabled(true);
        super.setLayoutManager((RecyclerView.LayoutManager)lm);
    }

    public void setCardEnterDirection(int direction) {
        this.mAnimator.setDirection(direction);
    }

    public void setCardAnimationAmount(int distance) {
        this.mAnimator.setTranslationAmount(distance);
    }

    public void setAnimationDuration(int duration) {
        this.mAdapter.setAnimationDuration(duration);
        this.mAnimator.setAnimationDuration(duration);
    }

    public void setAnimationStagger(int duration) {
        this.mAnimator.setStaggerDelay(duration);
    }

    public void setInterpolationFactor(float factor) {
        this.mAdapter.setInterpolationFactor(factor);
        this.mAnimator.setInterpolationFactor(factor);
    }

    public void setLoaderHeight(int height) {
        this.mAdapter.setLoaderHeight(height);
    }

    public void addItem(Object item) {
        this.mAdapter.addItem(item);
    }

    public void addItems(ArrayList<Object> items) {
        this.mAdapter.addItems(items);
    }

    public void addItemAt(Object item, int index) {
        this.mAdapter.addItemAt(item, index);
    }

    public void removeItem(int index) {
        this.mAdapter.removeItem(index);
    }

    public void removeAll() {
        this.mAdapter.removeAll();
    }

    public int getItemCount() {
        return this.mAdapter.getItemCount();
    }

    public static interface OnBindItemViewListener {
        public void OnBindItemView(View var1, Object var2);
    }

    public static interface OnCreateItemViewListener {
        public View OnCreateItemView();
    }

    public static interface OnItemClickListener {
        public void OnItemClick(View var1, Object var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

