/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.integration.okhttp3.OkHttpUrlLoader;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.signature.ObjectKey;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.scarlettsystems.android.widget.Helpers;
import net.scarlettsystems.android.widget.ProgressManager;
import net.scarlettsystems.android.widget.R;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class NetPicView
extends AppCompatImageView {
    private RelativeLayout mView;
    private ProgressBar mLoader;
    private ProgressBar mProgress;
    private OkHttpClient mClient;
    private ProgressManager.UIonProgressListener mProgressListener;
    private RequestListener<Drawable> mRequestListener;
    private String mUrl;
    private ArrayList<OnLoadListener> mOnLoadListeners = new ArrayList();
    private int mCounter = 0;
    private int mLoaderHeight;
    private boolean mAnimationEnabled = true;
    private ValueAnimator mLoaderAnimator;
    private int mLoaderAnimationDuration = 200;

    public NetPicView(Context context) {
        super(context);
        this.initialise();
    }

    public NetPicView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise();
        this.applyAttributes(context, attrs);
    }

    public NetPicView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise();
        this.applyAttributes(context, attrs);
    }

    private void initialise() {
        this.mView = (RelativeLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.net_scarlettsystems_android_widget_netpicview, null);
        this.mLoaderHeight = Helpers.Dp2Pix(56, this.getContext());
        this.configureLoader();
        this.configureProgress();
        this.configureClient();
        this.configureProgressListener();
        this.configureRequestListener();
    }

    private void applyAttributes(Context context, AttributeSet attrs) {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getParent() != this.mView) {
            ViewGroup parent = (ViewGroup)this.getParent();
            this.mView.setLayoutParams(this.getLayoutParams());
            this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            int index = parent.indexOfChild((View)this);
            parent.removeViewAt(index);
            this.mView.addView((View)this, 1);
            parent.addView((View)this.mView, index);
        }
    }

    private void configureLoader() {
        this.mLoader = (ProgressBar)this.mView.findViewById(R.id.net_scarlettsystems_android_widget_netpicview_loader);
    }

    private void configureProgress() {
        this.mProgress = (ProgressBar)this.mView.findViewById(R.id.net_scarlettsystems_android_widget_netpicview_progress);
    }

    private void configureClient() {
        this.mClient = new OkHttpClient.Builder().addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response response = chain.proceed(request);
                ProgressManager.DispatchingProgressListener listener = new ProgressManager.DispatchingProgressListener();
                return response.newBuilder().body((ResponseBody)new ProgressManager.OkHttpProgressResponseBody(request.url(), response.body(), listener)).build();
            }
        }).build();
    }

    private void configureProgressListener() {
        this.mProgressListener = new ProgressManager.UIonProgressListener(){

            @Override
            public void onProgress(long bytesRead, long expectedLength) {
                float loadedFraction = (float)bytesRead / (float)expectedLength;
                NetPicView.this.mProgress.setProgress(Math.round(100.0f * loadedFraction));
                NetPicView.this.runOnProgress(loadedFraction);
            }

            @Override
            public float getGranularityPercent() {
                return 1.0f;
            }
        };
    }

    private void configureRequestListener() {
        this.mRequestListener = new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                ProgressManager.forget(NetPicView.this.mUrl);
                NetPicView.this.onFinished();
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                ProgressManager.forget(NetPicView.this.mUrl);
                NetPicView.this.onFinished();
                return false;
            }
        };
    }

    private void showLoader() {
        this.mLoader.setVisibility(0);
        if (this.mAnimationEnabled) {
            if (this.mLoaderAnimator != null) {
                this.mLoaderAnimator.cancel();
            }
            this.mLoaderAnimator = ValueAnimator.ofInt((int[])new int[]{this.mLoader.getHeight(), this.mLoaderHeight});
            this.mLoaderAnimator.setDuration((long)this.mLoaderAnimationDuration);
            this.mLoaderAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mLoaderAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    Helpers.setViewHeight((View)NetPicView.this.mLoader, (Integer)animation.getAnimatedValue());
                }
            });
            this.mLoaderAnimator.start();
        } else {
            Helpers.setViewHeight((View)this.mLoader, this.mLoaderHeight);
        }
    }

    private void hideLoader() {
        if (this.mAnimationEnabled) {
            if (this.mLoaderAnimator != null) {
                this.mLoaderAnimator.cancel();
            }
            this.mLoaderAnimator = ValueAnimator.ofInt((int[])new int[]{this.mLoader.getHeight(), 0});
            this.mLoaderAnimator.setDuration((long)this.mLoaderAnimationDuration);
            this.mLoaderAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            this.mLoaderAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    Helpers.setViewHeight((View)NetPicView.this.mLoader, (Integer)animation.getAnimatedValue());
                }
            });
            this.mLoaderAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    NetPicView.this.mLoader.setVisibility(8);
                }
            });
            this.mLoaderAnimator.start();
        } else {
            Helpers.setViewHeight((View)this.mLoader, 0);
            this.mLoader.setVisibility(8);
        }
    }

    private void showProgress() {
        this.mProgress.setVisibility(0);
        if (this.mAnimationEnabled) {
            this.mProgress.animate().alpha(1.0f).start();
        }
    }

    private void hideProgress() {
        if (this.mAnimationEnabled) {
            this.mProgress.animate().alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    NetPicView.this.mProgress.setVisibility(8);
                    NetPicView.this.mProgress.setProgress(0);
                }
            }).start();
        } else {
            this.mProgress.setVisibility(8);
            this.mProgress.setProgress(0);
        }
    }

    private void runOnStart() {
        for (OnLoadListener l : this.mOnLoadListeners) {
            l.OnLoadStart();
        }
    }

    private void runOnProgress(float progress) {
        for (OnLoadListener l : this.mOnLoadListeners) {
            l.OnProgress(progress);
        }
    }

    private void runOnFinish() {
        for (OnLoadListener l : this.mOnLoadListeners) {
            l.OnLoadFinish();
        }
    }

    private RequestBuilder<Drawable> glideBuilder(String url) {
        this.mUrl = url;
        this.onConnecting();
        ProgressManager.expect(url, this.mProgressListener);
        Glide glide = Glide.get((Context)this.getContext());
        glide.getRegistry().replace(GlideUrl.class, InputStream.class, (ModelLoaderFactory)new OkHttpUrlLoader.Factory((Call.Factory)this.mClient));
        return Glide.with((Context)this.getContext()).load(url).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).listener(this.mRequestListener);
    }

    private void onConnecting() {
        if (this.mLoader != null) {
            this.showLoader();
            this.showProgress();
        }
        this.runOnStart();
    }

    private void onFinished() {
        if (this.mLoader != null) {
            this.hideLoader();
            this.hideProgress();
        }
        this.runOnFinish();
    }

    public void addOnLoadListener(OnLoadListener l) {
        this.mOnLoadListeners.add(l);
    }

    public void removeOnLoadListener(OnLoadListener l) {
        this.mOnLoadListeners.remove(l);
    }

    public ArrayList<OnLoadListener> getOnLoadListeners() {
        return this.mOnLoadListeners;
    }

    public void setLoaderAnimationDuration(int duration) {
        this.mLoaderAnimationDuration = duration;
    }

    public void setLoaderColour(@ColorInt int colour) {
        this.mLoader.getIndeterminateDrawable().setColorFilter(colour, PorterDuff.Mode.SRC_IN);
    }

    public void setProgressColour(@ColorInt int colour) {
        this.mProgress.getProgressDrawable().setColorFilter(colour, PorterDuff.Mode.SRC_IN);
    }

    public void load(String url) {
        if (url == null) {
            return;
        }
        this.glideBuilder(url).into((ImageView)this);
    }

    public void load(String url, RequestOptions options) {
        if (url == null) {
            return;
        }
        if (options == null) {
            return;
        }
        this.glideBuilder(url).apply(options).into((ImageView)this);
    }

    public void forceReload(String url) {
        if (url == null) {
            return;
        }
        this.glideBuilder(url).apply(new RequestOptions().signature((Key)new ObjectKey((Object)String.valueOf(System.currentTimeMillis() + (long)this.mCounter++)))).into((ImageView)this);
    }

    public void forceReload(String url, RequestOptions options) {
        if (url == null) {
            return;
        }
        if (options == null) {
            return;
        }
        this.glideBuilder(url).apply(options.skipMemoryCache(true).signature((Key)new ObjectKey((Object)String.valueOf(System.currentTimeMillis() + (long)this.mCounter++)))).into((ImageView)this);
    }

    public static interface OnLoadListener {
        public void OnLoadStart();

        public void OnProgress(float var1);

        public void OnLoadFinish();
    }
}

