/*
 * Decompiled with CFR 0.152.
 */
package net.qiujuer.genius.kit.handler;

import android.os.Handler;
import android.os.Looper;
import net.qiujuer.genius.kit.handler.ActionAsyncTask;
import net.qiujuer.genius.kit.handler.ActionSyncTask;
import net.qiujuer.genius.kit.handler.FuncSyncTask;
import net.qiujuer.genius.kit.handler.HandlerPoster;
import net.qiujuer.genius.kit.handler.Result;
import net.qiujuer.genius.kit.handler.runable.Action;
import net.qiujuer.genius.kit.handler.runable.Func;

public final class Run {
    private static HandlerPoster uiPoster = null;
    private static HandlerPoster backgroundPoster = null;

    public static Handler getUiHandler() {
        return Run.getUiPoster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HandlerPoster getUiPoster() {
        if (uiPoster != null) return uiPoster;
        Class<Run> clazz = Run.class;
        synchronized (Run.class) {
            if (uiPoster != null) return uiPoster;
            uiPoster = new HandlerPoster(Looper.getMainLooper(), 16, false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return uiPoster;
        }
    }

    public static Handler getBackgroundHandler() {
        return Run.getBackgroundPoster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HandlerPoster getBackgroundPoster() {
        if (backgroundPoster != null) return backgroundPoster;
        Class<Run> clazz = Run.class;
        synchronized (Run.class) {
            if (backgroundPoster != null) return backgroundPoster;
            Thread thread = new Thread("ThreadRunHandler"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Looper.prepare();
                    Class<Run> clazz = Run.class;
                    synchronized (Run.class) {
                        backgroundPoster = new HandlerPoster(Looper.myLooper(), 3000, true);
                        try {
                            Run.class.notifyAll();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Looper.loop();
                        return;
                    }
                }
            };
            thread.setDaemon(true);
            thread.setPriority(10);
            thread.start();
            try {
                Run.class.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return backgroundPoster;
        }
    }

    public static Result onBackground(Action action) {
        HandlerPoster poster = Run.getBackgroundPoster();
        if (Looper.myLooper() == poster.getLooper()) {
            action.call();
            return new ActionAsyncTask(action, true);
        }
        ActionAsyncTask task = new ActionAsyncTask(action);
        poster.async(task);
        return task;
    }

    public static Result onUiAsync(Action action) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            action.call();
            return new ActionAsyncTask(action, true);
        }
        ActionAsyncTask task = new ActionAsyncTask(action);
        Run.getUiPoster().async(task);
        return task;
    }

    public static void onUiSync(Action action) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            action.call();
            return;
        }
        ActionSyncTask poster = new ActionSyncTask(action);
        Run.getUiPoster().sync(poster);
        poster.waitRun();
    }

    public static void onUiSync(Action action, long waitMillis, boolean cancelOnTimeOut) {
        Run.onUiSync(action, waitMillis, 0, cancelOnTimeOut);
    }

    public static void onUiSync(Action action, long waitMillis, int waitNanos, boolean cancelOnTimeOut) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            action.call();
            return;
        }
        ActionSyncTask poster = new ActionSyncTask(action);
        Run.getUiPoster().sync(poster);
        poster.waitRun(waitMillis, waitNanos, cancelOnTimeOut);
    }

    public static <T> T onUiSync(Func<T> func) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            return func.call();
        }
        FuncSyncTask<T> poster = new FuncSyncTask<T>(func);
        Run.getUiPoster().sync(poster);
        return poster.waitRun();
    }

    public static <T> T onUiSync(Func<T> func, long waitMillis, boolean cancelOnTimeOut) {
        return Run.onUiSync(func, waitMillis, 0, cancelOnTimeOut);
    }

    public static <T> T onUiSync(Func<T> func, long waitMillis, int waitNanos, boolean cancelOnTimeOut) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            return func.call();
        }
        FuncSyncTask<T> poster = new FuncSyncTask<T>(func);
        Run.getUiPoster().sync(poster);
        return poster.waitRun(waitMillis, waitNanos, cancelOnTimeOut);
    }

    public static void dispose() {
        if (uiPoster != null) {
            uiPoster.dispose();
            uiPoster = null;
        }
    }
}

