/*
 * Decompiled with CFR 0.152.
 */
package net.pennix.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collection;
import net.pennix.http.client.JavaNetHttpClientHttpHttpResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;

public class JavaNetHttpClientHttpRequest
extends AbstractClientHttpRequest {
    private HttpClient client;
    private URI uri;
    private String methodValue;
    private int pipeSize;
    private PipedInputStream in;

    public JavaNetHttpClientHttpRequest(HttpClient client, URI uri, String methodValue) {
        this(client, uri, methodValue, 0);
    }

    public JavaNetHttpClientHttpRequest(HttpClient client, URI uri, String methodValue, int pipeSize) {
        this.client = client;
        this.uri = uri;
        this.methodValue = methodValue;
        this.pipeSize = pipeSize;
    }

    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        this.in = this.pipeSize > 0 ? new PipedInputStream(this.pipeSize) : new PipedInputStream();
        return new PipedOutputStream(this.in);
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        HttpRequest.BodyPublisher body = this.in == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofInputStream(() -> this.in);
        HttpRequest.Builder builder = HttpRequest.newBuilder(this.uri).method(this.getMethodValue(), body);
        headers.forEach((headerName, headerValues) -> {
            if ("Cookie".equalsIgnoreCase((String)headerName)) {
                String headerValue = StringUtils.collectionToDelimitedString((Collection)headerValues, (String)"; ");
                builder.header((String)headerName, headerValue);
            } else {
                for (String headerValue : headerValues) {
                    String actualHeaderValue = headerValue != null ? headerValue : "";
                    builder.header((String)headerName, actualHeaderValue);
                }
            }
        });
        try {
            HttpResponse<InputStream> response = this.client.send(builder.build(), HttpResponse.BodyHandlers.ofInputStream());
            return new JavaNetHttpClientHttpHttpResponse(response);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMethodValue() {
        return this.methodValue;
    }

    public URI getURI() {
        return this.uri;
    }
}

