/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import net.openhft.lang.model.constraints.NotNull;

class TcpConnection {
    private SocketChannel socketChannel;

    public TcpConnection() {
        this(null);
    }

    public TcpConnection(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    protected void setSocketChannel(SocketChannel socketChannel) throws IOException {
        if (this.socketChannel != null) {
            this.close();
        }
        this.socketChannel = socketChannel;
    }

    public boolean isOpen() {
        if (this.socketChannel != null) {
            return this.socketChannel.isOpen();
        }
        return false;
    }

    public void close() throws IOException {
        if (this.socketChannel != null) {
            if (this.socketChannel.isOpen()) {
                this.socketChannel.close();
            }
            this.socketChannel = null;
        }
    }

    public String debugString() {
        if (this.socketChannel != null) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                sb.append(this.socketChannel.getLocalAddress());
                sb.append(" -> ");
                sb.append(this.socketChannel.getRemoteAddress());
                sb.append("]");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "[] -> []";
    }

    public int write(ByteBuffer buffer) throws IOException {
        return this.socketChannel.write(buffer);
    }

    public void writeAllOrEOF(ByteBuffer bb) throws IOException {
        this.writeAll(bb);
        if (bb.remaining() > 0) {
            throw new EOFException();
        }
    }

    public void writeAll(ByteBuffer bb) throws IOException {
        int bw = 0;
        while (bb.remaining() > 0 && (bw = this.socketChannel.write(bb)) >= 0) {
        }
    }

    public int read(ByteBuffer buffer) throws IOException {
        int nb = this.socketChannel.read(buffer);
        if (nb < 0) {
            throw new EOFException();
        }
        return 0;
    }

    public boolean read(ByteBuffer buffer, int size) throws IOException {
        return this.read(buffer, size, size);
    }

    public boolean read(ByteBuffer buffer, int threshod, int size) throws IOException {
        int rem = buffer.remaining();
        if (rem < threshod) {
            if (buffer.remaining() == 0) {
                buffer.clear();
            } else {
                buffer.compact();
            }
            int targetPosition = buffer.position() + size;
            while (buffer.position() < targetPosition) {
                int rb = this.socketChannel.read(buffer);
                if (rb >= 0) continue;
                this.socketChannel.close();
                return false;
            }
            buffer.flip();
        }
        return true;
    }

    public boolean read(ByteBuffer buffer, int threshod, int size, int readCount) throws IOException {
        int rem = buffer.remaining();
        if (rem < threshod) {
            if (buffer.remaining() == 0) {
                buffer.clear();
            } else {
                buffer.compact();
            }
            int spins = 0;
            int bytes = 0;
            int targetPosition = buffer.position() + size;
            while (buffer.position() < targetPosition) {
                int rb = this.socketChannel.read(buffer);
                if (rb < 0) {
                    throw new EOFException();
                }
                if (bytes == 0 && rb == 0 && readCount > -1) {
                    if (spins++ < readCount) continue;
                    buffer.flip();
                    return false;
                }
                spins = 0;
                bytes += rb;
            }
            buffer.flip();
        }
        return true;
    }

    public boolean readAtLeast(ByteBuffer buffer, int size, int readCount) throws IOException {
        if (buffer.remaining() == 0) {
            buffer.clear();
        } else {
            buffer.compact();
        }
        int spins = 0;
        int bytes = 0;
        int targetPosition = buffer.position() + size;
        while (buffer.position() < targetPosition) {
            int rb = this.socketChannel.read(buffer);
            if (rb < 0) {
                throw new EOFException();
            }
            if (bytes == 0 && rb == 0 && readCount > -1) {
                if (spins++ < readCount) continue;
                return false;
            }
            spins = 0;
            bytes += rb;
        }
        buffer.flip();
        return true;
    }

    public boolean readAllOrNone(ByteBuffer buffer, int readCount) throws IOException {
        int spins = 0;
        int bytes = 0;
        while (buffer.remaining() > 0) {
            int rb = this.socketChannel.read(buffer);
            if (rb < 0) {
                throw new EOFException();
            }
            if (bytes == 0 && rb == 0 && readCount > -1) {
                if (spins++ < readCount) continue;
                return false;
            }
            spins = 0;
            bytes += rb;
        }
        return true;
    }

    public void readFullyOrEOF(@NotNull ByteBuffer bb) throws IOException {
        this.readAvailable(bb);
        if (bb.remaining() > 0) {
            throw new EOFException();
        }
    }

    public void readAvailable(@NotNull ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0 && this.socketChannel.read(bb) >= 0) {
        }
    }

    public boolean readUpTo(ByteBuffer buffer, int size, int readCount) throws IOException {
        buffer.clear();
        buffer.limit(size);
        if (readCount == -1) {
            this.readFullyOrEOF(buffer);
        } else if (!this.readAllOrNone(buffer, readCount)) {
            buffer.clear();
            return false;
        }
        buffer.flip();
        return true;
    }

    public void writeSizeAndIndex(ByteBuffer buffer, int action, long index) throws IOException {
        buffer.clear();
        buffer.putInt(action);
        buffer.putLong(index);
        buffer.flip();
        this.writeAllOrEOF(buffer);
    }

    public void writeAction(ByteBuffer buffer, long action, long index) throws IOException {
        buffer.clear();
        buffer.putLong(action);
        buffer.putLong(index);
        buffer.flip();
        this.writeAllOrEOF(buffer);
    }
}

