/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.IOException;
import java.net.NetworkInterface;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.tcp.SinkTcp;

public class SinkTcpInitiator
extends SinkTcp {
    public SinkTcpInitiator(ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder) {
        super("sink-initiator", builder);
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        SocketChannel channel = null;
        while (this.running.get() && channel == null) {
            try {
                channel = SocketChannel.open();
                channel.configureBlocking(true);
                if (this.builder.bindAddress() != null) {
                    channel.bind(this.builder.bindAddress());
                }
                channel.connect(this.builder.connectAddress());
                this.logger.info("Connected to {} from {}", (Object)channel.getRemoteAddress(), (Object)channel.getLocalAddress());
            }
            catch (IOException e) {
                this.logger.info("Failed to connect to {}, retrying", (Object)this.builder.connectAddress());
                try {
                    Thread.sleep(this.builder.reconnectTimeoutMillis());
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                channel = null;
            }
        }
        return channel;
    }

    @Override
    public boolean isLocalhost() {
        if (this.builder.connectAddress().getAddress().isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(this.builder.connectAddress().getAddress()) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

