/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import org.jetbrains.annotations.NotNull;

public enum TcpUtil {

    static final int HEADER_SIZE = 12;
    static final int INITIAL_BUFFER_SIZE = 65536;

    public static ByteBuffer createBuffer(int minSize, ByteOrder byteOrder) {
        int newSize = (minSize + 65536 - 1) / 65536 * 65536;
        return ByteBuffer.allocateDirect(newSize).order(byteOrder);
    }

    public static void writeAllOrEOF(@NotNull SocketChannel sc, @NotNull ByteBuffer bb) throws IOException {
        TcpUtil.writeAll(sc, bb);
        if (bb.remaining() > 0) {
            throw new EOFException();
        }
    }

    public static void writeAll(@NotNull SocketChannel sc, @NotNull ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0 && sc.write(bb) >= 0) {
        }
    }

    public static void readFullyOrEOF(@NotNull SocketChannel socket, @NotNull ByteBuffer bb) throws IOException {
        TcpUtil.readAvailable(socket, bb);
        if (bb.remaining() > 0) {
            throw new EOFException();
        }
    }

    public static void readAvailable(@NotNull SocketChannel socket, @NotNull ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0 && socket.read(bb) >= 0) {
        }
    }
}

