/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleConfig;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.tcp.TcpUtil;
import net.openhft.chronicle.tools.WrappedExcerpt;
import net.openhft.lang.thread.NamedThreadFactory;
import org.jetbrains.annotations.NotNull;

public class InProcessChronicleSource
implements Chronicle {
    static final int IN_SYNC_LEN = -128;
    static final int PADDED_LEN = -127;
    static final long HEARTBEAT_INTERVAL_MS = 2500L;
    private static final int MAX_MESSAGE = 128;
    @NotNull
    private final Chronicle chronicle;
    private final ServerSocketChannel server;
    @NotNull
    private final String name;
    @NotNull
    private final ExecutorService service;
    private final Logger logger;
    private final Object notifier = new Object();
    private long busyWaitTimeNS = 100000L;
    private volatile boolean closed = false;
    private long lastUnpausedNS = 0L;

    public InProcessChronicleSource(@NotNull Chronicle chronicle, int port) throws IOException {
        this.chronicle = chronicle;
        this.server = ServerSocketChannel.open();
        this.server.socket().setReuseAddress(true);
        this.server.socket().bind(new InetSocketAddress(port));
        this.name = chronicle.name() + "@" + port;
        this.logger = Logger.getLogger(this.getClass().getName() + "." + this.name);
        this.service = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(this.name, Boolean.valueOf(true)));
        this.service.execute(new Acceptor());
    }

    private void pauseReset() {
        this.lastUnpausedNS = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause() {
        if (this.lastUnpausedNS + this.busyWaitTimeNS > System.nanoTime()) {
            return;
        }
        try {
            Object object = this.notifier;
            synchronized (object) {
                this.notifier.wait(1250L);
            }
        }
        catch (InterruptedException ie) {
            this.logger.warning("Interrupt ignored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeSessionHandlers() {
        Object object = this.notifier;
        synchronized (object) {
            this.notifier.notifyAll();
        }
    }

    @Override
    public String name() {
        return this.chronicle.name();
    }

    @Override
    @NotNull
    public Excerpt createExcerpt() throws IOException {
        return new SourceExcerpt(this.chronicle.createExcerpt());
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() throws IOException {
        return new SourceExcerpt(this.chronicle.createTailer());
    }

    @Override
    @NotNull
    public ExcerptAppender createAppender() throws IOException {
        return new SourceExcerpt(this.chronicle.createAppender());
    }

    @Override
    public long lastWrittenIndex() {
        return this.chronicle.lastWrittenIndex();
    }

    @Override
    public long size() {
        return this.chronicle.size();
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.chronicle.close();
            this.server.close();
        }
        catch (IOException e) {
            this.logger.warning("Error closing server port " + e);
        }
    }

    public ChronicleConfig config() {
        return ((IndexedChronicle)this.chronicle).config();
    }

    class SourceExcerpt
    extends WrappedExcerpt {
        public SourceExcerpt(ExcerptCommon excerptCommon) {
            super(excerptCommon);
        }

        @Override
        public void finish() {
            super.finish();
            InProcessChronicleSource.this.wakeSessionHandlers();
        }
    }

    class Handler
    implements Runnable {
        @NotNull
        private final SocketChannel socket;

        public Handler(SocketChannel socket) throws SocketException {
            this.socket = socket;
            socket.socket().setSendBufferSize(262144);
            socket.socket().setTcpNoDelay(true);
        }

        @Override
        public void run() {
            block17: {
                try {
                    long index = this.readIndex(this.socket);
                    ExcerptTailer excerpt = InProcessChronicleSource.this.chronicle.createTailer();
                    ByteBuffer bb = TcpUtil.createBuffer(1, ByteOrder.nativeOrder());
                    long sendInSync = 0L;
                    boolean first = true;
                    while (!InProcessChronicleSource.this.closed) {
                        long remaining;
                        while (!excerpt.index(index)) {
                            long now = System.currentTimeMillis();
                            if (excerpt.wasPadding()) {
                                if (index >= 0L) {
                                    bb.clear();
                                    if (first) {
                                        bb.putLong(excerpt.index());
                                        first = false;
                                    }
                                    bb.putInt(-127);
                                    bb.flip();
                                    TcpUtil.writeAll(this.socket, bb);
                                    sendInSync = now + 2500L;
                                }
                                ++index;
                                continue;
                            }
                            if (sendInSync <= now && !first) {
                                bb.clear();
                                bb.putInt(-128);
                                bb.flip();
                                TcpUtil.writeAll(this.socket, bb);
                                sendInSync = now + 2500L;
                            }
                            InProcessChronicleSource.this.pause();
                            if (!InProcessChronicleSource.this.closed) continue;
                            break block17;
                        }
                        InProcessChronicleSource.this.pauseReset();
                        long size = excerpt.capacity();
                        bb.clear();
                        if (first) {
                            bb.putLong(excerpt.index());
                            first = false;
                            remaining = size + 12L;
                        } else {
                            remaining = size + 4L;
                        }
                        bb.putInt((int)size);
                        if (size > (long)(bb.capacity() / 2)) {
                            while (remaining > 0L) {
                                int size2 = (int)Math.min(remaining, (long)bb.capacity());
                                bb.limit(size2);
                                excerpt.read(bb);
                                bb.flip();
                                remaining -= (long)bb.remaining();
                                TcpUtil.writeAll(this.socket, bb);
                            }
                        } else {
                            bb.limit((int)remaining);
                            excerpt.read(bb);
                            int count = 1;
                            while (excerpt.index(index + 1L) && count++ < 128) {
                                if (excerpt.wasPadding()) {
                                    ++index;
                                    continue;
                                }
                                if (excerpt.remaining() + 4L >= (long)(bb.capacity() - bb.position())) break;
                                int size2 = (int)excerpt.capacity();
                                bb.limit(bb.position() + size2 + 4);
                                bb.putInt(size2);
                                excerpt.read(bb);
                                ++index;
                            }
                            bb.flip();
                            TcpUtil.writeAll(this.socket, bb);
                        }
                        if (bb.remaining() > 0) {
                            throw new EOFException("Failed to send index=" + index);
                        }
                        ++index;
                        sendInSync = 0L;
                    }
                }
                catch (Exception e) {
                    if (InProcessChronicleSource.this.closed) break block17;
                    String msg = e.getMessage();
                    if (msg != null && (msg.contains("reset by peer") || msg.contains("Broken pipe") || msg.contains("was aborted by"))) {
                        InProcessChronicleSource.this.logger.log(Level.INFO, "Connect " + this.socket + " closed from the other end " + e);
                    }
                    InProcessChronicleSource.this.logger.log(Level.INFO, "Connect " + this.socket + " died", e);
                }
            }
        }

        private long readIndex(@NotNull SocketChannel socket) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(8);
            TcpUtil.readFullyOrEOF(socket, bb);
            return bb.getLong(0);
        }
    }

    private class Acceptor
    implements Runnable {
        private Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName(InProcessChronicleSource.this.name + "-acceptor");
            try {
                while (!InProcessChronicleSource.this.closed) {
                    SocketChannel socket = InProcessChronicleSource.this.server.accept();
                    InProcessChronicleSource.this.service.execute(new Handler(socket));
                }
            }
            catch (IOException e) {
                if (!InProcessChronicleSource.this.closed) {
                    InProcessChronicleSource.this.logger.log(Level.SEVERE, "Acceptor dying", e);
                }
            }
            finally {
                InProcessChronicleSource.this.service.shutdown();
            }
        }
    }
}

