/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.IOException;
import net.openhft.chronicle.AbstractNativeExcerpt;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.IndexedChronicle;
import org.jetbrains.annotations.NotNull;

public class NativeExcerpt
extends AbstractNativeExcerpt
implements Excerpt {
    private boolean padding = true;

    public NativeExcerpt(@NotNull IndexedChronicle chronicle) throws IOException {
        super(chronicle);
    }

    public void startExcerpt(long capacity) {
        if (this.positionAddr + capacity > this.dataStartAddr + (long)this.dataBlockSize) {
            this.checkNewIndexLine();
            this.writePaddedEntry();
            try {
                this.loadNextDataBuffer();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.checkNewIndexLine();
        this.startAddr = this.positionAddr;
        this.limitAddr = this.positionAddr + capacity;
        this.finished = false;
    }

    private void writePaddedEntry() {
        int size = (int)((long)this.dataBlockSize + this.dataStartOffset - this.indexBaseForLine);
        assert (size >= 0);
        if (size == 0) {
            return;
        }
        this.checkNewIndexLine();
        this.writePaddingIndexEntry(size);
        this.indexPositionAddr += 4L;
    }

    private void writePaddingIndexEntry(int size) {
        UNSAFE.putInt(this.indexPositionAddr, -size);
    }

    @Override
    public boolean index(long l) {
        try {
            return this.indexForRead(l);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void finish() {
        super.finish();
        if (this.chronicle.config.synchronousMode()) {
            this.dataBuffer.force();
            this.indexBuffer.force();
        }
    }

    void checkNewIndexLine() {
        switch ((int)(this.indexPositionAddr & (long)this.cacheLineMask)) {
            case 0: {
                this.newIndexLine();
                break;
            }
            case 4: {
                throw new AssertionError();
            }
        }
    }

    void newIndexLine() {
        if (this.indexPositionAddr >= this.indexStartAddr + (long)this.indexBlockSize) {
            try {
                this.loadNextIndexBuffer();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.indexBaseForLine = this.positionAddr - this.dataStartAddr + this.dataStartOffset;
        assert (this.indexBaseForLine >= 0L && this.indexBaseForLine < 0x1000000000000L) : "dataPositionAtStartOfLine out of bounds, was " + this.indexBaseForLine;
        this.appendToIndex();
        this.indexPositionAddr += 8L;
    }

    private void appendToIndex() {
        UNSAFE.putLong(this.indexPositionAddr, this.indexBaseForLine);
    }

    @Override
    @NotNull
    public Excerpt toStart() {
        this.index = -1L;
        return this;
    }

    @Override
    @NotNull
    public Excerpt toEnd() {
        this.index = this.chronicle().size();
        try {
            this.indexForRead(this.index);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public boolean nextIndex() {
        try {
            long index2 = this.index;
            if (this.indexForRead(this.index() + 1L)) {
                return true;
            }
            this.index = index2;
            if (this.wasPadding()) {
                ++this.index;
                return this.indexForRead(this.index() + 1L);
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

