/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleConfig;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.NativeExcerpt;
import net.openhft.chronicle.NativeExcerptAppender;
import net.openhft.chronicle.NativeExcerptTailer;
import net.openhft.lang.io.MappedFile;
import org.jetbrains.annotations.NotNull;

public class IndexedChronicle
implements Chronicle {
    @NotNull
    final MappedFile indexFileCache;
    @NotNull
    final MappedFile dataFileCache;
    @NotNull
    final ChronicleConfig config;
    private final String basePath;
    private long lastWrittenIndex = -1L;

    public IndexedChronicle(@NotNull String basePath) throws FileNotFoundException {
        this(basePath, ChronicleConfig.DEFAULT);
    }

    public IndexedChronicle(@NotNull String basePath, @NotNull ChronicleConfig config) throws FileNotFoundException {
        this.basePath = basePath;
        this.config = config.clone();
        File parentFile = new File(basePath).getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        this.indexFileCache = new MappedFile(basePath + ".index", (long)config.indexBlockSize());
        this.dataFileCache = new MappedFile(basePath + ".data", (long)config.dataBlockSize());
        this.findTheLastIndex();
    }

    public ChronicleConfig config() {
        return this.config;
    }

    public long findTheLastIndex() {
        this.lastWrittenIndex = this.findTheLastIndex0();
        return this.lastWrittenIndex;
    }

    private long findTheLastIndex0() {
        long size = this.indexFileCache.size();
        if (size <= 0L) {
            return -1L;
        }
        int indexBlockSize = this.config.indexBlockSize();
        for (long block = size / (long)indexBlockSize - 1L; block >= 0L; --block) {
            MappedByteBuffer mbb = null;
            try {
                mbb = this.indexFileCache.acquire(block).buffer();
            }
            catch (IOException e) {
                continue;
            }
            mbb.order(ByteOrder.nativeOrder());
            if (block > 0L && mbb.getLong(0) == 0L) continue;
            int cacheLineSize = this.config.cacheLineSize();
            for (int pos = 0; pos < indexBlockSize; pos += cacheLineSize) {
                if (pos + cacheLineSize < indexBlockSize && mbb.getLong(pos + cacheLineSize) != 0L) continue;
                int pos2 = 8;
                for (pos2 = 8; pos2 < cacheLineSize && mbb.getInt(pos + pos2) != 0; pos2 += 4) {
                }
                return (block * (long)indexBlockSize + (long)pos) / (long)cacheLineSize * (long)(cacheLineSize / 4 - 2) + (long)(pos2 / 4) - 3L;
            }
            return (block + 1L) * (long)indexBlockSize / (long)cacheLineSize * (long)(cacheLineSize / 4 - 2);
        }
        return -1L;
    }

    @Override
    public long size() {
        return this.lastWrittenIndex + 1L;
    }

    @Override
    public String name() {
        return this.basePath;
    }

    @Override
    public void close() throws IOException {
        this.indexFileCache.close();
        this.dataFileCache.close();
    }

    @Override
    @NotNull
    public Excerpt createExcerpt() throws IOException {
        return new NativeExcerpt(this);
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() throws IOException {
        return new NativeExcerptTailer(this);
    }

    @Override
    @NotNull
    public ExcerptAppender createAppender() throws IOException {
        return new NativeExcerptAppender(this);
    }

    @Override
    public long lastWrittenIndex() {
        return this.lastWrittenIndex;
    }

    void incrSize() {
        ++this.lastWrittenIndex;
    }
}

