/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.wsdl11wrapper.impl;

import com.sun.jbi.wsdl11wrapper.HelperFactory;
import com.sun.jbi.wsdl11wrapper.WrapperBuilder;
import com.sun.jbi.wsdl11wrapper.WrapperProcessingException;
import com.sun.jbi.wsdl11wrapper.impl.NodeListImpl;
import com.sun.jbi.wsdl11wrapper.impl.WSDLInfo;
import com.sun.jbi.wsdl11wrapper.util.WrapperUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WrapperBuilderImpl
implements WrapperBuilder {
    DocumentBuilder mBuilder;
    Document normalDoc;
    Element jbiMessageWrapper;
    Message messageDefinition;
    WSDLInfo info;
    boolean isResultPrepared;
    Map mPartNameToPartNodes;

    @Override
    public void initialize(Document docToPopulate, Message wsdlMessageDefinition, String operationBindingMessageName) throws WrapperProcessingException {
        this.isResultPrepared = false;
        this.mPartNameToPartNodes = null;
        this.normalDoc = docToPopulate;
        this.messageDefinition = wsdlMessageDefinition;
        if (docToPopulate == null) {
            try {
                this.normalDoc = this.newDocument();
            }
            catch (ParserConfigurationException ex) {
                throw new WrapperProcessingException("Failed to create an empty target document for building the wrapped normalized message: " + ex.getMessage(), ex);
            }
        }
        this.info = WSDLInfo.getInstance(wsdlMessageDefinition);
        this.jbiMessageWrapper = WrapperUtil.createJBIMessageWrapper(this.normalDoc, this.info.getMessageType(), operationBindingMessageName);
        this.normalDoc.appendChild(this.jbiMessageWrapper);
    }

    @Override
    public void addPart(String partName, NodeList partNodes) throws WrapperProcessingException {
        List partsOrder = this.info.getPartsOrder();
        int partPos = partsOrder.indexOf(partName);
        if (partPos > -1) {
            if (this.mPartNameToPartNodes == null) {
                this.mPartNameToPartNodes = new HashMap();
            }
        } else {
            throw new WrapperProcessingException("Unknown part " + partName + " is not defined in the WSDL message definition for " + this.info.getMessageType() + ". Cannot add part to normalized message.");
        }
        this.mPartNameToPartNodes.put(partName, partNodes);
    }

    @Override
    public void addPart(String partName, Element partNode) throws WrapperProcessingException {
        this.addPart(partName, new NodeListImpl(partNode));
    }

    @Override
    public void addParts(Map partNameToPartNodes) {
        this.mPartNameToPartNodes = partNameToPartNodes;
    }

    @Override
    public Document getResult() throws WrapperProcessingException {
        if (!this.isResultPrepared) {
            for (Part aPart : this.info.getOrderedMessageParts()) {
                String partName = aPart.getName();
                NodeList nodes = null;
                if (this.mPartNameToPartNodes != null) {
                    Object payload = this.mPartNameToPartNodes.get(partName);
                    if (payload instanceof NodeList) {
                        nodes = (NodeList)payload;
                    } else {
                        throw new WrapperProcessingException("Part payload added is not a NodeList: " + (payload == null ? "payload is null" : payload.getClass().getName()));
                    }
                }
                Element wrapperElem = WrapperUtil.importJBIWrappedPart(this.normalDoc, nodes);
                this.jbiMessageWrapper.appendChild(wrapperElem);
            }
            this.isResultPrepared = true;
        }
        return this.normalDoc;
    }

    @Override
    public Message getStatusMessage() throws WrapperProcessingException {
        Message msg = null;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            Definition def = factory.newDefinition();
            msg = def.createMessage();
            msg.setQName(new QName("Status"));
            Part part = def.createPart();
            part.setName("Result");
            msg.addPart(part);
        }
        catch (WSDLException ex) {
            throw new WrapperProcessingException(ex);
        }
        return msg;
    }

    @Override
    public Document getStatusDocument(String statusMessage) throws WrapperProcessingException {
        Document res = null;
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            WrapperBuilder builder = HelperFactory.createBuilder();
            builder.initialize(doc, this.getStatusMessage(), null);
            Element statusElem = doc.createElement("Status");
            statusElem.appendChild(doc.createTextNode(statusMessage));
            builder.addPart("Result", statusElem);
            res = builder.getResult();
        }
        catch (ParserConfigurationException ex) {
            throw new WrapperProcessingException(ex);
        }
        return res;
    }

    private Document newDocument() throws ParserConfigurationException {
        if (this.mBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.mBuilder = factory.newDocumentBuilder();
        }
        return this.mBuilder.newDocument();
    }
}

