/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.wsdl11wrapper;

import com.sun.jbi.wsdl11wrapper.HelperFactory;
import com.sun.jbi.wsdl11wrapper.WrapperBuilder;
import com.sun.jbi.wsdl11wrapper.WrapperParser;
import com.sun.jbi.wsdl11wrapper.Wsdl11WrapperHelperException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Wsdl11WrapperHelper {
    private Definition mDefinition;
    private Document mDoc;
    public static final String WRAPPER_DEFAULT_NAMESPACE = "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper";
    public static final String WRAPPER_MESSAGE = "jbi:documentroot";
    public static final String WSDL11 = "http://schemas.xmlsoap.org/wsdl/";

    public Wsdl11WrapperHelper() {
    }

    public Wsdl11WrapperHelper(String wsdlfile, String inputfile) {
        try {
            WSDLFactory mFactory = WSDLFactory.newInstance();
            WSDLReader mReader = mFactory.newWSDLReader();
            this.mDefinition = mReader.readWSDL(null, wsdlfile);
            DocumentBuilderFactory docfac = DocumentBuilderFactory.newInstance();
            docfac.setNamespaceAware(true);
            this.mDoc = docfac.newDocumentBuilder().parse(inputfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Wsdl11WrapperHelper(Object wsdldef) {
        this.mDefinition = (Definition)wsdldef;
    }

    private Document getDocFromSource(Source src) throws Wsdl11WrapperHelperException {
        Document normaldoc = null;
        try {
            DOMResult result = new DOMResult();
            TransformerFactory fac = TransformerFactory.newInstance();
            Transformer trans = fac.newTransformer();
            trans.transform(src, result);
            Node node = result.getNode();
            if (node.getNodeType() == 9) {
                normaldoc = (Document)node;
            } else if (node.getNodeType() == 1) {
                normaldoc = ((Element)node).getOwnerDocument();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Wsdl11WrapperHelperException("Cannot retrieve the DOM from Source", e);
        }
        return normaldoc;
    }

    public void parse(String wsdlfile) throws Wsdl11WrapperHelperException {
        try {
            WSDLFactory mFactory = WSDLFactory.newInstance();
            WSDLReader mReader = mFactory.newWSDLReader();
            this.mDefinition = mReader.readWSDL(null, wsdlfile);
        }
        catch (Exception e) {
            throw new Wsdl11WrapperHelperException("Cannot parse Wsdl 1.1 file", e);
        }
    }

    public boolean isWsdl11() throws Wsdl11WrapperHelperException {
        try {
            String xmlns = this.mDefinition.getNamespace("");
            if (xmlns.trim().equals(WSDL11)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new Wsdl11WrapperHelperException("Cannot get version", e);
        }
        return false;
    }

    public Document wrapMessage(Source src, QName service, String endpoint, String operation, boolean input) throws Wsdl11WrapperHelperException {
        Document tempdoc = this.getDocFromSource(src);
        return this.wrapMessage(tempdoc, service, endpoint, operation, input);
    }

    public Document wrapMessage(Document doc, QName service, String enpoint, String operation, boolean input) throws Wsdl11WrapperHelperException {
        Document d = null;
        if (doc == null) {
            doc = this.mDoc;
        }
        try {
            WrapperBuilder builder = HelperFactory.createBuilder();
            Message msg = this.getMessage(service, enpoint, operation, input);
            builder.initialize(null, msg, operation);
            Map parts = msg.getParts();
            for (Part part : parts.values()) {
                Element partelement = this.findpart(doc, part);
                if (partelement == null) continue;
                builder.addPart(part.getName(), partelement);
            }
            d = builder.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Wsdl11WrapperHelperException("Cannot create Wsdl 1.1 Wrapper", e);
        }
        return d;
    }

    public Document unwrapFault(Source wrappeddoc, QName service, String endpoint, String operation) throws Wsdl11WrapperHelperException {
        return this.unwrapFault(this.getDocFromSource(wrappeddoc), service, endpoint, operation);
    }

    public Document wrapFault(Source doc, QName service, String endpoint, String operation, String fault) throws Wsdl11WrapperHelperException {
        return this.wrapFault(this.getDocFromSource(doc), service, endpoint, operation, fault);
    }

    public Document wrapFault(Document doc, QName service, String endpoint, String operation, String fault) throws Wsdl11WrapperHelperException {
        Document d = null;
        try {
            WrapperBuilder builder = HelperFactory.createBuilder();
            Message msg = this.getFaultMessage(service, endpoint, operation, fault);
            builder.initialize(null, msg, operation);
            Map parts = msg.getParts();
            for (Part part : parts.values()) {
                Element partelement = this.findpart(doc, part);
                if (partelement == null) continue;
                builder.addPart(part.getName(), partelement);
            }
            d = builder.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Wsdl11WrapperHelperException("Cannot create Wsdl 1.1 wrapper for Fault", e);
        }
        return d;
    }

    public Document unwrapMessage(Source wrappeddoc, QName service, String endpoint, String operation, boolean input) throws Wsdl11WrapperHelperException {
        return this.unwrapMessage(this.getDocFromSource(wrappeddoc), service, endpoint, operation, input);
    }

    public Document unwrapFault(Document wrappeddoc, QName service, String endpoint, String operation) throws Wsdl11WrapperHelperException {
        Document d = null;
        try {
            d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            WrapperParser parser = HelperFactory.createParser();
            parser.parse(wrappeddoc, this.mDefinition);
            String msgname = parser.getMessageName();
            QName msgtype = parser.getMessageType();
            Message msg = this.mDefinition.getMessage(msgtype);
            Map parts = msg.getParts();
            Iterator iter = parts.values().iterator();
            Element docroot = null;
            if (parts.size() > 1) {
                docroot = d.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_MESSAGE);
            }
            while (iter.hasNext()) {
                Part part = (Part)iter.next();
                if (!parser.hasPart(part.getName())) continue;
                NodeList partnodes = parser.getPartNodes(part.getName());
                for (int i = 0; i < partnodes.getLength(); ++i) {
                    Node temp = partnodes.item(i);
                    if (temp == null || temp.getLocalName() == null) continue;
                    Node node = d.importNode(temp, true);
                    if (docroot != null) {
                        docroot.appendChild(node);
                        continue;
                    }
                    d.appendChild(node);
                }
            }
            d.normalize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Wsdl11WrapperHelperException("Cannot un-wrap fault message", e);
        }
        return d;
    }

    public Document unwrapMessage(Document wrappeddoc, QName service, String endpoint, String operation, boolean input) throws Wsdl11WrapperHelperException {
        Document d = null;
        if (wrappeddoc == null) {
            wrappeddoc = this.mDoc;
        }
        try {
            d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            WrapperParser parser = HelperFactory.createParser();
            Message msg = this.getMessage(service, endpoint, operation, input);
            parser.parse(wrappeddoc, msg);
            Map parts = msg.getParts();
            Iterator iter = parts.values().iterator();
            Element docroot = null;
            if (parts.size() > 1) {
                docroot = d.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_MESSAGE);
            }
            while (iter.hasNext()) {
                Part part = (Part)iter.next();
                if (!parser.hasPart(part.getName())) continue;
                NodeList partnodes = parser.getPartNodes(part.getName());
                for (int i = 0; i < partnodes.getLength(); ++i) {
                    Node temp = partnodes.item(i);
                    if (temp == null || temp.getLocalName() == null) continue;
                    Node node = d.importNode(temp, true);
                    if (docroot != null) {
                        docroot.appendChild(node);
                        continue;
                    }
                    d.appendChild(node);
                }
            }
            d.normalize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Wsdl11WrapperHelperException("Cannot un-wrap output message", e);
        }
        return d;
    }

    private Element findpart(Document doc, Part part) {
        Element ele = null;
        try {
            QName partelement = part.getElementName();
            QName parttype = part.getTypeName();
            NodeList nl = null;
            if (partelement != null) {
                nl = doc.getElementsByTagNameNS("*", partelement.getLocalPart());
            }
            if (parttype != null) {
                nl = doc.getElementsByTagNameNS("*", part.getName());
            }
            if (nl != null && nl.getLength() > 0) {
                ele = (Element)nl.item(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ele;
    }

    public Message getMessage(QName service, String portstring, String oper, boolean input) {
        Object msg = null;
        try {
            Service ser = this.mDefinition.getService(service);
            Port port = ser.getPort(portstring);
            List l = port.getBinding().getPortType().getOperations();
            for (Operation operation : l) {
                if (!operation.getName().equals(oper)) continue;
                if (input) {
                    return operation.getInput().getMessage();
                }
                return operation.getOutput().getMessage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Message getFaultMessage(QName service, String portstring, String oper, String fault) {
        Object msg = null;
        try {
            Service ser = this.mDefinition.getService(service);
            Port port = ser.getPort(portstring);
            List l = port.getBinding().getPortType().getOperations();
            for (Operation operation : l) {
                if (!operation.getName().equals(oper)) continue;
                if (fault != null) {
                    return operation.getFault(fault).getMessage();
                }
                Map faults = operation.getFaults();
                Iterator faultiter = faults.values().iterator();
                Fault defaultflt = (Fault)faultiter.next();
                return defaultflt.getMessage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

