/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.runtime.verifier.util;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JarFactory;
import com.sun.jbi.ui.common.ToolsLogManager;
import com.sun.jbi.ui.runtime.verifier.VerifierException;
import com.sun.jbi.ui.runtime.verifier.util.VerifierUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.management.openmbean.CompositeType;

public class TemplateGenerator {
    private EnvironmentContext mEnvCtx;
    private VerifierUtils mVerifierUtil;
    private static String TMP = "tmp";
    private static String VERIFIER = "verifier";
    private static String APPVAR_TEMPLATE_SUFFIX = "-app-var.properties";
    private static String APPCONFIG_TEMPLATE_SUFFIX = ".properties";
    private static String HYPHEN = "-";
    private Map<String, File> mAppVarFile = new HashMap<String, File>();
    private Map<String, File[]> mAppConfigFile = new HashMap<String, File[]>();
    private static String ANT_FILE_NAME = "configure.xml";
    private static String PROPERTIES_FILE_NAME = "connection.properties";
    private static String TEMPLATE_ZIP_SUFFIX = "-templates.zip";
    private static String TEMPLATE_DIR_SUFFIX = "-templates";
    private static final String CONFIGURATION_NAME = "configurationName";
    private I18NBundle mResourceBundle;
    private String ANT_SCRIPT_BEGIN = "<project name=\"configure\" default=\"configure\" basedir=\".\">\n\t<property file=\"connection.properties\"/>\n\t<taskdef resource=\"com/sun/jbi/ui/ant/antlib.xml\" />\n";
    private String ANT_SCRIPT_CONFIGURE_TARGET_BEGIN = "\t<target name=\"configure\">\n";
    private String ANT_SCRIPT_END = "\t</target>\n</project>\n";
    private String TASKDEFS_TAIL = "\n</project>\n";
    private String TASKDEF_CREATE_APP_VARIABLE = "\t<target name=\"create-app-variable\">\n\t\t<jbi-create-application-variables\n\t\t\tusername=\"${jbi.username}\"\n\t\t\tpassword=\"${jbi.password}\"\n\t\t\thost=\"${jbi.host}\"\n\t\t\tport=\"${jbi.port}\"\n\t\t\ttarget=\"${jbi.target}\"\n\t\t\tsecure=\"${jbi.secure}\"\n\t\t\tfailOnError=\"false\"\n\t\t\tcomponentName=\"${component.name}\"\n\t\t\tappvariables=\"${properties.file.name}\"/>\n\t</target>\n";
    private String TASKDEF_CREATE_APP_CONFIG = "\t<target name=\"create-app-configuration\">\n\t\t<jbi-create-application-configuration\n\t\t\tusername=\"${jbi.username}\"\n\t\t\tpassword=\"${jbi.password}\"\n\t\t\thost=\"${jbi.host}\"\n\t\t\tport=\"${jbi.port}\"\n\t\t\ttarget=\"${jbi.target}\"\n\t\t\tsecure=\"${jbi.secure}\"\n\t\t\tfailOnError=\"false\"\n\t\t\tcomponentName=\"${component.name}\"\n\t\t\tname=\"${config.name}\"\n\t\t\tparams=\"${properties.file.name}\"/>\n\t</target>\n";
    private String TASKDEF_DEPLOY_APP = "\t<target name=\"deploy-application\">\n\t\t<jbi-deploy-service-assembly \n\t\t\tusername=\"${jbi.username}\"\n\t\t\tpassword=\"${jbi.password}\"\n\t\t\thost=\"${jbi.host}\"\n\t\t\tport=\"${jbi.port}\"\n\t\t\ttarget=\"${jbi.target}\"\n\t\t\tsecure=\"${jbi.secure}\"\n\t\t\tfailOnError=\"true\"\n\t\t\tfile=\"${deploy.file}\">\n\t\t</jbi-deploy-service-assembly>\n\t</target>\n";

    public TemplateGenerator(EnvironmentContext envCtx, I18NBundle resourceBundle) {
        this.mEnvCtx = envCtx;
        this.mResourceBundle = resourceBundle;
        this.mVerifierUtil = new VerifierUtils(resourceBundle);
    }

    public String generateTemplates(Map<String, List<String>> mapAppVars, Map<String, List<String>> mapAppConfigs, Map<String, CompositeType> mapAppConfigTypes, boolean includeDeployCommand, String target, boolean isAnt, String saName, String saPath) {
        return this.generateTemplates(mapAppVars, mapAppConfigs, mapAppConfigTypes, includeDeployCommand, target, isAnt, saName, saPath, false, null, null);
    }

    public String generateTemplates(Map<String, List<String>> mapAppVars, Map<String, List<String>> mapAppConfigs, Map<String, CompositeType> mapAppConfigTypes, boolean includeDeployCommand, String target, boolean isAnt, String saName, String saPath, boolean fillInValues, Map<String, Map<String, Object>> mapAppVarValues, Map<String, Map<String, Properties>> mapAppConfigValues) {
        try {
            File templatesDir = this.createTemplatesDir(saName);
            Set<String> components = mapAppVars.keySet();
            for (String component : components) {
                File propFile;
                Map<String, Object> appVarValues = new HashMap<String, Object>();
                if (fillInValues && mapAppVarValues != null && mapAppVarValues.containsKey(component)) {
                    appVarValues = mapAppVarValues.get(component);
                }
                if ((propFile = this.createPropertiesFile(templatesDir, component, mapAppVars.get(component), fillInValues, appVarValues)) != null) {
                    this.mAppVarFile.put(component, propFile);
                }
                ToolsLogManager.getRuntimeLogger().log(Level.FINER, "Generated app. var. file {0} for component {1}", new Object[]{propFile, component});
            }
            components = mapAppConfigs.keySet();
            for (String component : components) {
                List<String> appConfigs = mapAppConfigs.get(component);
                ArrayList<File> propFileList = new ArrayList<File>();
                for (String config : appConfigs) {
                    Map<String, Properties> appConfigValues = new HashMap<String, Properties>();
                    if (fillInValues && mapAppConfigValues != null && mapAppConfigValues.containsKey(component)) {
                        appConfigValues = mapAppConfigValues.get(component);
                    }
                    File propFile = this.createPropertiesFile(templatesDir, component, mapAppConfigTypes.get(component), config, fillInValues, appConfigValues);
                    propFileList.add(propFile);
                }
                File[] propFileArray = new File[propFileList.size()];
                this.mAppConfigFile.put(component, propFileList.toArray(propFileArray));
            }
            if (isAnt) {
                this.generateAntScript(templatesDir, includeDeployCommand, target, this.mAppVarFile, this.mAppConfigFile, saPath);
                ToolsLogManager.getRuntimeLogger().finer("Generated ant script for app. vars");
            }
            try {
                JarFactory jarFactory = new JarFactory(templatesDir.getPath());
                File zipFile = new File(templatesDir, saName + TEMPLATE_ZIP_SUFFIX);
                if (zipFile.exists() && !zipFile.delete()) {
                    throw new VerifierException(this.mResourceBundle.getMessage("VERIFIER_TEMPLATE_ZIP_EXISTS"));
                }
                ToolsLogManager.getRuntimeLogger().log(Level.FINER, "Creating zip file with templates in {0}", templatesDir);
                return jarFactory.zip(zipFile.getName());
            }
            catch (IOException ex) {
                String message = this.mResourceBundle.getMessage("VERIFIER_TEMPLATE_ZIP_NOT_CREATED") + ex.getMessage();
                ToolsLogManager.getRuntimeLogger().warning(message);
                return null;
            }
        }
        catch (VerifierException ex) {
            ToolsLogManager.getRuntimeLogger().log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    private File createPropertiesFile(File templatesDir, String componentName, List<String> varList, boolean fillInValues, Map<String, Object> mapVarValues) throws VerifierException {
        try {
            if (varList != null && varList.size() == 0) {
                return null;
            }
            Properties properties = new Properties();
            for (String property : varList) {
                properties.setProperty(property, "");
                if (!fillInValues || mapVarValues == null) continue;
                try {
                    properties.put(property, mapVarValues.get(property));
                }
                catch (Throwable th) {
                    String message = this.mResourceBundle.getMessage("VERIFIER_ISSUE_EXPORTING_APP_VAR_VALUE", new Object[]{property});
                    ToolsLogManager.getRuntimeLogger().warning(message);
                    if (th.getMessage() == null) continue;
                    ToolsLogManager.getRuntimeLogger().warning(th.getMessage());
                }
            }
            File propertyFile = new File(templatesDir, componentName + APPVAR_TEMPLATE_SUFFIX);
            ToolsLogManager.getRuntimeLogger().log(Level.FINER, "Creating {0} with properties: {1}", new Object[]{propertyFile, properties});
            FileOutputStream fileoutputstream = new FileOutputStream(propertyFile);
            String headerStr = " " + this.mResourceBundle.getMessage("VERIFIER_PROP_FILE_HEADER") + " " + this.mResourceBundle.getMessage("VERIFIER_PROP_FILE_HEADER1");
            properties.store(fileoutputstream, headerStr);
            return propertyFile;
        }
        catch (IOException ex) {
            throw new VerifierException(ex);
        }
    }

    private File createPropertiesFile(File templatesDir, String componentName, CompositeType appConfigType, String configName, boolean fillInValues, Map<String, Properties> mapAppConfigValues) throws VerifierException {
        try {
            Properties properties;
            block8: {
                Set<Object> appConfigItemNames = new HashSet();
                if (appConfigType != null) {
                    appConfigItemNames = appConfigType.keySet();
                }
                properties = new Properties();
                for (String string : appConfigItemNames) {
                    properties.setProperty(string, "");
                    if (!string.equals(CONFIGURATION_NAME)) continue;
                    properties.setProperty(CONFIGURATION_NAME, configName);
                }
                if (fillInValues && mapAppConfigValues != null) {
                    try {
                        if (mapAppConfigValues.get(configName) != null) {
                            properties = mapAppConfigValues.get(configName);
                        }
                    }
                    catch (Throwable th) {
                        String string = this.mResourceBundle.getMessage("VERIFIER_ISSUE_EXPORTING_APP_CONFIG_VALUE", new Object[]{configName});
                        ToolsLogManager.getRuntimeLogger().warning(string);
                        if (th.getMessage() == null) break block8;
                        ToolsLogManager.getRuntimeLogger().warning(th.getMessage());
                    }
                }
            }
            File propertyFile = new File(templatesDir, componentName + HYPHEN + configName + APPCONFIG_TEMPLATE_SUFFIX);
            ToolsLogManager.getRuntimeLogger().log(Level.FINER, "Creating {0} with properties: {1}", new Object[]{propertyFile, properties});
            FileOutputStream fileOutputStream = new FileOutputStream(propertyFile);
            String headerStr = " " + this.mResourceBundle.getMessage("VERIFIER_PROP_FILE_HEADER") + " " + this.mResourceBundle.getMessage("VERIFIER_PROP_FILE_HEADER1");
            properties.store(fileOutputStream, headerStr);
            return propertyFile;
        }
        catch (IOException ex) {
            throw new VerifierException(ex);
        }
    }

    private File createTemplatesDir(String saName) {
        File tmpDir = new File(this.mEnvCtx.getJbiInstanceRoot(), TMP);
        File verifierDir = new File(tmpDir, VERIFIER + File.separator + saName + TEMPLATE_DIR_SUFFIX);
        if (verifierDir.exists()) {
            this.mVerifierUtil.cleanup(verifierDir.getPath());
        }
        verifierDir.mkdirs();
        ToolsLogManager.getRuntimeLogger().log(Level.FINER, "Created templates dir in server {0}", verifierDir);
        return verifierDir;
    }

    private void generateAntScript(File templateDir, boolean includeDeployCommand, String target, Map<String, File> mapAppVarFile, Map<String, File[]> mapAppConfigFile, String saPath) throws VerifierException {
        try {
            File connPropertiesFile = new File(templateDir, PROPERTIES_FILE_NAME);
            File antScriptFile = new File(templateDir, ANT_FILE_NAME);
            this.createConnectionPropertiesFile(connPropertiesFile, target);
            FileWriter fileWriter = new FileWriter(antScriptFile);
            fileWriter.write(this.mResourceBundle.getMessage("ANT_SCRIPT_BEGIN_HEADERS") + this.ANT_SCRIPT_BEGIN);
            fileWriter.write(this.TASKDEF_CREATE_APP_VARIABLE);
            fileWriter.write(this.TASKDEF_CREATE_APP_CONFIG);
            if (includeDeployCommand) {
                fileWriter.write(this.TASKDEF_DEPLOY_APP);
            }
            fileWriter.write(this.ANT_SCRIPT_CONFIGURE_TARGET_BEGIN);
            Set<String> components = mapAppVarFile.keySet();
            for (String component : components) {
                fileWriter.write(this.constructAddAppVariableTask(component, mapAppVarFile.get(component)));
                ToolsLogManager.getRuntimeLogger().log(Level.FINER, "Added set task for {0}", component);
            }
            components = mapAppConfigFile.keySet();
            for (String component : components) {
                File[] configFiles;
                for (File configFile : configFiles = mapAppConfigFile.get(component)) {
                    fileWriter.write(this.constructAddAppConfigurationTask(component, configFile));
                    ToolsLogManager.getRuntimeLogger().log(Level.FINER, "Added set task for {0}", component);
                }
            }
            if (includeDeployCommand) {
                fileWriter.write(this.constructDeployTask(target, saPath));
                ToolsLogManager.getRuntimeLogger().log(Level.FINER, "Added deploy task for {0}", saPath);
            }
            fileWriter.write(this.ANT_SCRIPT_END);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException ex) {
            throw new VerifierException(ex);
        }
    }

    private String constructAddAppVariableTask(String componentName, File propertyFile) {
        String fileName = null;
        try {
            fileName = propertyFile.getName();
        }
        catch (Exception ex) {
            ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
        }
        return "\t\t<antcall target=\"create-app-variable\">\n\t\t\t<param name=\"component.name\" value=\"" + componentName + "\"/>\n" + "\t\t\t<param name=\"properties.file.name\" value=\"" + fileName + "\"/>\n" + "\t\t</antcall>\n";
    }

    private String constructDeployTask(String targetName, String saPath) {
        return "\t\t<antcall target=\"deploy-application\">\n\t\t\t<param name=\"deploy.file\" value=\"" + saPath + "\"/>\n " + "\t\t</antcall>\n";
    }

    private String constructAddAppConfigurationTask(String componentName, File propertyFile) {
        String fileName = null;
        String configName = "CONFIG";
        try {
            fileName = propertyFile.getName();
            configName = fileName.substring(fileName.indexOf(componentName) + componentName.length() + 1, fileName.lastIndexOf(".properties"));
        }
        catch (Exception ex) {
            ToolsLogManager.getRuntimeLogger().warning(ex.getMessage());
        }
        return "\t\t<antcall target=\"create-app-configuration\">\n\t\t\t<param name=\"component.name\" value=\"" + componentName + "\"/>\n" + "\t\t\t<param name=\"config.name\" value=\"" + configName + "\"/>\n" + "\t\t\t<param name=\"properties.file.name\" value=\"" + fileName + "\"/>\n " + "\t\t</antcall>\n";
    }

    private void createConnectionPropertiesFile(File propertiesFile, String targetName) {
        try {
            String newLine = "\n";
            StringBuffer connectionProperties = new StringBuffer();
            connectionProperties.append(this.mResourceBundle.getMessage("VERIFIER_PROP_FILE_HEADER"));
            connectionProperties.append(newLine);
            connectionProperties.append("jbi.username=admin");
            connectionProperties.append(newLine);
            connectionProperties.append("jbi.password=adminadmin");
            connectionProperties.append(newLine);
            connectionProperties.append("jbi.host=localhost");
            connectionProperties.append(newLine);
            connectionProperties.append("jbi.port=4848");
            connectionProperties.append(newLine);
            connectionProperties.append("jbi.secure=false");
            connectionProperties.append(newLine);
            connectionProperties.append("jbi.target=" + targetName);
            FileWriter fileWriter = new FileWriter(propertiesFile);
            fileWriter.write(connectionProperties.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Throwable ex) {
            ToolsLogManager.getRuntimeLogger().log(Level.WARNING, ex.getMessage(), ex);
        }
    }
}

