/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.impl.deployment;

import com.sun.esb.management.api.deployment.DeploymentService;
import com.sun.esb.management.base.services.AbstractServiceMBeansImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ui.common.JBIArchive;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;

public class DeploymentServiceMBeanImpl
extends AbstractServiceMBeansImpl
implements DeploymentService,
Serializable {
    static final long serialVersionUID = -1L;

    public DeploymentServiceMBeanImpl(EnvironmentContext anEnvContext) {
        super(anEnvContext);
    }

    public String deployServiceAssembly(String zipFilePath, String targetName) throws ManagementRemoteException {
        DeploymentServiceMBeanImpl.logDebug("deploying Service Assembly Zip file " + zipFilePath);
        String result = null;
        Object resultObject = null;
        String assemblyName = this.validateServiceAssembly(zipFilePath);
        File file = new File(zipFilePath);
        String fileURLString = null;
        fileURLString = file.getAbsolutePath();
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        DeploymentServiceMBeanImpl.logDebug("Calling deploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "deploy", fileURLString);
        if (resultObject != null) {
            result = resultObject.toString();
            result = assemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : assemblyName;
        } else {
            Exception exception = this.createManagementException("ui.mbean.deploy.error", null, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
        return result;
    }

    String validateServiceAssembly(String zipFilePath) {
        JBIArchive archive = null;
        ServiceAssemblyDD descriptor = null;
        String name = null;
        try {
            archive = new JBIArchive(zipFilePath);
            if (archive.isServiceAssemblyArchive()) {
                descriptor = (ServiceAssemblyDD)archive.getJbiDescriptor();
                name = descriptor.getName();
            }
        }
        catch (IOException ioException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public String deployServiceAssemblyFromDomain(String assemblyName, String targetName) throws ManagementRemoteException {
        if (targetName.equals("domain")) {
            return assemblyName;
        }
        String result = null;
        Object resultObject = null;
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        if (deploymentServiceObjectName != null) {
            this.checkForValidTarget(deploymentServiceObjectName, targetName);
            DeploymentServiceMBeanImpl.logDebug("Invoking deployServiceAssemblyFromRepository which internally invokes deploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
            resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "deployFromRepository", assemblyName);
        }
        if (resultObject != null) {
            result = resultObject.toString();
            result = assemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : assemblyName;
        } else {
            Exception exception = this.createManagementException("ui.mbean.deploy.error", null, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
        return result;
    }

    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String targetName) throws ManagementRemoteException {
        return this.undeployServiceAssemblyInternal(serviceAssemblyName, forceDelete, retainInDomain, targetName);
    }

    public String undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String targetName) throws ManagementRemoteException {
        if (!forceDelete) {
            return this.undeployServiceAssembly(serviceAssemblyName, targetName);
        }
        boolean retainInDomian = false;
        return this.undeployServiceAssembly(serviceAssemblyName, forceDelete, retainInDomian, targetName);
    }

    public String undeployServiceAssembly(String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        return this.undeployServiceAssemblyInternal(serviceAssemblyName, targetName);
    }

    String undeployServiceAssemblyInternal(String serviceAssemblyName, boolean force, boolean retainInDomain, String targetName) throws ManagementRemoteException {
        DeploymentServiceMBeanImpl.logDebug("Undeploying Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        DeploymentServiceMBeanImpl.logDebug("Calling undeploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object[] params = new Object[]{serviceAssemblyName, force, retainInDomain};
        String[] signature = new String[]{"java.lang.String", "boolean", "boolean"};
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "undeploy", params, signature);
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.undeploy.error", null, null);
        throw new ManagementRemoteException((Throwable)exception);
    }

    String undeployServiceAssemblyInternal(String serviceAssemblyName, String targetName) throws ManagementRemoteException {
        DeploymentServiceMBeanImpl.logDebug("Undeploying Service Assembly " + serviceAssemblyName);
        ObjectName deploymentServiceObjectName = this.getDeploymentServiceMBeanObjectName(targetName);
        this.checkForValidTarget(deploymentServiceObjectName, targetName);
        DeploymentServiceMBeanImpl.logDebug("Calling undeploy on DeploymentServiceMBean = " + deploymentServiceObjectName);
        Object resultObject = this.invokeMBeanOperation(deploymentServiceObjectName, "undeploy", serviceAssemblyName);
        String result = null;
        if (resultObject != null) {
            result = resultObject.toString();
            result = serviceAssemblyName == null || result.contains("FAILED") || result.contains("WARNING") ? resultObject.toString() : serviceAssemblyName;
            return result;
        }
        Exception exception = this.createManagementException("ui.mbean.undeploy.error", null, null);
        throw new ManagementRemoteException((Throwable)exception);
    }

    public Map<String, String> deployServiceAssembly(String zipFilePath, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (String targetName : targetNames) {
            try {
                xmlString = this.deployServiceAssembly(zipFilePath, targetName);
                if (xmlString == null) continue;
                result.putIfAbsent(targetName, xmlString);
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace((JBIRemoteException)exception);
                result.putIfAbsent(targetName, xmlString);
            }
        }
        return result;
    }

    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (String targetName : targetNames) {
            try {
                xmlString = this.undeployServiceAssembly(serviceAssemblyName, targetName);
                if (xmlString == null) continue;
                result.putIfAbsent(targetName, xmlString);
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace((JBIRemoteException)exception);
                result.putIfAbsent(targetName, xmlString);
            }
        }
        return result;
    }

    public Map<String, String> deployServiceAssemblyFromDomain(String assemblyName, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (String targetName : targetNames) {
            try {
                xmlString = this.deployServiceAssemblyFromDomain(assemblyName, targetName);
                if (xmlString == null) continue;
                result.putIfAbsent(targetName, xmlString);
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace((JBIRemoteException)exception);
                result.putIfAbsent(targetName, xmlString);
            }
        }
        return result;
    }

    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (String targetName : targetNames) {
            try {
                xmlString = this.undeployServiceAssembly(serviceAssemblyName, forceDelete, targetName);
                if (xmlString == null) continue;
                result.putIfAbsent(targetName, xmlString);
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace((JBIRemoteException)exception);
                result.putIfAbsent(targetName, xmlString);
            }
        }
        return result;
    }

    public Map<String, String> undeployServiceAssembly(String serviceAssemblyName, boolean forceDelete, boolean retainInDomain, String[] targetNames) throws ManagementRemoteException {
        String xmlString = null;
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        for (String targetName : targetNames) {
            try {
                xmlString = this.undeployServiceAssembly(serviceAssemblyName, forceDelete, retainInDomain, targetName);
                if (xmlString == null) continue;
                result.putIfAbsent(targetName, xmlString);
            }
            catch (ManagementRemoteException exception) {
                xmlString = this.getStackTrace((JBIRemoteException)exception);
                result.putIfAbsent(targetName, xmlString);
            }
        }
        return result;
    }
}

