/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.base.services;

import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.TargetType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.ToolsLogManager;
import com.sun.jbi.ui.common.Util;
import com.sun.jbi.ui.runtime.GenericsSupport;
import com.sun.jbi.util.ComponentConfigurationHelper;
import com.sun.jbi.util.EnvironmentAccess;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public abstract class AbstractServiceMBeansImpl
implements Serializable {
    static final long serialVersionUID = -1L;
    private static I18NBundle I18NBUNDLE = null;
    protected EnvironmentContext environmentContext;
    protected ComponentConfigurationHelper componentConfigurationHelper;
    protected static final String DOMAIN_TARGET_KEY = "domain";
    protected static final String SERVER_TARGET_KEY = "server";
    protected static final String CUSTOM_CONFIGURATION_NAME_KEY = "Configuration";
    protected static final String CUSTOM_STATISTICS_NAME_KEY = "Statistics";
    protected static final String CUSTOM_ADMINISTRATION_NAME_KEY = "Administration";
    protected static final String CUSTOM_MANAGEMENT_ACTIONS_NAME_KEY = "ManagementActions";
    protected static final String CUSTOM_LOGGER_NAME_KEY = "Logger";
    protected static final String STARTED_STATE = "Started";
    protected static final String RUNNING_STATE = "Running";
    protected static final String EQUAL = "=";
    protected static final String COLON = ":";
    protected static final String COMMA = ",";
    protected static final char PASSWORD_MASK_CHARACTER = '*';
    protected static final String COMPONENT_CONFIG_INSTANCE_ERROR_KEY = "com.sun.jbi.cluster.instance.error";
    protected static final String JMX_EBI_DOMAIN = "com.sun.ebi";
    protected static String EBIJMXDOMAIN = null;
    protected static final String SERVICE_TYPE_KEY = "ServiceType";
    protected static final String IDENTIFICATION_NAME_KEY = "IdentificationName";

    public AbstractServiceMBeansImpl(EnvironmentContext anEnvContext) {
        this.environmentContext = anEnvContext;
        this.componentConfigurationHelper = new ComponentConfigurationHelper();
    }

    protected static void log(String aMsg) {
        ToolsLogManager.getRuntimeLogger().info(aMsg);
    }

    protected static void logDebug(String aMsg) {
        ToolsLogManager.getRuntimeLogger().fine(aMsg);
    }

    protected static void logDebug(Exception ex) {
        ToolsLogManager.getRuntimeLogger().log(Level.FINER, ex.getMessage(), ex);
    }

    protected static void logError(Exception ex) {
        ToolsLogManager.getRuntimeLogger().log(Level.SEVERE, ex.getMessage(), ex);
    }

    public static void logWarning(Exception ex) {
        ToolsLogManager.getRuntimeLogger().log(Level.WARNING, ex.getMessage(), ex);
    }

    protected PlatformContext getPlatformContext() {
        PlatformContext platformContext = null;
        EnvironmentContext context = AbstractServiceMBeansImpl.getEnvironmentContext();
        if (context != null) {
            platformContext = context.getPlatformContext();
        }
        return platformContext;
    }

    protected static EnvironmentContext getEnvironmentContext() {
        return EnvironmentAccess.getContext();
    }

    protected static I18NBundle getI18NBundle() {
        if (I18NBUNDLE == null) {
            I18NBUNDLE = new I18NBundle("com.sun.jbi.ui.runtime.mbeans");
        }
        return I18NBUNDLE;
    }

    protected static I18NBundle getI18NBundle(String packageName) {
        if (I18NBUNDLE == null) {
            I18NBUNDLE = new I18NBundle(packageName);
        }
        return I18NBUNDLE;
    }

    protected Object getAttributeValue(String targetName, ObjectName objectName, String attributeName) throws ManagementRemoteException {
        if (DOMAIN_TARGET_KEY.equals(targetName) || SERVER_TARGET_KEY.equals(targetName)) {
            return this.getAttributeValue(objectName, attributeName);
        }
        MBeanServerConnection connection = this.getMBeanServerConnection(targetName);
        return this.getAttributeValue(connection, objectName, attributeName);
    }

    protected Object getAttributeValue(MBeanServer mbeanServer, ObjectName objectName, String attributeName) throws ManagementRemoteException {
        Object result = null;
        try {
            result = mbeanServer.getAttribute(objectName, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (ReflectionException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (MBeanException mbeanEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
        return result;
    }

    protected Object getAttributeValue(MBeanServerConnection mbeanServer, ObjectName objectName, String attributeName) throws ManagementRemoteException {
        Object result = null;
        try {
            result = mbeanServer.getAttribute(objectName, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (MBeanException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (ReflectionException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (IOException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        return result;
    }

    protected Object getAttributeValue(ObjectName objectName, String attributeName) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        Object result = null;
        try {
            result = mbeanServer.getAttribute(objectName, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (ReflectionException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (MBeanException mbeanEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
        return result;
    }

    protected void setAttributeValue(String targetName, ObjectName objectName, String attributeName, Object attributeValue) throws ManagementRemoteException {
        if (DOMAIN_TARGET_KEY.equals(targetName) || SERVER_TARGET_KEY.equals(targetName)) {
            this.setAttributeValue(objectName, attributeName, attributeValue);
        } else {
            MBeanServerConnection connection = this.getMBeanServerConnection(targetName);
            this.setAttributeValue(connection, objectName, attributeName, attributeValue);
        }
    }

    protected void setAttributeValue(ObjectName objectName, String attributeName, Object attributeValue) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        Attribute attribute = null;
        attribute = new Attribute(attributeName, attributeValue);
        try {
            mbeanServer.setAttribute(objectName, attribute);
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (InvalidAttributeValueException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (ReflectionException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (MBeanException mbeanEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
    }

    protected void setAttributeValue(MBeanServerConnection connection, ObjectName objectName, String attributeName, Object attributeValue) throws ManagementRemoteException {
        Attribute attribute = null;
        attribute = new Attribute(attributeName, attributeValue);
        try {
            connection.setAttribute(objectName, attribute);
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (InvalidAttributeValueException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (MBeanException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (ReflectionException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (IOException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        Object result = null;
        try {
            result = mbeanServer.invoke(objectName, operationName, params, signature);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (MBeanException mbeanEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
        return result;
    }

    protected Object invokeMBeanOperation(MBeanServerConnection connection, ObjectName objectName, String operationName, Object[] params, String[] signature) throws ManagementRemoteException {
        Object result = null;
        try {
            result = connection.invoke(objectName, operationName, params, signature);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (MBeanException mbeanEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (IOException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
        return result;
    }

    protected Object invokeMBeanOperation(String targetName, ObjectName objectName, String operationName, Object[] params, String[] signature) throws ManagementRemoteException {
        if (DOMAIN_TARGET_KEY.equals(targetName) || SERVER_TARGET_KEY.equals(targetName)) {
            return this.invokeMBeanOperation(objectName, operationName, params, signature);
        }
        MBeanServerConnection connection = this.getMBeanServerConnection(targetName);
        return this.invokeMBeanOperation(connection, objectName, operationName, params, signature);
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName, String param) throws ManagementRemoteException {
        Object[] params = new Object[]{param};
        String[] signature = new String[]{"java.lang.String"};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }

    protected Object invokeMBeanOperation(ObjectName objectName, String operationName) throws ManagementRemoteException {
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }

    protected Object getMBeanAttribute(ObjectName objectName, String attributeName) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        Object result = null;
        try {
            result = mbeanServer.getAttribute(objectName, attributeName);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (MBeanException mbeanEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
        return result;
    }

    protected boolean isMBeanRegistered(ObjectName objectName) throws ManagementRemoteException {
        boolean result = false;
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        try {
            result = mbeanServer.isRegistered(objectName);
        }
        catch (RuntimeException exception) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)exception);
        }
        return result;
    }

    protected String setLevel(Level logLevel) {
        if (null == logLevel) {
            return "setDefault";
        }
        if (Level.OFF.equals(logLevel)) {
            return "setOff";
        }
        if (Level.SEVERE.equals(logLevel)) {
            return "setSevere";
        }
        if (Level.WARNING.equals(logLevel)) {
            return "setWarning";
        }
        if (Level.INFO.equals(logLevel)) {
            return "setInfo";
        }
        if (Level.CONFIG.equals(logLevel)) {
            return "setConfig";
        }
        if (Level.FINE.equals(logLevel)) {
            return "setFine";
        }
        if (Level.FINER.equals(logLevel)) {
            return "setFiner";
        }
        if (Level.FINEST.equals(logLevel)) {
            return "setFinest";
        }
        if (Level.ALL.equals(logLevel)) {
            return "setAll";
        }
        return "setDefault";
    }

    protected boolean isValidTarget(ObjectName objectName) throws ManagementRemoteException {
        boolean result = false;
        MBeanServer mbeanServer = AbstractServiceMBeansImpl.getEnvironmentContext().getMBeanServer();
        try {
            result = mbeanServer.isRegistered(objectName);
        }
        catch (RuntimeException exception) {
            // empty catch block
        }
        return result;
    }

    protected boolean isValidTarget(ObjectName objectName, String targetName) throws ManagementRemoteException {
        boolean result = false;
        if (targetName.equals(DOMAIN_TARGET_KEY) || targetName.equals(SERVER_TARGET_KEY)) {
            MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
            try {
                result = mbeanServer.isRegistered(objectName);
            }
            catch (RuntimeException exception) {}
        } else {
            MBeanServerConnection connection = this.getMBeanServerConnection(targetName);
            try {
                result = connection.isRegistered(objectName);
            }
            catch (RuntimeException exception) {
            }
            catch (IOException exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected void setMBeanAttribute(ObjectName objectName, String attributeName, Object attributeValue) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        try {
            Attribute attr = new Attribute(attributeName, attributeValue);
            mbeanServer.setAttribute(objectName, attr);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (MBeanException mbeanEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
    }

    protected void setMBeanAttributes(ObjectName objectName, AttributeList attrList) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        try {
            mbeanServer.setAttributes(objectName, attrList);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
    }

    protected AttributeList setMBeanAttributes(MBeanServerConnection mbeanServer, ObjectName objectName, AttributeList attrList) throws ManagementRemoteException {
        try {
            return mbeanServer.setAttributes(objectName, attrList);
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
    }

    protected AttributeList constructMBeanAttributes(ObjectName objectName, Properties params) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        AttributeList attrList = new AttributeList();
        try {
            MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mbeanAttrInfoArray = mbeanInfo.getAttributes();
            HashMap<String, MBeanAttributeInfo> attribInfoMap = new HashMap<String, MBeanAttributeInfo>();
            for (int i = 0; i < mbeanAttrInfoArray.length; ++i) {
                MBeanAttributeInfo mBeanAttributeInfo = mbeanAttrInfoArray[i];
                attribInfoMap.put(mBeanAttributeInfo.getName(), mBeanAttributeInfo);
            }
            for (String string : params.keySet()) {
                String stringValue = params.getProperty(string);
                Object attrValueObj = null;
                if (attribInfoMap.isEmpty()) {
                    attrValueObj = stringValue;
                } else {
                    MBeanAttributeInfo attrInfo = (MBeanAttributeInfo)attribInfoMap.get(string);
                    if (attrInfo == null) {
                        String[] args = new String[]{string};
                        Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.info.not.found", args, null);
                        throw new ManagementRemoteException((Throwable)exception);
                    }
                    String type = attrInfo.getType();
                    try {
                        attrValueObj = Util.newInstance((String)type, (String)stringValue);
                    }
                    catch (Exception ex) {
                        String[] args = new String[]{stringValue, type, string};
                        Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                        throw new ManagementRemoteException((Throwable)exception);
                    }
                }
                Attribute attr = new Attribute(string, attrValueObj);
                attrList.add(attr);
            }
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
        return attrList;
    }

    protected AttributeList constructMBeanAttributes(ObjectName objectName, Map<String, Object> params) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        AttributeList attrList = new AttributeList();
        try {
            MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mbeanAttrInfoArray = mbeanInfo.getAttributes();
            HashMap<String, MBeanAttributeInfo> attribInfoMap = new HashMap<String, MBeanAttributeInfo>();
            for (int i = 0; i < mbeanAttrInfoArray.length; ++i) {
                MBeanAttributeInfo attrInfo = mbeanAttrInfoArray[i];
                attribInfoMap.put(attrInfo.getName(), attrInfo);
            }
            for (String attrName : params.keySet()) {
                Object attrValueObj = params.get(attrName);
                Attribute attr = new Attribute(attrName, attrValueObj);
                attrList.add(attr);
            }
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
        return attrList;
    }

    protected AttributeList constructMBeanAttributes(MBeanServerConnection mbeanServer, ObjectName objectName, Properties params) throws ManagementRemoteException {
        AttributeList attrList = new AttributeList();
        try {
            MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mbeanAttrInfoArray = mbeanInfo.getAttributes();
            HashMap<String, MBeanAttributeInfo> attribInfoMap = new HashMap<String, MBeanAttributeInfo>();
            for (int i = 0; i < mbeanAttrInfoArray.length; ++i) {
                MBeanAttributeInfo mBeanAttributeInfo = mbeanAttrInfoArray[i];
                attribInfoMap.put(mBeanAttributeInfo.getName(), mBeanAttributeInfo);
            }
            for (String string : params.keySet()) {
                String stringValue = params.getProperty(string);
                Object attrValueObj = null;
                MBeanAttributeInfo attrInfo = (MBeanAttributeInfo)attribInfoMap.get(string);
                if (attrInfo == null) {
                    String[] args = new String[]{string};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.info.not.found", args, null);
                    throw new ManagementRemoteException((Throwable)exception);
                }
                String type = attrInfo.getType();
                try {
                    attrValueObj = Util.newInstance((String)type, (String)stringValue);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue, type, string};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new ManagementRemoteException((Throwable)exception);
                }
                Attribute attr = new Attribute(string, attrValueObj);
                attrList.add(attr);
            }
            return attrList;
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
    }

    protected Exception createManagementException(String bundleKey, String[] args, Exception sourceException) {
        Exception exception = null;
        String xmlManagementMessage = JBIResultXmlBuilder.createJbiResultXml((I18NBundle)AbstractServiceMBeansImpl.getI18NBundle(), (String)bundleKey, (Object[])args, (Throwable)sourceException);
        exception = new Exception(xmlManagementMessage);
        return exception;
    }

    protected String createManagementMessage(String taskId, boolean successResult, String msgType, String msgCode, Object[] args) {
        String msg = AbstractServiceMBeansImpl.getI18NBundle().getMessage(msgCode, args);
        String xmlManagementMessage = JBIResultXmlBuilder.getInstance().createJbiResultXml(taskId, successResult, msgType, msgCode, msg, args);
        return xmlManagementMessage;
    }

    protected ObjectName getDeploymentServiceMBeanObjectName(String targetName) {
        MBeanNames mbeanNames = this.environmentContext.getMBeanNames();
        return mbeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, targetName);
    }

    protected ObjectName getAdminServiceMBeanObjectName() throws ManagementRemoteException {
        try {
            MBeanNames mbeanNames = this.environmentContext.getMBeanNames();
            return mbeanNames.getSystemServiceMBeanName("AdminService", "AdministrationService");
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
    }

    protected ObjectName getAdminServiceMBeanObjectName(String targetName) {
        MBeanNames mbeanNames = this.environmentContext.getMBeanNames();
        return mbeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, targetName);
    }

    protected ObjectName getInstallationServiceMBeanObjectName(String targetName) {
        MBeanNames mbeanNames = this.environmentContext.getMBeanNames();
        return mbeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, targetName);
    }

    protected void checkForValidTarget(ObjectName objectName, String targetName) throws ManagementRemoteException {
        boolean isRegistered = this.isValidTarget(objectName);
        if (!isRegistered) {
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.invalid.target.error", args, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
    }

    protected void checkForValidTarget(ObjectName objectName, String targetName, boolean useTargetNameFlag) throws ManagementRemoteException {
        boolean isRegistered = false;
        isRegistered = useTargetNameFlag ? this.isValidTarget(objectName, targetName) : this.isValidTarget(objectName);
        if (!isRegistered) {
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.invalid.target.error", args, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
    }

    protected TargetType checkTargetType(String target) {
        if (this.getPlatformContext().isStandaloneServer(target)) {
            return TargetType.STANDALONE_SERVER;
        }
        if (this.getPlatformContext().isCluster(target)) {
            return TargetType.CLUSTER;
        }
        if (this.getPlatformContext().isClusteredServer(target)) {
            return TargetType.CLUSTERED_SERVER;
        }
        if (DOMAIN_TARGET_KEY.equals(target)) {
            return TargetType.DOMAIN;
        }
        return TargetType.INVALID_TARGET;
    }

    protected MBeanServerConnection getMBeanServerConnection(String targetName) throws ManagementRemoteException {
        MBeanServerConnection connection = null;
        try {
            connection = this.getPlatformContext().getMBeanServerConnection(targetName);
        }
        catch (Exception e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        return connection;
    }

    protected static String getEbiJmxDomain() {
        if (EBIJMXDOMAIN == null) {
            EBIJMXDOMAIN = System.getProperty("ebi.jmx.domain", JMX_EBI_DOMAIN);
        }
        return EBIJMXDOMAIN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ObjectName getEbiStatusMBeanObjectName(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName objectName = null;
        Set<ObjectName> objectNameSet = null;
        String name = null;
        if (targetName.equals(DOMAIN_TARGET_KEY) || targetName.equals(SERVER_TARGET_KEY)) {
            MBeanServer server = this.environmentContext.getMBeanServer();
            name = AbstractServiceMBeansImpl.getEbiJmxDomain() + COLON + SERVICE_TYPE_KEY + "=Status," + IDENTIFICATION_NAME_KEY + EQUAL + componentName + ",*";
            try {
                ObjectName mBeanObjectName;
                ObjectName objectNameFilter = new ObjectName(name);
                if (server == null) return objectName;
                objectNameSet = server.queryNames(objectNameFilter, null);
                Iterator<ObjectName> i$ = objectNameSet.iterator();
                do {
                    if (!i$.hasNext()) return objectName;
                } while ((mBeanObjectName = i$.next()) == null);
                return mBeanObjectName;
            }
            catch (MalformedObjectNameException e) {
                throw new ManagementRemoteException((Throwable)e);
            }
            catch (NullPointerException e) {
                throw new ManagementRemoteException((Throwable)e);
            }
        }
        MBeanServerConnection connection = this.getMBeanServerConnection(targetName);
        name = AbstractServiceMBeansImpl.getEbiJmxDomain() + COLON + SERVICE_TYPE_KEY + "=Status," + IDENTIFICATION_NAME_KEY + EQUAL + componentName + ",*";
        try {
            ObjectName mBeanObjectName;
            ObjectName objectNameFilter = new ObjectName(name);
            if (connection == null) return objectName;
            objectNameSet = connection.queryNames(objectNameFilter, null);
            Iterator<ObjectName> i$ = objectNameSet.iterator();
            do {
                if (!i$.hasNext()) return objectName;
            } while ((mBeanObjectName = i$.next()) == null);
            return mBeanObjectName;
        }
        catch (MalformedObjectNameException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (NullPointerException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (IOException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
    }

    protected Properties getMBeanAttributeValues(MBeanServerConnection connection, ObjectName objectName) throws ManagementRemoteException {
        Properties properties = new Properties();
        ArrayList<String> keyList = new ArrayList<String>();
        MBeanInfo mbeanInfo = null;
        try {
            MBeanAttributeInfo[] mbeanAttrInfoArray;
            mbeanInfo = connection.getMBeanInfo(objectName);
            for (MBeanAttributeInfo attributeInfo : mbeanAttrInfoArray = mbeanInfo.getAttributes()) {
                String key = attributeInfo.getName();
                if (key == null) continue;
                Object value = null;
                try {
                    value = connection.getAttribute(objectName, key);
                }
                catch (AttributeNotFoundException e) {
                    throw new ManagementRemoteException((Throwable)e);
                }
                catch (InstanceNotFoundException e) {
                    throw new ManagementRemoteException((Throwable)e);
                }
                catch (MBeanException e) {
                    throw new ManagementRemoteException((Throwable)e);
                }
                catch (ReflectionException e) {
                    throw new ManagementRemoteException((Throwable)e);
                }
                if (value != null) {
                    if (key.equals("ApplicationVariables") || key.equals("ApplicationConfigurations")) continue;
                    properties.put(key, value + "");
                    keyList.add(key);
                    continue;
                }
                properties.put(key, "");
                keyList.add(key);
            }
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (IntrospectionException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (ReflectionException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (IOException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        return properties;
    }

    protected Map<String, Object> getMBeanAttributeValuesAsMap(MBeanServerConnection connection, ObjectName objectName) throws ManagementRemoteException {
        HashMap<String, Object> properties = null;
        properties = new HashMap<String, Object>();
        ArrayList<String> keyList = new ArrayList<String>();
        MBeanInfo mbeanInfo = null;
        try {
            MBeanAttributeInfo[] mbeanAttrInfoArray;
            mbeanInfo = connection.getMBeanInfo(objectName);
            for (MBeanAttributeInfo attributeInfo : mbeanAttrInfoArray = mbeanInfo.getAttributes()) {
                String key = attributeInfo.getName();
                if (key == null) continue;
                Object value = null;
                try {
                    value = connection.getAttribute(objectName, key);
                }
                catch (AttributeNotFoundException e) {
                    throw new ManagementRemoteException((Throwable)e);
                }
                catch (InstanceNotFoundException e) {
                    throw new ManagementRemoteException((Throwable)e);
                }
                catch (MBeanException e) {
                    throw new ManagementRemoteException((Throwable)e);
                }
                catch (ReflectionException e) {
                    throw new ManagementRemoteException((Throwable)e);
                }
                if (value == null || key.equals("ApplicationVariables") || key.equals("ApplicationConfigurations")) continue;
                properties.put(key, value);
                keyList.add(key);
            }
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (IntrospectionException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (ReflectionException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        catch (IOException e) {
            throw new ManagementRemoteException((Throwable)e);
        }
        return properties;
    }

    protected String setMBeanConfigAttributes(ObjectName objectName, AttributeList attrList) throws ManagementRemoteException {
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        return this.setMBeanConfigAttributes(mbeanServer, objectName, attrList);
    }

    protected String setMBeanConfigAttributes(MBeanServerConnection mbeanServer, ObjectName objectName, AttributeList attrList) throws ManagementRemoteException {
        try {
            return (String)mbeanServer.invoke(objectName, "setConfigurationAttributes", new Object[]{attrList}, new String[]{"javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new ManagementRemoteException((Throwable)notFoundEx);
        }
        catch (ReflectionException rEx) {
            throw new ManagementRemoteException((Throwable)rEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)rtOpEx);
        }
        catch (Exception ex) {
            throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
        }
    }

    protected String getStackTrace(JBIRemoteException exception) {
        String buffer = "";
        if (exception != null) {
            JBIManagementMessage message = exception.extractJBIManagementMessage();
            if (message != null) {
                buffer = message.getStackTrace();
            }
            if (buffer == null || buffer.trim().length() == 0) {
                Object[] elements;
                buffer = "";
                StringBuffer cause = exception.getCauseStackTrace();
                if (cause != null) {
                    buffer = buffer + AbstractServiceMBeansImpl.getI18NBundle().getMessage("ui.mbean.stacktrace.caused.by.info") + ":\n" + cause.toString();
                    buffer = buffer + "\n";
                } else {
                    elements = exception.getCauseMessageTrace();
                    if (elements != null) {
                        buffer = buffer + AbstractServiceMBeansImpl.getI18NBundle().getMessage("ui.mbean.stacktrace.caused.by.info") + ":\n";
                        for (Object element : elements) {
                            if (element == null) continue;
                            buffer = buffer + ((String)element).toString();
                            buffer = buffer + "\n";
                        }
                    }
                }
                elements = exception.getStackTrace();
                if (elements != null) {
                    buffer = buffer + AbstractServiceMBeansImpl.getI18NBundle().getMessage("ui.mbean.stacktrace.stack.trace.info") + ":\n";
                    for (Object element : elements) {
                        if (element == null) continue;
                        buffer = buffer + ((StackTraceElement)element).toString();
                        buffer = buffer + "\n";
                    }
                }
            }
        }
        return buffer;
    }

    protected void domainTargetCheck(String target) throws ManagementRemoteException {
        if (DOMAIN_TARGET_KEY.equals(target)) {
            Exception exception = this.createManagementException("ui.mbean.component.configuration.domain.unsupported.error", new String[0], null);
            throw new ManagementRemoteException((Throwable)exception);
        }
    }

    protected Map<String, String[]> listTargetNames() throws ManagementRemoteException {
        HashMap<String, String[]> targetNameToTargetInstanceNameMap = null;
        targetNameToTargetInstanceNameMap = new HashMap<String, String[]>();
        Set clusters = this.getPlatformContext().getClusterNames();
        Set servers = this.getPlatformContext().getStandaloneServerNames();
        for (String serverTargetName : servers) {
            targetNameToTargetInstanceNameMap.put(serverTargetName, null);
        }
        for (String clusterTargetName : clusters) {
            Set serversInCluster = this.getPlatformContext().getServersInCluster(clusterTargetName);
            ArrayList<String> serverNamesList = new ArrayList<String>();
            if (serversInCluster != null) {
                for (String instanceName : serversInCluster) {
                    serverNamesList.add(instanceName);
                }
            }
            String[] serverNamesArray = GenericsSupport.toArray(serverNamesList, String.class);
            targetNameToTargetInstanceNameMap.put(clusterTargetName, serverNamesArray);
        }
        return targetNameToTargetInstanceNameMap;
    }

    protected boolean isTargetUp(String targetName) throws ManagementRemoteException {
        boolean isTargetUp = false;
        Set clusters = this.getPlatformContext().getClusterNames();
        Set servers = this.getPlatformContext().getStandaloneServerNames();
        if (clusters.contains(targetName)) {
            Set serversInCluster = this.getPlatformContext().getServersInCluster(targetName);
            for (String instanceName : serversInCluster) {
                if (!this.getPlatformContext().isInstanceUp(instanceName)) continue;
                isTargetUp = true;
                break;
            }
        } else if (servers.contains(targetName)) {
            isTargetUp = this.getPlatformContext().isInstanceUp(targetName);
        }
        return isTargetUp;
    }

    protected Map<String, ObjectName[]> findLiveExtensionMBeanObjectNames(String componentName, String extensionName, String targetName) throws ManagementRemoteException {
        HashMap<String, ObjectName[]> resultMap = new HashMap<String, ObjectName[]>();
        Map<String, ObjectName[]> targetToObjectNamesMap = null;
        Map<String, String[]> targetToInstanceNamesMap = null;
        targetToInstanceNamesMap = this.listTargetNames();
        targetToObjectNamesMap = this.getComponentExtensionMBeanObjectNames(componentName, extensionName, targetName);
        if (targetToInstanceNamesMap != null && targetToObjectNamesMap != null) {
            String[] targetInstanceNames = targetToInstanceNamesMap.get(targetName);
            if (targetInstanceNames != null) {
                for (String instanceName : targetInstanceNames) {
                    if (!this.isPlatformContextInstanceUp(instanceName) || !this.isPlatformContextInstanceClustered(instanceName)) continue;
                    ObjectName[] objectName = targetToObjectNamesMap.get(targetName);
                    resultMap.put(instanceName, objectName);
                }
            } else if (this.isTargetUp(targetName) && !this.isPlatformContextClusteredServer(targetName)) {
                ObjectName[] objectName = targetToObjectNamesMap.get(targetName);
                resultMap.put(targetName, objectName);
            }
        }
        return resultMap;
    }

    protected Map<String, ObjectName[]> getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName) throws ManagementRemoteException {
        Map resultObject = null;
        AbstractServiceMBeansImpl.logDebug("Get Component Extension MBeans ");
        ObjectName extensionMBeanObjectName = null;
        try {
            extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, DOMAIN_TARGET_KEY);
        }
        catch (ManagementRemoteException exception) {
            // empty catch block
        }
        if (extensionMBeanObjectName == null) {
            return resultObject;
        }
        this.checkForValidTarget(extensionMBeanObjectName, DOMAIN_TARGET_KEY);
        AbstractServiceMBeansImpl.logDebug("Calling getCustomMBeanNames on extensionMBeanObjectName = " + extensionMBeanObjectName);
        resultObject = (Map)this.invokeMBeanOperation(extensionMBeanObjectName, "getCustomMBeanNames", extensionName);
        return resultObject;
    }

    protected ObjectName[] getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ObjectName[] resultObject = null;
        Map customMBeansMap = null;
        AbstractServiceMBeansImpl.logDebug("Get Component Extension MBeans ");
        ObjectName extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, DOMAIN_TARGET_KEY);
        if (extensionMBeanObjectName == null) {
            return resultObject;
        }
        this.checkForValidTarget(extensionMBeanObjectName, DOMAIN_TARGET_KEY);
        AbstractServiceMBeansImpl.logDebug("Calling getCustomMBeanNames on extensionMBeanObjectName = " + extensionMBeanObjectName);
        customMBeansMap = (Map)this.invokeMBeanOperation(extensionMBeanObjectName, "getCustomMBeanNames", extensionName);
        if (customMBeansMap != null && (targetName != null || targetInstanceName != null)) {
            resultObject = targetInstanceName != null ? (ObjectName[])customMBeansMap.get(targetInstanceName) : (ObjectName[])customMBeansMap.get(targetName);
        }
        return resultObject;
    }

    protected ObjectName getExtensionMBeanObjectName(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName adminSvcMBeanObjectName = this.getAdminServiceMBeanObjectName(targetName);
        this.checkForValidTarget(adminSvcMBeanObjectName, targetName);
        AbstractServiceMBeansImpl.logDebug("Calling getComponentExtensionFacadeMBean on AdminService = " + adminSvcMBeanObjectName);
        ObjectName extensionMBeanObjectName = (ObjectName)this.invokeMBeanOperation(adminSvcMBeanObjectName, "getComponentExtensionFacadeMBean", componentName);
        AbstractServiceMBeansImpl.logDebug("getComponentExtensionFacadeMBean on AdminService returned = " + extensionMBeanObjectName);
        return extensionMBeanObjectName;
    }

    protected String getPlatformContextAdminServerName() {
        return this.getPlatformContext().getAdminServerName();
    }

    protected boolean isPlatformContextAdminServer() {
        return this.getPlatformContext().isAdminServer();
    }

    protected String getPlatformContextInstanceName() {
        return this.getPlatformContext().getInstanceName();
    }

    protected boolean isPlatformContextInstanceUp(String instanceName) {
        return this.getPlatformContext().isInstanceUp(instanceName);
    }

    protected boolean platformContextSupportsMultipleServers() {
        return this.getPlatformContext().supportsMultipleServers();
    }

    protected String getPlatformContextTargetName() {
        return this.getPlatformContext().getTargetName();
    }

    protected String getPlatformContextTargetName(String instanceName) {
        return this.getPlatformContext().getTargetName(instanceName);
    }

    protected Set<String> getPlatformContextStandaloneServerNames() {
        return this.getPlatformContext().getStandaloneServerNames();
    }

    protected Set<String> getPlatformContextClusteredServerNames() {
        return this.getPlatformContext().getClusteredServerNames();
    }

    protected Set<String> getPlatformContextClusterNames() {
        return this.getPlatformContext().getClusterNames();
    }

    protected Set<String> getPlatformContextServersInCluster(String clusterName) {
        return this.getPlatformContext().getServersInCluster(clusterName);
    }

    protected boolean isPlatformContextValidTarget(String targetName) {
        return this.getPlatformContext().isValidTarget(targetName);
    }

    protected boolean isPlatformContextCluster(String targetName) {
        return this.getPlatformContext().isCluster(targetName);
    }

    protected boolean isPlatformContextStandaloneServer(String targetName) {
        return this.getPlatformContext().isStandaloneServer(targetName);
    }

    protected boolean isPlatformContextClusteredServer(String targetName) {
        return this.getPlatformContext().isClusteredServer(targetName);
    }

    protected boolean isPlatformContextInstanceClustered(String instanceName) {
        return this.getPlatformContext().isInstanceClustered(instanceName);
    }

    protected String getPlatformContextJmxRmiPort() {
        return this.getPlatformContext().getJmxRmiPort();
    }

    protected MBeanServer getPlatformContextMBeanServer() {
        return this.getPlatformContext().getMBeanServer();
    }

    protected String getPlatformContextInstanceRoot() {
        return this.getPlatformContext().getInstanceRoot();
    }

    protected String getPlatformContextInstallRoot() {
        return this.getPlatformContext().getInstallRoot();
    }
}

