/*
 * Decompiled with CFR 0.152.
 */
package org.openesb.runtime.tracking.settings;

import java.util.List;
import java.util.Map;
import org.openesb.runtime.tracking.settings.MessageTrackingSettingsException;

public class MessageTrackingSettings {
    private boolean enabled = false;
    private List<String> tasks = null;
    private int numberOfThreads = 4;

    private MessageTrackingSettings() {
    }

    public static MessageTrackingSettings fromMap(Map<String, Object> rawSettings) throws MessageTrackingSettingsException {
        if (rawSettings == null) {
            throw new MessageTrackingSettingsException("Settings map is null.");
        }
        MessageTrackingSettings mts = new MessageTrackingSettings();
        mts.enabled = (Boolean)rawSettings.get("enabled");
        mts.numberOfThreads = (Integer)rawSettings.get("numberOfThreads");
        mts.tasks = (List)rawSettings.get("tasks");
        return mts;
    }

    public static MessageTrackingSettings defaultSettings() {
        return new MessageTrackingSettings();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public List<String> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<String> tasks) {
        this.tasks = tasks;
    }
}

