/*
 * Decompiled with CFR 0.152.
 */
package org.openesb.runtime.tracking;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openesb.runtime.tracking.tasks.MessageTrackingThreadFactory;

public class MessageTrackingExecutor {
    private static MessageTrackingExecutor me_;
    private static final ReentrantReadWriteLock rwl;
    private static final Lock rl;
    private static final Lock wl;
    private static final String DEFAULT = "DEFAULT";
    private ConcurrentHashMap<String, Executor> executors;

    private MessageTrackingExecutor() {
        this.executors.put(DEFAULT, ExecutorFactory.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageTrackingExecutor get() {
        try {
            rl.lock();
            if (me_ == null) {
                wl.lock();
                if (me_ == null) {
                    me_ = new MessageTrackingExecutor();
                }
            }
            MessageTrackingExecutor messageTrackingExecutor = me_;
            return messageTrackingExecutor;
        }
        finally {
            wl.unlock();
            rl.unlock();
        }
    }

    public Executor getExecutor(String key) {
        return key == null || key.equals("") ? this.executors.get(DEFAULT) : this.executors.get(key);
    }

    public Executor getExecutor() {
        return this.getExecutor(DEFAULT);
    }

    static {
        rwl = new ReentrantReadWriteLock();
        rl = rwl.readLock();
        wl = rwl.writeLock();
    }

    private static class ExecutorFactory {
        private static final String defaultName = "DefaultMonitoringThread-";

        private ExecutorFactory() {
        }

        public static Executor getDefault() {
            int availProcs = Runtime.getRuntime().availableProcessors();
            LinkedBlockingQueue<Runnable> q = new LinkedBlockingQueue<Runnable>();
            ThreadPoolExecutor e = new ThreadPoolExecutor(4, availProcs < 4 ? 4 : availProcs, 30L, TimeUnit.SECONDS, q, new MessageTrackingThreadFactory(defaultName));
            return e;
        }
    }
}

