/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.DOMUtil;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import com.sun.jbi.ui.common.Util;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class JBIDescriptor {
    public abstract boolean isSharedLibraryDescriptor();

    public abstract boolean isServiceEngineDescriptor();

    public abstract boolean isBindingComponentDescriptor();

    public abstract boolean isServiceAssemblyDescriptor();

    public static JBIDescriptor createJBIDescriptor(Reader xmlReader) throws Exception {
        Document xmlDoc = DOMUtil.UTIL.buildDOMDocument(xmlReader);
        Element jbiElement = DOMUtil.UTIL.getElement(xmlDoc, "jbi");
        if (jbiElement == null) {
            throw new Exception(JBIResultXmlBuilder.createFailedJbiResultXml(Util.getCommonI18NBundle(), "not.a.jbi.descriptor", null));
        }
        Element saEl = DOMUtil.UTIL.getChildElement(jbiElement, "service-assembly");
        if (saEl != null) {
            return ServiceAssemblyDD.createServiceAssemblyDD(saEl);
        }
        Element slibEl = DOMUtil.UTIL.getChildElement(jbiElement, "shared-library");
        if (slibEl != null) {
            return SharedLibraryDD.createSharedLibraryDD(slibEl);
        }
        Element compEl = DOMUtil.UTIL.getChildElement(jbiElement, "component");
        if (compEl != null) {
            String type = compEl.getAttribute("type");
            if ("service-engine".equals(type)) {
                return ServiceEngineDD.createServiceEngineDD(compEl);
            }
            if ("binding-component".equals(type)) {
                return BindingComponentDD.createBindingComponentDD(compEl);
            }
        }
        throw new Exception(JBIResultXmlBuilder.createFailedJbiResultXml(Util.getCommonI18NBundle(), "not.a.jbi.descriptor", null));
    }

    public static JBIDescriptor createJBIDescriptor(String xmlText) throws Exception {
        return JBIDescriptor.createJBIDescriptor(new StringReader(xmlText));
    }

    public static class BindingComponentDD
    extends ComponentDD {
        protected BindingComponentDD() {
        }

        @Override
        public boolean isSharedLibraryDescriptor() {
            return false;
        }

        @Override
        public boolean isServiceEngineDescriptor() {
            return false;
        }

        @Override
        public boolean isBindingComponentDescriptor() {
            return true;
        }

        @Override
        public boolean isServiceAssemblyDescriptor() {
            return false;
        }

        public static BindingComponentDD createBindingComponentDD(Element compEl) {
            return new BindingComponentDD();
        }
    }

    public static class ServiceEngineDD
    extends ComponentDD {
        protected ServiceEngineDD() {
        }

        @Override
        public boolean isSharedLibraryDescriptor() {
            return false;
        }

        @Override
        public boolean isServiceEngineDescriptor() {
            return true;
        }

        @Override
        public boolean isBindingComponentDescriptor() {
            return false;
        }

        @Override
        public boolean isServiceAssemblyDescriptor() {
            return false;
        }

        public static ServiceEngineDD createServiceEngineDD(Element compEl) {
            return new ServiceEngineDD();
        }
    }

    public static abstract class ComponentDD
    extends JBIDescriptor {
        protected ComponentDD() {
        }
    }

    public static class SharedLibraryDD
    extends JBIDescriptor {
        protected SharedLibraryDD() {
        }

        @Override
        public boolean isSharedLibraryDescriptor() {
            return true;
        }

        @Override
        public boolean isServiceEngineDescriptor() {
            return false;
        }

        @Override
        public boolean isBindingComponentDescriptor() {
            return false;
        }

        @Override
        public boolean isServiceAssemblyDescriptor() {
            return false;
        }

        public static SharedLibraryDD createSharedLibraryDD(Element slibEl) {
            return new SharedLibraryDD();
        }
    }
}

