/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.ServiceAssemblyStatisticsData;
import com.sun.esb.management.common.data.ServiceUnitStatisticsData;
import com.sun.esb.management.common.data.helper.ServiceAssemblyStatisticsDataXMLConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceAssemblyStatisticsDataReader
extends DefaultHandler
implements ServiceAssemblyStatisticsDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private String serviceAssemblyStatisticsDataListVersion;
    private String serviceUnitStatisticsDataListVersion;
    private ServiceAssemblyStatisticsData data;
    private Map<String, ServiceAssemblyStatisticsData> dataMap;
    private ServiceUnitStatisticsData unitData;
    private List<ServiceUnitStatisticsData> unitDataList;
    private List<String> endpointNameList;

    public Map<String, ServiceAssemblyStatisticsData> getServiceAssemblyStatisticsDataMap() {
        return this.dataMap;
    }

    @Override
    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
    }

    @Override
    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName != null) {
            if (qName.endsWith("ServiceAssemblyStatisticsDataList")) {
                if (attributes != null && attributes.getLength() > 0) {
                    String namespace = attributes.getValue("xmlns");
                    this.serviceAssemblyStatisticsDataListVersion = attributes.getValue("version");
                    if (this.serviceAssemblyStatisticsDataListVersion != null && "1.0".equals(this.serviceAssemblyStatisticsDataListVersion)) {
                        this.dataMap = new HashMap<String, ServiceAssemblyStatisticsData>();
                    }
                }
            } else if (qName.endsWith("ServiceAssemblyStatisticsData")) {
                if (this.dataMap != null) {
                    this.data = new ServiceAssemblyStatisticsData();
                }
            } else if (qName.endsWith("ServiceUnitStatisticsDataList")) {
                if (attributes != null && attributes.getLength() > 0) {
                    String namespace = attributes.getValue("xmlns");
                    this.serviceUnitStatisticsDataListVersion = attributes.getValue("version");
                    if (this.serviceUnitStatisticsDataListVersion != null && "1.0".equals(this.serviceUnitStatisticsDataListVersion) && this.dataMap != null && this.data != null) {
                        this.unitDataList = new ArrayList<ServiceUnitStatisticsData>();
                    }
                }
            } else if (qName.endsWith("ServiceUnitStatisticsData")) {
                if (this.dataMap != null && this.data != null && this.unitDataList != null) {
                    this.unitData = new ServiceUnitStatisticsData();
                }
            } else if (qName.endsWith("EndpointNameList") && this.dataMap != null && this.data != null && this.unitDataList != null && this.unitData != null) {
                this.endpointNameList = new ArrayList<String>();
            }
            this.qNameStack.push(qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if (qName.endsWith("InstanceName")) {
            if (this.dataMap != null && this.data != null) {
                this.data.setInstanceName(chars);
            }
        } else if (qName.endsWith("ServiceAssemblyName")) {
            if (this.dataMap != null && this.data != null) {
                this.data.setName(chars);
            }
        } else if (qName.endsWith("ServiceAssemblyLastStartupTime")) {
            Date value = null;
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
            try {
                value = format.parse(chars);
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (this.dataMap != null && this.data != null) {
                this.data.setLastStartupTime(value);
            }
        } else if (qName.endsWith("ServiceAssemblyShutdownTimeAverage")) {
            long value = Long.valueOf(chars);
            if (this.dataMap != null && this.data != null) {
                this.data.setShutdownTimeAverage(value);
            }
        } else if (qName.endsWith("ServiceAssemblyStartupTimeAverage")) {
            long value = Long.valueOf(chars);
            if (this.dataMap != null && this.data != null) {
                this.data.setStartupTimeAverage(value);
            }
        } else if (qName.endsWith("ServiceAssemblyStopTimeAverage")) {
            Long value = Long.valueOf(chars);
            if (this.dataMap != null && this.data != null) {
                this.data.setStopTimeAverage(value);
            }
        } else if (qName.endsWith("ServiceAssemblyUpTime")) {
            Long value = Long.valueOf(chars);
            if (this.dataMap != null && this.data != null) {
                this.data.setUpTime(value);
            }
        } else if (qName.endsWith("ServiceUnitName")) {
            if (this.dataMap != null && this.data != null && this.unitDataList != null && this.unitData != null) {
                this.unitData.setName(chars);
            }
        } else if (qName.endsWith("ServiceUnitShutdownTimeAverage")) {
            long value = Long.valueOf(chars);
            if (this.dataMap != null && this.data != null && this.unitDataList != null && this.unitData != null) {
                this.unitData.setShutdownTimeAverage(value);
            }
        } else if (qName.endsWith("ServiceUnitStartupTimeAverage")) {
            long value = Long.valueOf(chars);
            if (this.dataMap != null && this.data != null && this.unitDataList != null && this.unitData != null) {
                this.unitData.setStartupTimeAverage(value);
            }
        } else if (qName.endsWith("ServiceUnitStopTimeAverage")) {
            long value = Long.valueOf(chars);
            if (this.dataMap != null && this.data != null && this.unitDataList != null && this.unitData != null) {
                this.unitData.setStopTimeAverage(value);
            }
        } else if (qName.endsWith("EndpointName") && this.dataMap != null && this.data != null && this.unitDataList != null && this.unitData != null && this.endpointNameList != null) {
            this.endpointNameList.add(chars);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (qName != null) {
            if (qName.endsWith("ServiceAssemblyStatisticsData")) {
                if (this.dataMap != null && this.data != null) {
                    this.dataMap.put(this.data.getInstanceName(), this.data);
                    this.data = null;
                    this.unitDataList = null;
                    this.unitData = null;
                    this.endpointNameList = null;
                }
            } else if (qName.endsWith("ServiceUnitStatisticsDataList")) {
                if (this.dataMap != null && this.data != null && this.unitDataList != null) {
                    this.data.setServiceUnitStatisticsList(this.unitDataList);
                    this.unitDataList = null;
                    this.unitData = null;
                    this.endpointNameList = null;
                }
            } else if (qName.endsWith("ServiceUnitStatisticsData")) {
                if (this.dataMap != null && this.data != null && this.unitDataList != null && this.unitData != null) {
                    this.unitDataList.add(this.unitData);
                    this.unitData = null;
                    this.endpointNameList = null;
                }
            } else if (qName.endsWith("EndpointNameList") && this.dataMap != null && this.data != null && this.unitDataList != null && this.unitData != null && this.endpointNameList != null) {
                this.unitData.setEndpointNameList(this.endpointNameList);
                this.endpointNameList = null;
            }
        }
    }

    public static Map<String, ServiceAssemblyStatisticsData> parseFromXMLData(String rawXMLData) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        StringReader reader = new StringReader(rawXMLData);
        InputSource inputSource = new InputSource(reader);
        ServiceAssemblyStatisticsDataReader parser = new ServiceAssemblyStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getServiceAssemblyStatisticsDataMap();
    }

    public static Map<String, ServiceAssemblyStatisticsData> parseFromFile(String fileName) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        File file = new File(fileName);
        return ServiceAssemblyStatisticsDataReader.parseFromFile(file);
    }

    public static Map<String, ServiceAssemblyStatisticsData> parseFromFile(File file) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        FileInputStream inputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(inputStream);
        ServiceAssemblyStatisticsDataReader parser = new ServiceAssemblyStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getServiceAssemblyStatisticsDataMap();
    }

    public static Map<String, ServiceAssemblyStatisticsData> parseFromURI(String uriString) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        URI uri = new URI(uriString);
        return ServiceAssemblyStatisticsDataReader.parseFromURI(uri);
    }

    public static Map<String, ServiceAssemblyStatisticsData> parseFromURI(URI uri) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        InputStream inputStream = uri.toURL().openStream();
        InputSource inputSource = new InputSource(inputStream);
        ServiceAssemblyStatisticsDataReader parser = new ServiceAssemblyStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getServiceAssemblyStatisticsDataMap();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/assemblystatistics/ServiceAssemblyStatisticsData.xml";
        try {
            Map<String, ServiceAssemblyStatisticsData> map = null;
            map = ServiceAssemblyStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

