/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.FrameworkStatisticsData;
import com.sun.esb.management.common.data.helper.FrameworkStatisticsDataXMLConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FrameworkStatisticsDataReader
extends DefaultHandler
implements FrameworkStatisticsDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private String frameworkStatisticsDataListVersion;
    private FrameworkStatisticsData data;
    private Map<String, FrameworkStatisticsData> dataMap;

    public Map<String, FrameworkStatisticsData> getFrameworkStatisticsDataMap() {
        return this.dataMap;
    }

    @Override
    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
    }

    @Override
    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName != null) {
            if (qName.endsWith("FrameworkStatisticsDataList")) {
                if (attributes != null && attributes.getLength() > 0) {
                    String namespace = attributes.getValue("xmlns");
                    this.frameworkStatisticsDataListVersion = attributes.getValue("version");
                    if (this.frameworkStatisticsDataListVersion != null && "1.0".equals(this.frameworkStatisticsDataListVersion)) {
                        this.dataMap = new HashMap<String, FrameworkStatisticsData>();
                    }
                }
            } else if (qName.endsWith("FrameworkStatisticsData") && this.dataMap != null) {
                this.data = new FrameworkStatisticsData();
            }
            this.qNameStack.push(qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if (qName.endsWith("InstanceName")) {
            if (this.data != null) {
                this.data.setInstanceName(chars);
            }
        } else if (qName.endsWith("StartupTime")) {
            if (this.data != null) {
                long startupTime = Long.valueOf(chars);
                this.data.setStartupTime(startupTime);
            }
        } else if (qName.endsWith("UpTime") && this.data != null) {
            long upTime = Long.valueOf(chars);
            this.data.setUpTime(upTime);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (qName != null && qName.endsWith("FrameworkStatisticsData") && this.dataMap != null && this.data != null) {
            this.dataMap.put(this.data.getInstanceName(), this.data);
            this.data = null;
        }
    }

    public static Map<String, FrameworkStatisticsData> parseFromXMLData(String rawXMLData) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        StringReader reader = new StringReader(rawXMLData);
        InputSource inputSource = new InputSource(reader);
        FrameworkStatisticsDataReader parser = new FrameworkStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getFrameworkStatisticsDataMap();
    }

    public static Map<String, FrameworkStatisticsData> parseFromFile(String fileName) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        File file = new File(fileName);
        return FrameworkStatisticsDataReader.parseFromFile(file);
    }

    public static Map<String, FrameworkStatisticsData> parseFromFile(File file) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        FileInputStream inputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(inputStream);
        FrameworkStatisticsDataReader parser = new FrameworkStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getFrameworkStatisticsDataMap();
    }

    public static Map<String, FrameworkStatisticsData> parseFromURI(String uriString) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        URI uri = new URI(uriString);
        return FrameworkStatisticsDataReader.parseFromURI(uri);
    }

    public static Map<String, FrameworkStatisticsData> parseFromURI(URI uri) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        InputStream inputStream = uri.toURL().openStream();
        InputSource inputSource = new InputSource(inputStream);
        FrameworkStatisticsDataReader parser = new FrameworkStatisticsDataReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getFrameworkStatisticsDataMap();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/frameworkstatistics/FrameworkStatisticsData.xml";
        try {
            Map<String, FrameworkStatisticsData> map = null;
            map = FrameworkStatisticsDataReader.parseFromFile(uri);
            for (String instanceName : map.keySet()) {
                System.out.println(map.get(instanceName).getDisplayString());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

